/*******************************************************************************

Copyright (c) 2013 - 2015, Intel Corporation
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

 3. Neither the name of the Intel Corporation nor the names of its
    contributors may be used to endorse or promote products derived from
    this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/

#ifndef _AVF_REGISTER_H_
#define _AVF_REGISTER_H_


#define AVFMSIX_PBA1(_i)          (0x00002000 + ((_i) * 4)) /* _i=0...19 */ /* Reset: VFLR */
#define AVFMSIX_PBA1_MAX_INDEX    19
#define AVFMSIX_PBA1_PENBIT_SHIFT 0
#define AVFMSIX_PBA1_PENBIT_MASK  AVF_MASK(0xFFFFFFFF, AVFMSIX_PBA1_PENBIT_SHIFT)
#define AVFMSIX_TADD1(_i)              (0x00002100 + ((_i) * 16)) /* _i=0...639 */ /* Reset: VFLR */
#define AVFMSIX_TADD1_MAX_INDEX        639
#define AVFMSIX_TADD1_MSIXTADD10_SHIFT 0
#define AVFMSIX_TADD1_MSIXTADD10_MASK  AVF_MASK(0x3, AVFMSIX_TADD1_MSIXTADD10_SHIFT)
#define AVFMSIX_TADD1_MSIXTADD_SHIFT   2
#define AVFMSIX_TADD1_MSIXTADD_MASK    AVF_MASK(0x3FFFFFFF, AVFMSIX_TADD1_MSIXTADD_SHIFT)
#define AVFMSIX_TMSG1(_i)            (0x00002108 + ((_i) * 16)) /* _i=0...639 */ /* Reset: VFLR */
#define AVFMSIX_TMSG1_MAX_INDEX      639
#define AVFMSIX_TMSG1_MSIXTMSG_SHIFT 0
#define AVFMSIX_TMSG1_MSIXTMSG_MASK  AVF_MASK(0xFFFFFFFF, AVFMSIX_TMSG1_MSIXTMSG_SHIFT)
#define AVFMSIX_TUADD1(_i)             (0x00002104 + ((_i) * 16)) /* _i=0...639 */ /* Reset: VFLR */
#define AVFMSIX_TUADD1_MAX_INDEX       639
#define AVFMSIX_TUADD1_MSIXTUADD_SHIFT 0
#define AVFMSIX_TUADD1_MSIXTUADD_MASK  AVF_MASK(0xFFFFFFFF, AVFMSIX_TUADD1_MSIXTUADD_SHIFT)
#define AVFMSIX_TVCTRL1(_i)        (0x0000210C + ((_i) * 16)) /* _i=0...639 */ /* Reset: VFLR */
#define AVFMSIX_TVCTRL1_MAX_INDEX  639
#define AVFMSIX_TVCTRL1_MASK_SHIFT 0
#define AVFMSIX_TVCTRL1_MASK_MASK  AVF_MASK(0x1, AVFMSIX_TVCTRL1_MASK_SHIFT)
#define AVF_ARQBAH1              0x00006000 /* Reset: EMPR */
#define AVF_ARQBAH1_ARQBAH_SHIFT 0
#define AVF_ARQBAH1_ARQBAH_MASK  AVF_MASK(0xFFFFFFFF, AVF_ARQBAH1_ARQBAH_SHIFT)
#define AVF_ARQBAL1              0x00006C00 /* Reset: EMPR */
#define AVF_ARQBAL1_ARQBAL_SHIFT 0
#define AVF_ARQBAL1_ARQBAL_MASK  AVF_MASK(0xFFFFFFFF, AVF_ARQBAL1_ARQBAL_SHIFT)
#define AVF_ARQH1            0x00007400 /* Reset: EMPR */
#define AVF_ARQH1_ARQH_SHIFT 0
#define AVF_ARQH1_ARQH_MASK  AVF_MASK(0x3FF, AVF_ARQH1_ARQH_SHIFT)
#define AVF_ARQLEN1                 0x00008000 /* Reset: EMPR */
#define AVF_ARQLEN1_ARQLEN_SHIFT    0
#define AVF_ARQLEN1_ARQLEN_MASK     AVF_MASK(0x3FF, AVF_ARQLEN1_ARQLEN_SHIFT)
#define AVF_ARQLEN1_ARQVFE_SHIFT    28
#define AVF_ARQLEN1_ARQVFE_MASK     AVF_MASK(0x1, AVF_ARQLEN1_ARQVFE_SHIFT)
#define AVF_ARQLEN1_ARQOVFL_SHIFT   29
#define AVF_ARQLEN1_ARQOVFL_MASK    AVF_MASK(0x1, AVF_ARQLEN1_ARQOVFL_SHIFT)
#define AVF_ARQLEN1_ARQCRIT_SHIFT   30
#define AVF_ARQLEN1_ARQCRIT_MASK    AVF_MASK(0x1, AVF_ARQLEN1_ARQCRIT_SHIFT)
#define AVF_ARQLEN1_ARQENABLE_SHIFT 31
#define AVF_ARQLEN1_ARQENABLE_MASK  AVF_MASK(0x1, AVF_ARQLEN1_ARQENABLE_SHIFT)
#define AVF_ARQT1            0x00007000 /* Reset: EMPR */
#define AVF_ARQT1_ARQT_SHIFT 0
#define AVF_ARQT1_ARQT_MASK  AVF_MASK(0x3FF, AVF_ARQT1_ARQT_SHIFT)
#define AVF_ATQBAH1              0x00007800 /* Reset: EMPR */
#define AVF_ATQBAH1_ATQBAH_SHIFT 0
#define AVF_ATQBAH1_ATQBAH_MASK  AVF_MASK(0xFFFFFFFF, AVF_ATQBAH1_ATQBAH_SHIFT)
#define AVF_ATQBAL1              0x00007C00 /* Reset: EMPR */
#define AVF_ATQBAL1_ATQBAL_SHIFT 0
#define AVF_ATQBAL1_ATQBAL_MASK  AVF_MASK(0xFFFFFFFF, AVF_ATQBAL1_ATQBAL_SHIFT)
#define AVF_ATQH1            0x00006400 /* Reset: EMPR */
#define AVF_ATQH1_ATQH_SHIFT 0
#define AVF_ATQH1_ATQH_MASK  AVF_MASK(0x3FF, AVF_ATQH1_ATQH_SHIFT)
#define AVF_ATQLEN1                 0x00006800 /* Reset: EMPR */
#define AVF_ATQLEN1_ATQLEN_SHIFT    0
#define AVF_ATQLEN1_ATQLEN_MASK     AVF_MASK(0x3FF, AVF_ATQLEN1_ATQLEN_SHIFT)
#define AVF_ATQLEN1_ATQVFE_SHIFT    28
#define AVF_ATQLEN1_ATQVFE_MASK     AVF_MASK(0x1, AVF_ATQLEN1_ATQVFE_SHIFT)
#define AVF_ATQLEN1_ATQOVFL_SHIFT   29
#define AVF_ATQLEN1_ATQOVFL_MASK    AVF_MASK(0x1, AVF_ATQLEN1_ATQOVFL_SHIFT)
#define AVF_ATQLEN1_ATQCRIT_SHIFT   30
#define AVF_ATQLEN1_ATQCRIT_MASK    AVF_MASK(0x1, AVF_ATQLEN1_ATQCRIT_SHIFT)
#define AVF_ATQLEN1_ATQENABLE_SHIFT 31
#define AVF_ATQLEN1_ATQENABLE_MASK  AVF_MASK(0x1, AVF_ATQLEN1_ATQENABLE_SHIFT)
#define AVF_ATQT1            0x00008400 /* Reset: EMPR */
#define AVF_ATQT1_ATQT_SHIFT 0
#define AVF_ATQT1_ATQT_MASK  AVF_MASK(0x3FF, AVF_ATQT1_ATQT_SHIFT)
#define AVFGEN_RSTAT                 0x00008800 /* Reset: VFR */
#define AVFGEN_RSTAT_VFR_STATE_SHIFT 0
#define AVFGEN_RSTAT_VFR_STATE_MASK  AVF_MASK(0x3, AVFGEN_RSTAT_VFR_STATE_SHIFT)
#define AVFINT_DYN_CTL01                       0x00005C00 /* Reset: VFR */
#define AVFINT_DYN_CTL01_INTENA_SHIFT          0
#define AVFINT_DYN_CTL01_INTENA_MASK           AVF_MASK(0x1, AVFINT_DYN_CTL01_INTENA_SHIFT)
#define AVFINT_DYN_CTL01_CLEARPBA_SHIFT        1
#define AVFINT_DYN_CTL01_CLEARPBA_MASK         AVF_MASK(0x1, AVFINT_DYN_CTL01_CLEARPBA_SHIFT)
#define AVFINT_DYN_CTL01_SWINT_TRIG_SHIFT      2
#define AVFINT_DYN_CTL01_SWINT_TRIG_MASK       AVF_MASK(0x1, AVFINT_DYN_CTL01_SWINT_TRIG_SHIFT)
#define AVFINT_DYN_CTL01_ITR_INDX_SHIFT        3
#define AVFINT_DYN_CTL01_ITR_INDX_MASK         AVF_MASK(0x3, AVFINT_DYN_CTL01_ITR_INDX_SHIFT)
#define AVFINT_DYN_CTL01_INTERVAL_SHIFT        5
#define AVFINT_DYN_CTL01_INTERVAL_MASK         AVF_MASK(0xFFF, AVFINT_DYN_CTL01_INTERVAL_SHIFT)
#define AVFINT_DYN_CTL01_SW_ITR_INDX_ENA_SHIFT 24
#define AVFINT_DYN_CTL01_SW_ITR_INDX_ENA_MASK  AVF_MASK(0x1, AVFINT_DYN_CTL01_SW_ITR_INDX_ENA_SHIFT)
#define AVFINT_DYN_CTL01_SW_ITR_INDX_SHIFT     25
#define AVFINT_DYN_CTL01_SW_ITR_INDX_MASK      AVF_MASK(0x3, AVFINT_DYN_CTL01_SW_ITR_INDX_SHIFT)
#define AVFINT_DYN_CTL01_INTENA_MSK_SHIFT      31
#define AVFINT_DYN_CTL01_INTENA_MSK_MASK       AVF_MASK(0x1, AVFINT_DYN_CTL01_INTENA_MSK_SHIFT)
#define AVFINT_DYN_CTLN1(_INTVF)               (0x00003800 + ((_INTVF) * 4)) /* _i=0...15 */ /* Reset: VFR */
#define AVFINT_DYN_CTLN1_MAX_INDEX             15
#define AVFINT_DYN_CTLN1_INTENA_SHIFT          0
#define AVFINT_DYN_CTLN1_INTENA_MASK           AVF_MASK(0x1, AVFINT_DYN_CTLN1_INTENA_SHIFT)
#define AVFINT_DYN_CTLN1_CLEARPBA_SHIFT        1
#define AVFINT_DYN_CTLN1_CLEARPBA_MASK         AVF_MASK(0x1, AVFINT_DYN_CTLN1_CLEARPBA_SHIFT)
#define AVFINT_DYN_CTLN1_SWINT_TRIG_SHIFT      2
#define AVFINT_DYN_CTLN1_SWINT_TRIG_MASK       AVF_MASK(0x1, AVFINT_DYN_CTLN1_SWINT_TRIG_SHIFT)
#define AVFINT_DYN_CTLN1_ITR_INDX_SHIFT        3
#define AVFINT_DYN_CTLN1_ITR_INDX_MASK         AVF_MASK(0x3, AVFINT_DYN_CTLN1_ITR_INDX_SHIFT)
#define AVFINT_DYN_CTLN1_INTERVAL_SHIFT        5
#define AVFINT_DYN_CTLN1_INTERVAL_MASK         AVF_MASK(0xFFF, AVFINT_DYN_CTLN1_INTERVAL_SHIFT)
#define AVFINT_DYN_CTLN1_SW_ITR_INDX_ENA_SHIFT 24
#define AVFINT_DYN_CTLN1_SW_ITR_INDX_ENA_MASK  AVF_MASK(0x1, AVFINT_DYN_CTLN1_SW_ITR_INDX_ENA_SHIFT)
#define AVFINT_DYN_CTLN1_SW_ITR_INDX_SHIFT     25
#define AVFINT_DYN_CTLN1_SW_ITR_INDX_MASK      AVF_MASK(0x3, AVFINT_DYN_CTLN1_SW_ITR_INDX_SHIFT)
#define AVFINT_DYN_CTLN1_INTENA_MSK_SHIFT      31
#define AVFINT_DYN_CTLN1_INTENA_MSK_MASK       AVF_MASK(0x1, AVFINT_DYN_CTLN1_INTENA_MSK_SHIFT)
#define AVFINT_ICR0_ENA1                        0x00005000 /* Reset: CORER */
#define AVFINT_ICR0_ENA1_LINK_STAT_CHANGE_SHIFT 25
#define AVFINT_ICR0_ENA1_LINK_STAT_CHANGE_MASK  AVF_MASK(0x1, AVFINT_ICR0_ENA1_LINK_STAT_CHANGE_SHIFT)
#define AVFINT_ICR0_ENA1_ADMINQ_SHIFT           30
#define AVFINT_ICR0_ENA1_ADMINQ_MASK            AVF_MASK(0x1, AVFINT_ICR0_ENA1_ADMINQ_SHIFT)
#define AVFINT_ICR0_ENA1_RSVD_SHIFT             31
#define AVFINT_ICR0_ENA1_RSVD_MASK              AVF_MASK(0x1, AVFINT_ICR0_ENA1_RSVD_SHIFT)
#define AVFINT_ICR01                        0x00004800 /* Reset: CORER */
#define AVFINT_ICR01_INTEVENT_SHIFT         0
#define AVFINT_ICR01_INTEVENT_MASK          AVF_MASK(0x1, AVFINT_ICR01_INTEVENT_SHIFT)
#define AVFINT_ICR01_QUEUE_0_SHIFT          1
#define AVFINT_ICR01_QUEUE_0_MASK           AVF_MASK(0x1, AVFINT_ICR01_QUEUE_0_SHIFT)
#define AVFINT_ICR01_QUEUE_1_SHIFT          2
#define AVFINT_ICR01_QUEUE_1_MASK           AVF_MASK(0x1, AVFINT_ICR01_QUEUE_1_SHIFT)
#define AVFINT_ICR01_QUEUE_2_SHIFT          3
#define AVFINT_ICR01_QUEUE_2_MASK           AVF_MASK(0x1, AVFINT_ICR01_QUEUE_2_SHIFT)
#define AVFINT_ICR01_QUEUE_3_SHIFT          4
#define AVFINT_ICR01_QUEUE_3_MASK           AVF_MASK(0x1, AVFINT_ICR01_QUEUE_3_SHIFT)
#define AVFINT_ICR01_LINK_STAT_CHANGE_SHIFT 25
#define AVFINT_ICR01_LINK_STAT_CHANGE_MASK  AVF_MASK(0x1, AVFINT_ICR01_LINK_STAT_CHANGE_SHIFT)
#define AVFINT_ICR01_ADMINQ_SHIFT           30
#define AVFINT_ICR01_ADMINQ_MASK            AVF_MASK(0x1, AVFINT_ICR01_ADMINQ_SHIFT)
#define AVFINT_ICR01_SWINT_SHIFT            31
#define AVFINT_ICR01_SWINT_MASK             AVF_MASK(0x1, AVFINT_ICR01_SWINT_SHIFT)
#define AVFINT_ITR01(_i)            (0x00004C00 + ((_i) * 4)) /* _i=0...2 */ /* Reset: VFR */
#define AVFINT_ITR01_MAX_INDEX      2
#define AVFINT_ITR01_INTERVAL_SHIFT 0
#define AVFINT_ITR01_INTERVAL_MASK  AVF_MASK(0xFFF, AVFINT_ITR01_INTERVAL_SHIFT)
#define AVFINT_ITRN1(_i, _INTVF)     (0x00002800 + ((_i) * 64 + (_INTVF) * 4)) /* _i=0...2, _INTVF=0...15 */ /* Reset: VFR */
#define AVFINT_ITRN1_MAX_INDEX      2
#define AVFINT_ITRN1_INTERVAL_SHIFT 0
#define AVFINT_ITRN1_INTERVAL_MASK  AVF_MASK(0xFFF, AVFINT_ITRN1_INTERVAL_SHIFT)
#define AVFINT_STAT_CTL01                      0x00005400 /* Reset: CORER */
#define AVFINT_STAT_CTL01_OTHER_ITR_INDX_SHIFT 2
#define AVFINT_STAT_CTL01_OTHER_ITR_INDX_MASK  AVF_MASK(0x3, AVFINT_STAT_CTL01_OTHER_ITR_INDX_SHIFT)
#define AVF_QRX_TAIL1(_Q)        (0x00002000 + ((_Q) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define AVF_QRX_TAIL1_MAX_INDEX  15
#define AVF_QRX_TAIL1_TAIL_SHIFT 0
#define AVF_QRX_TAIL1_TAIL_MASK  AVF_MASK(0x1FFF, AVF_QRX_TAIL1_TAIL_SHIFT)
#define AVF_QTX_TAIL1(_Q)        (0x00000000 + ((_Q) * 4)) /* _i=0...15 */ /* Reset: PFR */
#define AVF_QTX_TAIL1_MAX_INDEX  15
#define AVF_QTX_TAIL1_TAIL_SHIFT 0
#define AVF_QTX_TAIL1_TAIL_MASK  AVF_MASK(0x1FFF, AVF_QTX_TAIL1_TAIL_SHIFT)
#define AVFMSIX_PBA              0x00002000 /* Reset: VFLR */
#define AVFMSIX_PBA_PENBIT_SHIFT 0
#define AVFMSIX_PBA_PENBIT_MASK  AVF_MASK(0xFFFFFFFF, AVFMSIX_PBA_PENBIT_SHIFT)
#define AVFMSIX_TADD(_i)              (0x00000000 + ((_i) * 16)) /* _i=0...16 */ /* Reset: VFLR */
#define AVFMSIX_TADD_MAX_INDEX        16
#define AVFMSIX_TADD_MSIXTADD10_SHIFT 0
#define AVFMSIX_TADD_MSIXTADD10_MASK  AVF_MASK(0x3, AVFMSIX_TADD_MSIXTADD10_SHIFT)
#define AVFMSIX_TADD_MSIXTADD_SHIFT   2
#define AVFMSIX_TADD_MSIXTADD_MASK    AVF_MASK(0x3FFFFFFF, AVFMSIX_TADD_MSIXTADD_SHIFT)
#define AVFMSIX_TMSG(_i)            (0x00000008 + ((_i) * 16)) /* _i=0...16 */ /* Reset: VFLR */
#define AVFMSIX_TMSG_MAX_INDEX      16
#define AVFMSIX_TMSG_MSIXTMSG_SHIFT 0
#define AVFMSIX_TMSG_MSIXTMSG_MASK  AVF_MASK(0xFFFFFFFF, AVFMSIX_TMSG_MSIXTMSG_SHIFT)
#define AVFMSIX_TUADD(_i)             (0x00000004 + ((_i) * 16)) /* _i=0...16 */ /* Reset: VFLR */
#define AVFMSIX_TUADD_MAX_INDEX       16
#define AVFMSIX_TUADD_MSIXTUADD_SHIFT 0
#define AVFMSIX_TUADD_MSIXTUADD_MASK  AVF_MASK(0xFFFFFFFF, AVFMSIX_TUADD_MSIXTUADD_SHIFT)
#define AVFMSIX_TVCTRL(_i)        (0x0000000C + ((_i) * 16)) /* _i=0...16 */ /* Reset: VFLR */
#define AVFMSIX_TVCTRL_MAX_INDEX  16
#define AVFMSIX_TVCTRL_MASK_SHIFT 0
#define AVFMSIX_TVCTRL_MASK_MASK  AVF_MASK(0x1, AVFMSIX_TVCTRL_MASK_SHIFT)
#define AVFCM_PE_ERRDATA                  0x0000DC00 /* Reset: VFR */
#define AVFCM_PE_ERRDATA_ERROR_CODE_SHIFT 0
#define AVFCM_PE_ERRDATA_ERROR_CODE_MASK  AVF_MASK(0xF, AVFCM_PE_ERRDATA_ERROR_CODE_SHIFT)
#define AVFCM_PE_ERRDATA_Q_TYPE_SHIFT     4
#define AVFCM_PE_ERRDATA_Q_TYPE_MASK      AVF_MASK(0x7, AVFCM_PE_ERRDATA_Q_TYPE_SHIFT)
#define AVFCM_PE_ERRDATA_Q_NUM_SHIFT      8
#define AVFCM_PE_ERRDATA_Q_NUM_MASK       AVF_MASK(0x3FFFF, AVFCM_PE_ERRDATA_Q_NUM_SHIFT)
#define AVFCM_PE_ERRINFO                     0x0000D800 /* Reset: VFR */
#define AVFCM_PE_ERRINFO_ERROR_VALID_SHIFT   0
#define AVFCM_PE_ERRINFO_ERROR_VALID_MASK    AVF_MASK(0x1, AVFCM_PE_ERRINFO_ERROR_VALID_SHIFT)
#define AVFCM_PE_ERRINFO_ERROR_INST_SHIFT    4
#define AVFCM_PE_ERRINFO_ERROR_INST_MASK     AVF_MASK(0x7, AVFCM_PE_ERRINFO_ERROR_INST_SHIFT)
#define AVFCM_PE_ERRINFO_DBL_ERROR_CNT_SHIFT 8
#define AVFCM_PE_ERRINFO_DBL_ERROR_CNT_MASK  AVF_MASK(0xFF, AVFCM_PE_ERRINFO_DBL_ERROR_CNT_SHIFT)
#define AVFCM_PE_ERRINFO_RLU_ERROR_CNT_SHIFT 16
#define AVFCM_PE_ERRINFO_RLU_ERROR_CNT_MASK  AVF_MASK(0xFF, AVFCM_PE_ERRINFO_RLU_ERROR_CNT_SHIFT)
#define AVFCM_PE_ERRINFO_RLS_ERROR_CNT_SHIFT 24
#define AVFCM_PE_ERRINFO_RLS_ERROR_CNT_MASK  AVF_MASK(0xFF, AVFCM_PE_ERRINFO_RLS_ERROR_CNT_SHIFT)
#define AVFQF_HENA(_i)             (0x0000C400 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define AVFQF_HENA_MAX_INDEX       1
#define AVFQF_HENA_PTYPE_ENA_SHIFT 0
#define AVFQF_HENA_PTYPE_ENA_MASK  AVF_MASK(0xFFFFFFFF, AVFQF_HENA_PTYPE_ENA_SHIFT)
#define AVFQF_HKEY(_i)         (0x0000CC00 + ((_i) * 4)) /* _i=0...12 */ /* Reset: CORER */
#define AVFQF_HKEY_MAX_INDEX   12
#define AVFQF_HKEY_KEY_0_SHIFT 0
#define AVFQF_HKEY_KEY_0_MASK  AVF_MASK(0xFF, AVFQF_HKEY_KEY_0_SHIFT)
#define AVFQF_HKEY_KEY_1_SHIFT 8
#define AVFQF_HKEY_KEY_1_MASK  AVF_MASK(0xFF, AVFQF_HKEY_KEY_1_SHIFT)
#define AVFQF_HKEY_KEY_2_SHIFT 16
#define AVFQF_HKEY_KEY_2_MASK  AVF_MASK(0xFF, AVFQF_HKEY_KEY_2_SHIFT)
#define AVFQF_HKEY_KEY_3_SHIFT 24
#define AVFQF_HKEY_KEY_3_MASK  AVF_MASK(0xFF, AVFQF_HKEY_KEY_3_SHIFT)
#define AVFQF_HLUT(_i)        (0x0000D000 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define AVFQF_HLUT_MAX_INDEX  15
#define AVFQF_HLUT_LUT0_SHIFT 0
#define AVFQF_HLUT_LUT0_MASK  AVF_MASK(0xF, AVFQF_HLUT_LUT0_SHIFT)
#define AVFQF_HLUT_LUT1_SHIFT 8
#define AVFQF_HLUT_LUT1_MASK  AVF_MASK(0xF, AVFQF_HLUT_LUT1_SHIFT)
#define AVFQF_HLUT_LUT2_SHIFT 16
#define AVFQF_HLUT_LUT2_MASK  AVF_MASK(0xF, AVFQF_HLUT_LUT2_SHIFT)
#define AVFQF_HLUT_LUT3_SHIFT 24
#define AVFQF_HLUT_LUT3_MASK  AVF_MASK(0xF, AVFQF_HLUT_LUT3_SHIFT)
#define AVFQF_HREGION(_i)                  (0x0000D400 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define AVFQF_HREGION_MAX_INDEX            7
#define AVFQF_HREGION_OVERRIDE_ENA_0_SHIFT 0
#define AVFQF_HREGION_OVERRIDE_ENA_0_MASK  AVF_MASK(0x1, AVFQF_HREGION_OVERRIDE_ENA_0_SHIFT)
#define AVFQF_HREGION_REGION_0_SHIFT       1
#define AVFQF_HREGION_REGION_0_MASK        AVF_MASK(0x7, AVFQF_HREGION_REGION_0_SHIFT)
#define AVFQF_HREGION_OVERRIDE_ENA_1_SHIFT 4
#define AVFQF_HREGION_OVERRIDE_ENA_1_MASK  AVF_MASK(0x1, AVFQF_HREGION_OVERRIDE_ENA_1_SHIFT)
#define AVFQF_HREGION_REGION_1_SHIFT       5
#define AVFQF_HREGION_REGION_1_MASK        AVF_MASK(0x7, AVFQF_HREGION_REGION_1_SHIFT)
#define AVFQF_HREGION_OVERRIDE_ENA_2_SHIFT 8
#define AVFQF_HREGION_OVERRIDE_ENA_2_MASK  AVF_MASK(0x1, AVFQF_HREGION_OVERRIDE_ENA_2_SHIFT)
#define AVFQF_HREGION_REGION_2_SHIFT       9
#define AVFQF_HREGION_REGION_2_MASK        AVF_MASK(0x7, AVFQF_HREGION_REGION_2_SHIFT)
#define AVFQF_HREGION_OVERRIDE_ENA_3_SHIFT 12
#define AVFQF_HREGION_OVERRIDE_ENA_3_MASK  AVF_MASK(0x1, AVFQF_HREGION_OVERRIDE_ENA_3_SHIFT)
#define AVFQF_HREGION_REGION_3_SHIFT       13
#define AVFQF_HREGION_REGION_3_MASK        AVF_MASK(0x7, AVFQF_HREGION_REGION_3_SHIFT)
#define AVFQF_HREGION_OVERRIDE_ENA_4_SHIFT 16
#define AVFQF_HREGION_OVERRIDE_ENA_4_MASK  AVF_MASK(0x1, AVFQF_HREGION_OVERRIDE_ENA_4_SHIFT)
#define AVFQF_HREGION_REGION_4_SHIFT       17
#define AVFQF_HREGION_REGION_4_MASK        AVF_MASK(0x7, AVFQF_HREGION_REGION_4_SHIFT)
#define AVFQF_HREGION_OVERRIDE_ENA_5_SHIFT 20
#define AVFQF_HREGION_OVERRIDE_ENA_5_MASK  AVF_MASK(0x1, AVFQF_HREGION_OVERRIDE_ENA_5_SHIFT)
#define AVFQF_HREGION_REGION_5_SHIFT       21
#define AVFQF_HREGION_REGION_5_MASK        AVF_MASK(0x7, AVFQF_HREGION_REGION_5_SHIFT)
#define AVFQF_HREGION_OVERRIDE_ENA_6_SHIFT 24
#define AVFQF_HREGION_OVERRIDE_ENA_6_MASK  AVF_MASK(0x1, AVFQF_HREGION_OVERRIDE_ENA_6_SHIFT)
#define AVFQF_HREGION_REGION_6_SHIFT       25
#define AVFQF_HREGION_REGION_6_MASK        AVF_MASK(0x7, AVFQF_HREGION_REGION_6_SHIFT)
#define AVFQF_HREGION_OVERRIDE_ENA_7_SHIFT 28
#define AVFQF_HREGION_OVERRIDE_ENA_7_MASK  AVF_MASK(0x1, AVFQF_HREGION_OVERRIDE_ENA_7_SHIFT)
#define AVFQF_HREGION_REGION_7_SHIFT       29
#define AVFQF_HREGION_REGION_7_MASK        AVF_MASK(0x7, AVFQF_HREGION_REGION_7_SHIFT)

#define AVFINT_DYN_CTL01_WB_ON_ITR_SHIFT       30
#define AVFINT_DYN_CTL01_WB_ON_ITR_MASK        AVF_MASK(0x1, AVFINT_DYN_CTL01_WB_ON_ITR_SHIFT)
#define AVFINT_DYN_CTLN1_WB_ON_ITR_SHIFT       30
#define AVFINT_DYN_CTLN1_WB_ON_ITR_MASK        AVF_MASK(0x1, AVFINT_DYN_CTLN1_WB_ON_ITR_SHIFT)
#define AVFPE_AEQALLOC1               0x0000A400 /* Reset: VFR */
#define AVFPE_AEQALLOC1_AECOUNT_SHIFT 0
#define AVFPE_AEQALLOC1_AECOUNT_MASK  AVF_MASK(0xFFFFFFFF, AVFPE_AEQALLOC1_AECOUNT_SHIFT)
#define AVFPE_CCQPHIGH1                  0x00009800 /* Reset: VFR */
#define AVFPE_CCQPHIGH1_PECCQPHIGH_SHIFT 0
#define AVFPE_CCQPHIGH1_PECCQPHIGH_MASK  AVF_MASK(0xFFFFFFFF, AVFPE_CCQPHIGH1_PECCQPHIGH_SHIFT)
#define AVFPE_CCQPLOW1                 0x0000AC00 /* Reset: VFR */
#define AVFPE_CCQPLOW1_PECCQPLOW_SHIFT 0
#define AVFPE_CCQPLOW1_PECCQPLOW_MASK  AVF_MASK(0xFFFFFFFF, AVFPE_CCQPLOW1_PECCQPLOW_SHIFT)
#define AVFPE_CCQPSTATUS1                   0x0000B800 /* Reset: VFR */
#define AVFPE_CCQPSTATUS1_CCQP_DONE_SHIFT   0
#define AVFPE_CCQPSTATUS1_CCQP_DONE_MASK    AVF_MASK(0x1, AVFPE_CCQPSTATUS1_CCQP_DONE_SHIFT)
#define AVFPE_CCQPSTATUS1_HMC_PROFILE_SHIFT 4
#define AVFPE_CCQPSTATUS1_HMC_PROFILE_MASK  AVF_MASK(0x7, AVFPE_CCQPSTATUS1_HMC_PROFILE_SHIFT)
#define AVFPE_CCQPSTATUS1_RDMA_EN_VFS_SHIFT 16
#define AVFPE_CCQPSTATUS1_RDMA_EN_VFS_MASK  AVF_MASK(0x3F, AVFPE_CCQPSTATUS1_RDMA_EN_VFS_SHIFT)
#define AVFPE_CCQPSTATUS1_CCQP_ERR_SHIFT    31
#define AVFPE_CCQPSTATUS1_CCQP_ERR_MASK     AVF_MASK(0x1, AVFPE_CCQPSTATUS1_CCQP_ERR_SHIFT)
#define AVFPE_CQACK1              0x0000B000 /* Reset: VFR */
#define AVFPE_CQACK1_PECQID_SHIFT 0
#define AVFPE_CQACK1_PECQID_MASK  AVF_MASK(0x1FFFF, AVFPE_CQACK1_PECQID_SHIFT)
#define AVFPE_CQARM1              0x0000B400 /* Reset: VFR */
#define AVFPE_CQARM1_PECQID_SHIFT 0
#define AVFPE_CQARM1_PECQID_MASK  AVF_MASK(0x1FFFF, AVFPE_CQARM1_PECQID_SHIFT)
#define AVFPE_CQPDB1              0x0000BC00 /* Reset: VFR */
#define AVFPE_CQPDB1_WQHEAD_SHIFT 0
#define AVFPE_CQPDB1_WQHEAD_MASK  AVF_MASK(0x7FF, AVFPE_CQPDB1_WQHEAD_SHIFT)
#define AVFPE_CQPERRCODES1                      0x00009C00 /* Reset: VFR */
#define AVFPE_CQPERRCODES1_CQP_MINOR_CODE_SHIFT 0
#define AVFPE_CQPERRCODES1_CQP_MINOR_CODE_MASK  AVF_MASK(0xFFFF, AVFPE_CQPERRCODES1_CQP_MINOR_CODE_SHIFT)
#define AVFPE_CQPERRCODES1_CQP_MAJOR_CODE_SHIFT 16
#define AVFPE_CQPERRCODES1_CQP_MAJOR_CODE_MASK  AVF_MASK(0xFFFF, AVFPE_CQPERRCODES1_CQP_MAJOR_CODE_SHIFT)
#define AVFPE_CQPTAIL1                  0x0000A000 /* Reset: VFR */
#define AVFPE_CQPTAIL1_WQTAIL_SHIFT     0
#define AVFPE_CQPTAIL1_WQTAIL_MASK      AVF_MASK(0x7FF, AVFPE_CQPTAIL1_WQTAIL_SHIFT)
#define AVFPE_CQPTAIL1_CQP_OP_ERR_SHIFT 31
#define AVFPE_CQPTAIL1_CQP_OP_ERR_MASK  AVF_MASK(0x1, AVFPE_CQPTAIL1_CQP_OP_ERR_SHIFT)
#define AVFPE_IPCONFIG01                        0x00008C00 /* Reset: VFR */
#define AVFPE_IPCONFIG01_PEIPID_SHIFT           0
#define AVFPE_IPCONFIG01_PEIPID_MASK            AVF_MASK(0xFFFF, AVFPE_IPCONFIG01_PEIPID_SHIFT)
#define AVFPE_IPCONFIG01_USEENTIREIDRANGE_SHIFT 16
#define AVFPE_IPCONFIG01_USEENTIREIDRANGE_MASK  AVF_MASK(0x1, AVFPE_IPCONFIG01_USEENTIREIDRANGE_SHIFT)
#define AVFPE_MRTEIDXMASK1                       0x00009000 /* Reset: VFR */
#define AVFPE_MRTEIDXMASK1_MRTEIDXMASKBITS_SHIFT 0
#define AVFPE_MRTEIDXMASK1_MRTEIDXMASKBITS_MASK  AVF_MASK(0x1F, AVFPE_MRTEIDXMASK1_MRTEIDXMASKBITS_SHIFT)
#define AVFPE_RCVUNEXPECTEDERROR1                        0x00009400 /* Reset: VFR */
#define AVFPE_RCVUNEXPECTEDERROR1_TCP_RX_UNEXP_ERR_SHIFT 0
#define AVFPE_RCVUNEXPECTEDERROR1_TCP_RX_UNEXP_ERR_MASK  AVF_MASK(0xFFFFFF, AVFPE_RCVUNEXPECTEDERROR1_TCP_RX_UNEXP_ERR_SHIFT)
#define AVFPE_TCPNOWTIMER1               0x0000A800 /* Reset: VFR */
#define AVFPE_TCPNOWTIMER1_TCP_NOW_SHIFT 0
#define AVFPE_TCPNOWTIMER1_TCP_NOW_MASK  AVF_MASK(0xFFFFFFFF, AVFPE_TCPNOWTIMER1_TCP_NOW_SHIFT)
#define AVFPE_WQEALLOC1                      0x0000C000 /* Reset: VFR */
#define AVFPE_WQEALLOC1_PEQPID_SHIFT         0
#define AVFPE_WQEALLOC1_PEQPID_MASK          AVF_MASK(0x3FFFF, AVFPE_WQEALLOC1_PEQPID_SHIFT)
#define AVFPE_WQEALLOC1_WQE_DESC_INDEX_SHIFT 20
#define AVFPE_WQEALLOC1_WQE_DESC_INDEX_MASK  AVF_MASK(0xFFF, AVFPE_WQEALLOC1_WQE_DESC_INDEX_SHIFT)

#endif /* _AVF_REGISTER_H_ */
