# 2022-04-12 Triage Log

A week with a large amount of changes in rollups, which makes performance triage difficult. The performance team and the infra team are working on finding ways to automate marking PRs as likely a poor choice for rolling up. Otherwise, the week overall saw a ~1% improvement in incremental check builds, with smaller improvements to incremental debug and release builds. A number of benchmarks have been updated in the last few weeks, which has meant a decrease in the automated noise assessment's algorithm performance, but that should settle out to steady state behavior on its own in the next few days.

Triage done by **@simulacrum**.
Revision range: [949b98cab8a186b98bf87e64374b8d0848c55271..4e1927db3c399fa34dc71992bd5dbec09f945c3d](https://perf.rust-lang.org/?start=949b98cab8a186b98bf87e64374b8d0848c55271&end=4e1927db3c399fa34dc71992bd5dbec09f945c3d&absolute=false&stat=instructions%3Au)

5 Regressions, 4 Improvements, 7 Mixed; 7 of them in rollups
50 artifact comparisons made in total

#### Regressions

Update libc to 0.2.121 [#95688](https://github.com/rust-lang/rust/pull/95688) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2310da432ca1c3e87f1d17e069f2336f2d4939e5&end=846993ec43c615c64a0496d3eb3c8615830842e4&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 8 | 19 | 0 | 0 | 8 |
| mean | 1.2% | 0.9% | N/A | N/A | 1.2% |
| max | 1.2% | 1.2% | N/A | N/A | 1.2% |
* This is pretty likely to just be natural increases in compile times when key dependencies like libc increase in size.

Rollup of 6 pull requests [#95840](https://github.com/rust-lang/rust/pull/95840) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=399dd8049d4b27329350937e3e17077205bdc0bf&end=fbdb10f9fabe47eb763cb4b52b5721740cc63783&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 10 | 21 | 0 | 3 | 10 |
| mean | 0.6% | 0.9% | N/A | -0.4% | 0.6% |
| max | 1.2% | 1.3% | N/A | -0.5% | 1.2% |
* Primarily limited to doc builds, seems likely to be caused by #95769.

Rollup of 7 pull requests [#95889](https://github.com/rust-lang/rust/pull/95889) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=027a232755fa9728e9699337267f6675dfd0a8ba&end=1f7fb6413d6d6c0c929b223e478e44c3db991b03&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 5 | 0 | 0 | 0 | 5 |
| mean | 0.3% | N/A | N/A | N/A | 0.3% |
| max | 0.5% | N/A | N/A | N/A | 0.5% |
* Unclear cause, and fairly small regression. Given this is a rollup likely not worth the time to investigate -- benefit/cost tradeoff is not worth it.

Faster parsing for lower numbers for radix up to 16 (cont.) [#95399](https://github.com/rust-lang/rust/pull/95399) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b8f4cb6231dc7d4ff9afe62de798af0dc18ae835&end=4e1927db3c399fa34dc71992bd5dbec09f945c3d&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 14 | 0 | 0 | 0 |
| mean | N/A | 0.3% | N/A | N/A | N/A |
| max | N/A | 0.5% | N/A | N/A | N/A |
* Unclear that this will be an easy regression to investigate, changes are pretty extensive, and justification slim beyond theoretical microbenchmarks.

Rollup of 7 pull requests [#95855](https://github.com/rust-lang/rust/pull/95855) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c1fb2eb23964b56bd279b12aa925935d8559870&end=8bf93e9b6791acee3a594ed202fdfe45ad9952b5&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 9 | 5 | 1 | 5 |
| mean | N/A | 1.0% | -0.8% | -1.0% | -0.8% |
| max | N/A | 1.7% | -1.1% | -1.0% | -1.1% |

#### Improvements

Call `compute_locs` once per rule [#95669](https://github.com/rust-lang/rust/pull/95669) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b6ab1fae73a14db17a59e81c532a2b8f048ac159&end=c2afaba465e0bf44b9b37beba8d908b78dcdadc7&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 23 | 10 | 23 |
| mean | N/A | N/A | -1.4% | -1.3% | -1.4% |
| max | N/A | N/A | -3.5% | -3.4% | -3.5% |

Shrink `Nonterminal` [#95715](https://github.com/rust-lang/rust/pull/95715) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ed6c958ee4bf081deec951996ace9c508360c1d9&end=fa723160318fac5f3fa6f4141cfc41c0606a3008&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 1 | 0 | 4 | 0 |
| mean | N/A | 0.3% | N/A | -0.3% | N/A |
| max | N/A | 0.3% | N/A | -0.5% | N/A |
* This was originally categorized as a mixed change, and even though there is a regression, it seems overall to be an improvement if anything.

rustdoc: Early doc link resolution fixes and refactorings [#95706](https://github.com/rust-lang/rust/pull/95706) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fa723160318fac5f3fa6f4141cfc41c0606a3008&end=dd38eea722c1f6f970a314435533e91cc2c14ffb&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 2 | 6 | 3 | 10 | 5 |
| mean | 0.4% | 1.2% | -13.9% | -16.4% | -8.2% |
| max | 0.4% | 1.3% | -24.5% | -24.3% | -24.5% |
* This change has a few regressions, but those are likely to be unrelated noise. The improvements are large and significant.

CI: update `rustc-perf` version used in CI and also the corresponding PGO benchmarks [#95724](https://github.com/rust-lang/rust/pull/95724) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4bb685e4714a2b310774f45c3d023d1743de8bd0&end=399dd8049d4b27329350937e3e17077205bdc0bf&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 13 | 102 | 101 | 102 |
| mean | N/A | 1.0% | -0.7% | -1.0% | -0.7% |
| max | N/A | 1.3% | -2.2% | -2.7% | -2.2% |
* Overall a slight improvement, likely from better data due to updated benchmarks.


#### Mixed

Rollup of 5 pull requests [#95667](https://github.com/rust-lang/rust/pull/95667) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=949b98cab8a186b98bf87e64374b8d0848c55271&end=634770c0a7f8598164ab825cfe419cc8b03c36e5&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 17 | 39 | 14 | 0 | 31 |
| mean | 6.2% | 7.9% | -0.8% | N/A | 3.1% |
| max | 39.4% | 38.9% | -1.6% | N/A | 39.4% |
* Investigation shows this regression to be primarily caused by new support for diagnostic translations; investigation is ongoing, but it sounds like there are ways to claw back some of the performance hit.

Rollup of 8 pull requests [#95702](https://github.com/rust-lang/rust/pull/95702) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=306ba8357fb36212b7d30efb9eb9e41659ac1445&end=bbe9d27b8ff36da56638aa43d6d0cdfdf89a4e57&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 2 | 6 | 2 | 6 | 4 |
| mean | 0.3% | 1.1% | -0.2% | -0.4% | 0.1% |
| max | 0.4% | 1.2% | -0.2% | -0.7% | 0.4% |
* Unclear cause. Regression *might* be noise, but it's hard to say -- the keccak benchmark is in line with the ~1% noise we've seen elsewhere this week, but the other benchmarks (particularly in the primary category) seem potentially less likely to be noise. deep-vector is also affected.

Rollup of 6 pull requests [#95742](https://github.com/rust-lang/rust/pull/95742) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c2afaba465e0bf44b9b37beba8d908b78dcdadc7&end=8f36334ca939a67cce3f37f24953ff6f2d3f3d33&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 6 | 31 | 12 | 10 | 18 |
| mean | 0.4% | 0.5% | -0.6% | -0.4% | -0.3% |
| max | 0.7% | 0.8% | -2.4% | -0.6% | -2.4% |
* Fairly large number of benchmarks showing small-ish changes, both positive and negative. Cause is unclear.

Avoid accessing HIR from MIR passes [#95487](https://github.com/rust-lang/rust/pull/95487) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=18f32b73bdb3833c18c73fe3062bde8e1721ccca&end=027a232755fa9728e9699337267f6675dfd0a8ba&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 9 | 1 | 0 | 1 |
| mean | N/A | 0.5% | -0.6% | N/A | -0.6% |
| max | N/A | 0.9% | -0.6% | N/A | -0.6% |

Add new `Deinit` statement [#95125](https://github.com/rust-lang/rust/pull/95125) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=43998d544108b613c4631ed60249880167e8aafc&end=625e4dd13a3abd0cc59807af66c3c4cd63440852&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 27 | 39 | 4 | 17 | 31 |
| mean | 0.5% | 1.4% | -0.9% | -1.0% | 0.3% |
| max | 1.6% | 4.1% | -1.4% | -2.2% | 1.6% |

Rollup of 7 pull requests [#95944](https://github.com/rust-lang/rust/pull/95944) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=90ca44752a79dd414d9a0ccf7a74533a99080988&end=de392c7d31602ddf0fae1143c5ad822a1abe89df&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 6 | 5 | 9 | 5 |
| mean | N/A | 0.4% | -0.2% | -0.5% | -0.2% |
| max | N/A | 0.5% | -0.4% | -1.8% | -0.4% |


Respect -Z verify-llvm-ir and other flags that add extra passes when combined with -C no-prepopulate-passes in the new LLVM Pass Manager. [#95893](https://github.com/rust-lang/rust/pull/95893) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=36f4ded69eb50c080991d624b7cd7f40466cea25&end=b8f4cb6231dc7d4ff9afe62de798af0dc18ae835&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 3 | 0 | 6 | 0 |
| mean | N/A | 0.5% | N/A | -0.4% | N/A |
| max | N/A | 0.6% | N/A | -0.5% | N/A |