### 1008 - Parameter Property Added

**Description**: Checks whether a new property is configured to a cmd's parameter. 

**Analysis**: Not all newly configured properties for a cmd's parameter are considered breaking changes. The properties listed in PARA_PROPERTY_ADD_BREAK_LIST below are thought to influence or interrupt current workflow and be breaking changes. 
* PARA_PROPERTY_ADD_BREAK_LIST = ["required", "choices"]

**Example**: In new cli version, `required` is being added to `resource_group_name` of cmd `az monitor private-link-scope scoped-resource delete` which caused corrupt workflows.

#### Before
```json5
{
  "module_name": "monitor",
  "name": "az",
  "commands": {},
  "sub_groups": {
      "monitor": {
          "name": "monitor",
          "commands": {},
          "sub_groups": {
              "monitor private-link-scope": {
                  "name": "monitor private-link-scope",
                  "commands": {},
                  "sub_groups": {
                      "monitor private-link-scope scoped-resource": {
                          "name": "monitor private-link-scope scoped-resource",
                          "commands": {
                              "monitor private-link-scope scoped-resource delete": {
                                  "name": "monitor private-link-scope scoped-resource delete",
                                  "is_aaz": false,
                                  "is_preview": true,
                                  "parameters": [
                                    {
                                      "name": "resource_group_name",
                                      "options": ["--resource-group", "-g"],
                                      "id_part": "resource_group"
                                    }
                                    ...
                                    ...
                                  ]
                              }
                          }
                      }
                  }
              }
          }
      },
    ...
  }
}
```

#### After 
```json5
{
  "module_name": "monitor",
  "name": "az",
  "commands": {},
  "sub_groups": {
      "monitor": {
          "name": "monitor",
          "commands": {},
          "sub_groups": {
              "monitor private-link-scope": {
                  "name": "monitor private-link-scope",
                  "commands": {},
                  "sub_groups": {
                      "monitor private-link-scope scoped-resource": {
                          "name": "monitor private-link-scope scoped-resource",
                          "commands": {
                              "monitor private-link-scope scoped-resource delete": {
                                  "name": "monitor private-link-scope scoped-resource delete",
                                  "is_aaz": false,
                                  "is_preview": true,
                                  "parameters": [
                                    {
                                      "name": "resource_group_name",
                                      "options": ["--resource-group", "-g"],
                                      "required": true,
                                      "id_part": "resource_group"
                                    }
                                    ...
                                    ...
                                  ]
                              }
                          }
                      }
                  }
              }
          }
      },
    ...
  }
}
```

