# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "cdn profile deployment-version compare",
)
class Compare(AAZCommand):
    """Compare the deployment version to another deployment version

    :example: DeploymentVersions_Compare
        az cdn profile deployment-version compare --resource-group RG --profile-name profile1 --version-name dv1 --compare-to VersionName2
    """

    _aaz_info = {
        "version": "2025-05-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.cdn/profiles/{}/deploymentversions/{}/compare", "2025-05-01-preview"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.profile_name = AAZStrArg(
            options=["--profile-name"],
            help="Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the resource group.",
            required=True,
            id_part="name",
            fmt=AAZStrArgFormat(
                pattern="^[a-zA-Z0-9]+(-*[a-zA-Z0-9])*$",
                max_length=260,
                min_length=1,
            ),
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.version_name = AAZStrArg(
            options=["--version-name"],
            help="Name of the DeploymentVersion under the profile.",
            required=True,
            id_part="child_name_1",
            fmt=AAZStrArgFormat(
                pattern="^[a-zA-Z0-9]+(-*[a-zA-Z0-9])*$",
                max_length=260,
                min_length=1,
            ),
        )

        # define Arg Group "CompareDeploymentVersionsParameter"

        _args_schema = cls._args_schema
        _args_schema.compare_to = AAZStrArg(
            options=["--compare-to"],
            arg_group="CompareDeploymentVersionsParameter",
            help="the deployment version name to be compared to",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.DeploymentVersionsCompare(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class DeploymentVersionsCompare(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/deploymentVersions/{versionName}/compare",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "profileName", self.ctx.args.profile_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "versionName", self.ctx.args.version_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-05-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("compareTo", AAZStrType, ".compare_to", typ_kwargs={"flags": {"required": True}})

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.value = AAZListType(
                flags={"required": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.resource_id = AAZStrType(
                serialized_name="resourceId",
            )
            _element.resource_name = AAZStrType(
                serialized_name="resourceName",
            )
            _element.resource_type = AAZStrType(
                serialized_name="resourceType",
                flags={"required": True},
            )

            disc_microsoft__cdn_profiles_afd_endpoints_routes = cls._schema_on_200.value.Element.discriminate_by("resource_type", "Microsoft.Cdn/profiles/afdEndpoints/routes")
            disc_microsoft__cdn_profiles_afd_endpoints_routes.current_properties = AAZObjectType(
                serialized_name="currentProperties",
            )
            _CompareHelper._build_schema_route_properties_read(disc_microsoft__cdn_profiles_afd_endpoints_routes.current_properties)
            disc_microsoft__cdn_profiles_afd_endpoints_routes.previous_properties = AAZObjectType(
                serialized_name="previousProperties",
            )
            _CompareHelper._build_schema_route_properties_read(disc_microsoft__cdn_profiles_afd_endpoints_routes.previous_properties)

            disc_microsoft__cdn_profiles_origin_groups = cls._schema_on_200.value.Element.discriminate_by("resource_type", "Microsoft.Cdn/profiles/originGroups")
            disc_microsoft__cdn_profiles_origin_groups.current_properties = AAZObjectType(
                serialized_name="currentProperties",
            )
            _CompareHelper._build_schema_afd_origin_group_properties_read(disc_microsoft__cdn_profiles_origin_groups.current_properties)
            disc_microsoft__cdn_profiles_origin_groups.previous_properties = AAZObjectType(
                serialized_name="previousProperties",
            )
            _CompareHelper._build_schema_afd_origin_group_properties_read(disc_microsoft__cdn_profiles_origin_groups.previous_properties)

            disc_microsoft__cdn_profiles_origin_groups_origins = cls._schema_on_200.value.Element.discriminate_by("resource_type", "Microsoft.Cdn/profiles/originGroups/origins")
            disc_microsoft__cdn_profiles_origin_groups_origins.current_properties = AAZObjectType(
                serialized_name="currentProperties",
            )
            _CompareHelper._build_schema_afd_origin_properties_read(disc_microsoft__cdn_profiles_origin_groups_origins.current_properties)
            disc_microsoft__cdn_profiles_origin_groups_origins.previous_properties = AAZObjectType(
                serialized_name="previousProperties",
            )
            _CompareHelper._build_schema_afd_origin_properties_read(disc_microsoft__cdn_profiles_origin_groups_origins.previous_properties)

            disc_microsoft__cdn_profiles_rule_sets = cls._schema_on_200.value.Element.discriminate_by("resource_type", "Microsoft.Cdn/profiles/ruleSets")
            disc_microsoft__cdn_profiles_rule_sets.current_properties = AAZObjectType(
                serialized_name="currentProperties",
            )
            _CompareHelper._build_schema_rule_set_properties_read(disc_microsoft__cdn_profiles_rule_sets.current_properties)
            disc_microsoft__cdn_profiles_rule_sets.previous_properties = AAZObjectType(
                serialized_name="previousProperties",
            )
            _CompareHelper._build_schema_rule_set_properties_read(disc_microsoft__cdn_profiles_rule_sets.previous_properties)

            disc_microsoft__cdn_profiles_rule_sets_rules = cls._schema_on_200.value.Element.discriminate_by("resource_type", "Microsoft.Cdn/profiles/ruleSets/rules")
            disc_microsoft__cdn_profiles_rule_sets_rules.current_properties = AAZObjectType(
                serialized_name="currentProperties",
            )
            _CompareHelper._build_schema_rule_properties_read(disc_microsoft__cdn_profiles_rule_sets_rules.current_properties)
            disc_microsoft__cdn_profiles_rule_sets_rules.previous_properties = AAZObjectType(
                serialized_name="previousProperties",
            )
            _CompareHelper._build_schema_rule_properties_read(disc_microsoft__cdn_profiles_rule_sets_rules.previous_properties)

            disc_microsoft__cdn_profiles_security_policies = cls._schema_on_200.value.Element.discriminate_by("resource_type", "Microsoft.Cdn/profiles/securityPolicies")
            disc_microsoft__cdn_profiles_security_policies.current_properties = AAZObjectType(
                serialized_name="currentProperties",
            )
            _CompareHelper._build_schema_security_policy_properties_with_embedded_waf_policy_read(disc_microsoft__cdn_profiles_security_policies.current_properties)
            disc_microsoft__cdn_profiles_security_policies.previous_properties = AAZObjectType(
                serialized_name="previousProperties",
            )
            _CompareHelper._build_schema_security_policy_properties_with_embedded_waf_policy_read(disc_microsoft__cdn_profiles_security_policies.previous_properties)

            return cls._schema_on_200


class _CompareHelper:
    """Helper class for Compare"""

    _schema_afd_origin_group_properties_read = None

    @classmethod
    def _build_schema_afd_origin_group_properties_read(cls, _schema):
        if cls._schema_afd_origin_group_properties_read is not None:
            _schema.deployment_status = cls._schema_afd_origin_group_properties_read.deployment_status
            _schema.health_probe_settings = cls._schema_afd_origin_group_properties_read.health_probe_settings
            _schema.load_balancing_settings = cls._schema_afd_origin_group_properties_read.load_balancing_settings
            _schema.profile_name = cls._schema_afd_origin_group_properties_read.profile_name
            _schema.provisioning_state = cls._schema_afd_origin_group_properties_read.provisioning_state
            _schema.session_affinity_state = cls._schema_afd_origin_group_properties_read.session_affinity_state
            _schema.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = cls._schema_afd_origin_group_properties_read.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
            return

        cls._schema_afd_origin_group_properties_read = _schema_afd_origin_group_properties_read = AAZObjectType()

        afd_origin_group_properties_read = _schema_afd_origin_group_properties_read
        afd_origin_group_properties_read.deployment_status = AAZStrType(
            serialized_name="deploymentStatus",
            flags={"read_only": True},
        )
        afd_origin_group_properties_read.health_probe_settings = AAZObjectType(
            serialized_name="healthProbeSettings",
        )
        afd_origin_group_properties_read.load_balancing_settings = AAZObjectType(
            serialized_name="loadBalancingSettings",
        )
        afd_origin_group_properties_read.profile_name = AAZStrType(
            serialized_name="profileName",
            flags={"read_only": True},
        )
        afd_origin_group_properties_read.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        afd_origin_group_properties_read.session_affinity_state = AAZStrType(
            serialized_name="sessionAffinityState",
        )
        afd_origin_group_properties_read.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = AAZIntType(
            serialized_name="trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
        )

        health_probe_settings = _schema_afd_origin_group_properties_read.health_probe_settings
        health_probe_settings.probe_interval_in_seconds = AAZIntType(
            serialized_name="probeIntervalInSeconds",
        )
        health_probe_settings.probe_path = AAZStrType(
            serialized_name="probePath",
        )
        health_probe_settings.probe_protocol = AAZStrType(
            serialized_name="probeProtocol",
        )
        health_probe_settings.probe_request_type = AAZStrType(
            serialized_name="probeRequestType",
        )

        load_balancing_settings = _schema_afd_origin_group_properties_read.load_balancing_settings
        load_balancing_settings.additional_latency_in_milliseconds = AAZIntType(
            serialized_name="additionalLatencyInMilliseconds",
        )
        load_balancing_settings.sample_size = AAZIntType(
            serialized_name="sampleSize",
        )
        load_balancing_settings.successful_samples_required = AAZIntType(
            serialized_name="successfulSamplesRequired",
        )

        _schema.deployment_status = cls._schema_afd_origin_group_properties_read.deployment_status
        _schema.health_probe_settings = cls._schema_afd_origin_group_properties_read.health_probe_settings
        _schema.load_balancing_settings = cls._schema_afd_origin_group_properties_read.load_balancing_settings
        _schema.profile_name = cls._schema_afd_origin_group_properties_read.profile_name
        _schema.provisioning_state = cls._schema_afd_origin_group_properties_read.provisioning_state
        _schema.session_affinity_state = cls._schema_afd_origin_group_properties_read.session_affinity_state
        _schema.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = cls._schema_afd_origin_group_properties_read.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes

    _schema_afd_origin_properties_read = None

    @classmethod
    def _build_schema_afd_origin_properties_read(cls, _schema):
        if cls._schema_afd_origin_properties_read is not None:
            _schema.azure_origin = cls._schema_afd_origin_properties_read.azure_origin
            _schema.deployment_status = cls._schema_afd_origin_properties_read.deployment_status
            _schema.enabled_state = cls._schema_afd_origin_properties_read.enabled_state
            _schema.enforce_certificate_name_check = cls._schema_afd_origin_properties_read.enforce_certificate_name_check
            _schema.host_name = cls._schema_afd_origin_properties_read.host_name
            _schema.http_port = cls._schema_afd_origin_properties_read.http_port
            _schema.https_port = cls._schema_afd_origin_properties_read.https_port
            _schema.origin_group_name = cls._schema_afd_origin_properties_read.origin_group_name
            _schema.origin_host_header = cls._schema_afd_origin_properties_read.origin_host_header
            _schema.priority = cls._schema_afd_origin_properties_read.priority
            _schema.provisioning_state = cls._schema_afd_origin_properties_read.provisioning_state
            _schema.shared_private_link_resource = cls._schema_afd_origin_properties_read.shared_private_link_resource
            _schema.weight = cls._schema_afd_origin_properties_read.weight
            return

        cls._schema_afd_origin_properties_read = _schema_afd_origin_properties_read = AAZObjectType()

        afd_origin_properties_read = _schema_afd_origin_properties_read
        afd_origin_properties_read.azure_origin = AAZObjectType(
            serialized_name="azureOrigin",
        )
        cls._build_schema_resource_reference_read(afd_origin_properties_read.azure_origin)
        afd_origin_properties_read.deployment_status = AAZStrType(
            serialized_name="deploymentStatus",
            flags={"read_only": True},
        )
        afd_origin_properties_read.enabled_state = AAZStrType(
            serialized_name="enabledState",
        )
        afd_origin_properties_read.enforce_certificate_name_check = AAZBoolType(
            serialized_name="enforceCertificateNameCheck",
        )
        afd_origin_properties_read.host_name = AAZStrType(
            serialized_name="hostName",
            flags={"required": True},
        )
        afd_origin_properties_read.http_port = AAZIntType(
            serialized_name="httpPort",
        )
        afd_origin_properties_read.https_port = AAZIntType(
            serialized_name="httpsPort",
        )
        afd_origin_properties_read.origin_group_name = AAZStrType(
            serialized_name="originGroupName",
            flags={"read_only": True},
        )
        afd_origin_properties_read.origin_host_header = AAZStrType(
            serialized_name="originHostHeader",
        )
        afd_origin_properties_read.priority = AAZIntType()
        afd_origin_properties_read.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        afd_origin_properties_read.shared_private_link_resource = AAZObjectType(
            serialized_name="sharedPrivateLinkResource",
        )
        afd_origin_properties_read.weight = AAZIntType()

        shared_private_link_resource = _schema_afd_origin_properties_read.shared_private_link_resource
        shared_private_link_resource.group_id = AAZStrType(
            serialized_name="groupId",
        )
        shared_private_link_resource.private_link = AAZObjectType(
            serialized_name="privateLink",
        )
        cls._build_schema_resource_reference_read(shared_private_link_resource.private_link)
        shared_private_link_resource.private_link_location = AAZStrType(
            serialized_name="privateLinkLocation",
        )
        shared_private_link_resource.request_message = AAZStrType(
            serialized_name="requestMessage",
        )
        shared_private_link_resource.status = AAZStrType()

        _schema.azure_origin = cls._schema_afd_origin_properties_read.azure_origin
        _schema.deployment_status = cls._schema_afd_origin_properties_read.deployment_status
        _schema.enabled_state = cls._schema_afd_origin_properties_read.enabled_state
        _schema.enforce_certificate_name_check = cls._schema_afd_origin_properties_read.enforce_certificate_name_check
        _schema.host_name = cls._schema_afd_origin_properties_read.host_name
        _schema.http_port = cls._schema_afd_origin_properties_read.http_port
        _schema.https_port = cls._schema_afd_origin_properties_read.https_port
        _schema.origin_group_name = cls._schema_afd_origin_properties_read.origin_group_name
        _schema.origin_host_header = cls._schema_afd_origin_properties_read.origin_host_header
        _schema.priority = cls._schema_afd_origin_properties_read.priority
        _schema.provisioning_state = cls._schema_afd_origin_properties_read.provisioning_state
        _schema.shared_private_link_resource = cls._schema_afd_origin_properties_read.shared_private_link_resource
        _schema.weight = cls._schema_afd_origin_properties_read.weight

    _schema_activated_resource_reference_read = None

    @classmethod
    def _build_schema_activated_resource_reference_read(cls, _schema):
        if cls._schema_activated_resource_reference_read is not None:
            _schema.id = cls._schema_activated_resource_reference_read.id
            _schema.is_active = cls._schema_activated_resource_reference_read.is_active
            return

        cls._schema_activated_resource_reference_read = _schema_activated_resource_reference_read = AAZObjectType()

        activated_resource_reference_read = _schema_activated_resource_reference_read
        activated_resource_reference_read.id = AAZStrType()
        activated_resource_reference_read.is_active = AAZBoolType(
            serialized_name="isActive",
            flags={"read_only": True},
        )

        _schema.id = cls._schema_activated_resource_reference_read.id
        _schema.is_active = cls._schema_activated_resource_reference_read.is_active

    _schema_header_action_parameters_read = None

    @classmethod
    def _build_schema_header_action_parameters_read(cls, _schema):
        if cls._schema_header_action_parameters_read is not None:
            _schema.header_action = cls._schema_header_action_parameters_read.header_action
            _schema.header_name = cls._schema_header_action_parameters_read.header_name
            _schema.type_name = cls._schema_header_action_parameters_read.type_name
            _schema.value = cls._schema_header_action_parameters_read.value
            return

        cls._schema_header_action_parameters_read = _schema_header_action_parameters_read = AAZObjectType()

        header_action_parameters_read = _schema_header_action_parameters_read
        header_action_parameters_read.header_action = AAZStrType(
            serialized_name="headerAction",
            flags={"required": True},
        )
        header_action_parameters_read.header_name = AAZStrType(
            serialized_name="headerName",
            flags={"required": True},
        )
        header_action_parameters_read.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )
        header_action_parameters_read.value = AAZStrType()

        _schema.header_action = cls._schema_header_action_parameters_read.header_action
        _schema.header_name = cls._schema_header_action_parameters_read.header_name
        _schema.type_name = cls._schema_header_action_parameters_read.type_name
        _schema.value = cls._schema_header_action_parameters_read.value

    _schema_managed_rule_exclusion_read = None

    @classmethod
    def _build_schema_managed_rule_exclusion_read(cls, _schema):
        if cls._schema_managed_rule_exclusion_read is not None:
            _schema.match_variable = cls._schema_managed_rule_exclusion_read.match_variable
            _schema.selector = cls._schema_managed_rule_exclusion_read.selector
            _schema.selector_match_operator = cls._schema_managed_rule_exclusion_read.selector_match_operator
            return

        cls._schema_managed_rule_exclusion_read = _schema_managed_rule_exclusion_read = AAZObjectType()

        managed_rule_exclusion_read = _schema_managed_rule_exclusion_read
        managed_rule_exclusion_read.match_variable = AAZStrType(
            serialized_name="matchVariable",
            flags={"required": True},
        )
        managed_rule_exclusion_read.selector = AAZStrType(
            flags={"required": True},
        )
        managed_rule_exclusion_read.selector_match_operator = AAZStrType(
            serialized_name="selectorMatchOperator",
            flags={"required": True},
        )

        _schema.match_variable = cls._schema_managed_rule_exclusion_read.match_variable
        _schema.selector = cls._schema_managed_rule_exclusion_read.selector
        _schema.selector_match_operator = cls._schema_managed_rule_exclusion_read.selector_match_operator

    _schema_resource_reference_read = None

    @classmethod
    def _build_schema_resource_reference_read(cls, _schema):
        if cls._schema_resource_reference_read is not None:
            _schema.id = cls._schema_resource_reference_read.id
            return

        cls._schema_resource_reference_read = _schema_resource_reference_read = AAZObjectType()

        resource_reference_read = _schema_resource_reference_read
        resource_reference_read.id = AAZStrType()

        _schema.id = cls._schema_resource_reference_read.id

    _schema_route_properties_read = None

    @classmethod
    def _build_schema_route_properties_read(cls, _schema):
        if cls._schema_route_properties_read is not None:
            _schema.cache_configuration = cls._schema_route_properties_read.cache_configuration
            _schema.custom_domains = cls._schema_route_properties_read.custom_domains
            _schema.deployment_status = cls._schema_route_properties_read.deployment_status
            _schema.enabled_state = cls._schema_route_properties_read.enabled_state
            _schema.endpoint_name = cls._schema_route_properties_read.endpoint_name
            _schema.forwarding_protocol = cls._schema_route_properties_read.forwarding_protocol
            _schema.https_redirect = cls._schema_route_properties_read.https_redirect
            _schema.link_to_default_domain = cls._schema_route_properties_read.link_to_default_domain
            _schema.origin_group = cls._schema_route_properties_read.origin_group
            _schema.origin_path = cls._schema_route_properties_read.origin_path
            _schema.patterns_to_match = cls._schema_route_properties_read.patterns_to_match
            _schema.provisioning_state = cls._schema_route_properties_read.provisioning_state
            _schema.rule_sets = cls._schema_route_properties_read.rule_sets
            _schema.supported_protocols = cls._schema_route_properties_read.supported_protocols
            return

        cls._schema_route_properties_read = _schema_route_properties_read = AAZObjectType()

        route_properties_read = _schema_route_properties_read
        route_properties_read.cache_configuration = AAZObjectType(
            serialized_name="cacheConfiguration",
        )
        route_properties_read.custom_domains = AAZListType(
            serialized_name="customDomains",
        )
        route_properties_read.deployment_status = AAZStrType(
            serialized_name="deploymentStatus",
            flags={"read_only": True},
        )
        route_properties_read.enabled_state = AAZStrType(
            serialized_name="enabledState",
        )
        route_properties_read.endpoint_name = AAZStrType(
            serialized_name="endpointName",
            flags={"read_only": True},
        )
        route_properties_read.forwarding_protocol = AAZStrType(
            serialized_name="forwardingProtocol",
        )
        route_properties_read.https_redirect = AAZStrType(
            serialized_name="httpsRedirect",
        )
        route_properties_read.link_to_default_domain = AAZStrType(
            serialized_name="linkToDefaultDomain",
        )
        route_properties_read.origin_group = AAZObjectType(
            serialized_name="originGroup",
            flags={"required": True},
        )
        cls._build_schema_resource_reference_read(route_properties_read.origin_group)
        route_properties_read.origin_path = AAZStrType(
            serialized_name="originPath",
        )
        route_properties_read.patterns_to_match = AAZListType(
            serialized_name="patternsToMatch",
        )
        route_properties_read.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        route_properties_read.rule_sets = AAZListType(
            serialized_name="ruleSets",
        )
        route_properties_read.supported_protocols = AAZListType(
            serialized_name="supportedProtocols",
        )

        cache_configuration = _schema_route_properties_read.cache_configuration
        cache_configuration.compression_settings = AAZObjectType(
            serialized_name="compressionSettings",
        )
        cache_configuration.query_parameters = AAZStrType(
            serialized_name="queryParameters",
        )
        cache_configuration.query_string_caching_behavior = AAZStrType(
            serialized_name="queryStringCachingBehavior",
        )

        compression_settings = _schema_route_properties_read.cache_configuration.compression_settings
        compression_settings.content_types_to_compress = AAZListType(
            serialized_name="contentTypesToCompress",
        )
        compression_settings.is_compression_enabled = AAZBoolType(
            serialized_name="isCompressionEnabled",
        )

        content_types_to_compress = _schema_route_properties_read.cache_configuration.compression_settings.content_types_to_compress
        content_types_to_compress.Element = AAZStrType()

        custom_domains = _schema_route_properties_read.custom_domains
        custom_domains.Element = AAZObjectType()
        cls._build_schema_activated_resource_reference_read(custom_domains.Element)

        patterns_to_match = _schema_route_properties_read.patterns_to_match
        patterns_to_match.Element = AAZStrType()

        rule_sets = _schema_route_properties_read.rule_sets
        rule_sets.Element = AAZObjectType()
        cls._build_schema_resource_reference_read(rule_sets.Element)

        supported_protocols = _schema_route_properties_read.supported_protocols
        supported_protocols.Element = AAZStrType()

        _schema.cache_configuration = cls._schema_route_properties_read.cache_configuration
        _schema.custom_domains = cls._schema_route_properties_read.custom_domains
        _schema.deployment_status = cls._schema_route_properties_read.deployment_status
        _schema.enabled_state = cls._schema_route_properties_read.enabled_state
        _schema.endpoint_name = cls._schema_route_properties_read.endpoint_name
        _schema.forwarding_protocol = cls._schema_route_properties_read.forwarding_protocol
        _schema.https_redirect = cls._schema_route_properties_read.https_redirect
        _schema.link_to_default_domain = cls._schema_route_properties_read.link_to_default_domain
        _schema.origin_group = cls._schema_route_properties_read.origin_group
        _schema.origin_path = cls._schema_route_properties_read.origin_path
        _schema.patterns_to_match = cls._schema_route_properties_read.patterns_to_match
        _schema.provisioning_state = cls._schema_route_properties_read.provisioning_state
        _schema.rule_sets = cls._schema_route_properties_read.rule_sets
        _schema.supported_protocols = cls._schema_route_properties_read.supported_protocols

    _schema_rule_properties_read = None

    @classmethod
    def _build_schema_rule_properties_read(cls, _schema):
        if cls._schema_rule_properties_read is not None:
            _schema.actions = cls._schema_rule_properties_read.actions
            _schema.conditions = cls._schema_rule_properties_read.conditions
            _schema.deployment_status = cls._schema_rule_properties_read.deployment_status
            _schema.match_processing_behavior = cls._schema_rule_properties_read.match_processing_behavior
            _schema.order = cls._schema_rule_properties_read.order
            _schema.provisioning_state = cls._schema_rule_properties_read.provisioning_state
            _schema.rule_set_name = cls._schema_rule_properties_read.rule_set_name
            return

        cls._schema_rule_properties_read = _schema_rule_properties_read = AAZObjectType()

        rule_properties_read = _schema_rule_properties_read
        rule_properties_read.actions = AAZListType(
            flags={"required": True},
        )
        rule_properties_read.conditions = AAZListType()
        rule_properties_read.deployment_status = AAZStrType(
            serialized_name="deploymentStatus",
            flags={"read_only": True},
        )
        rule_properties_read.match_processing_behavior = AAZStrType(
            serialized_name="matchProcessingBehavior",
        )
        rule_properties_read.order = AAZIntType(
            flags={"required": True},
        )
        rule_properties_read.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        rule_properties_read.rule_set_name = AAZStrType(
            serialized_name="ruleSetName",
            flags={"read_only": True},
        )

        actions = _schema_rule_properties_read.actions
        actions.Element = AAZObjectType()

        _element = _schema_rule_properties_read.actions.Element
        _element.name = AAZStrType(
            flags={"required": True},
        )

        disc_cache_expiration = _schema_rule_properties_read.actions.Element.discriminate_by("name", "CacheExpiration")
        disc_cache_expiration.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.actions.Element.discriminate_by("name", "CacheExpiration").parameters
        parameters.cache_behavior = AAZStrType(
            serialized_name="cacheBehavior",
            flags={"required": True},
        )
        parameters.cache_duration = AAZStrType(
            serialized_name="cacheDuration",
            nullable=True,
        )
        parameters.cache_type = AAZStrType(
            serialized_name="cacheType",
            flags={"required": True},
        )
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        disc_cache_key_query_string = _schema_rule_properties_read.actions.Element.discriminate_by("name", "CacheKeyQueryString")
        disc_cache_key_query_string.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.actions.Element.discriminate_by("name", "CacheKeyQueryString").parameters
        parameters.query_parameters = AAZStrType(
            serialized_name="queryParameters",
            nullable=True,
        )
        parameters.query_string_behavior = AAZStrType(
            serialized_name="queryStringBehavior",
            flags={"required": True},
        )
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        disc_modify_request_header = _schema_rule_properties_read.actions.Element.discriminate_by("name", "ModifyRequestHeader")
        disc_modify_request_header.parameters = AAZObjectType(
            flags={"required": True},
        )
        cls._build_schema_header_action_parameters_read(disc_modify_request_header.parameters)

        disc_modify_response_header = _schema_rule_properties_read.actions.Element.discriminate_by("name", "ModifyResponseHeader")
        disc_modify_response_header.parameters = AAZObjectType(
            flags={"required": True},
        )
        cls._build_schema_header_action_parameters_read(disc_modify_response_header.parameters)

        disc_origin_group_override = _schema_rule_properties_read.actions.Element.discriminate_by("name", "OriginGroupOverride")
        disc_origin_group_override.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.actions.Element.discriminate_by("name", "OriginGroupOverride").parameters
        parameters.origin_group = AAZObjectType(
            serialized_name="originGroup",
            flags={"required": True},
        )
        cls._build_schema_resource_reference_read(parameters.origin_group)
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        disc_route_configuration_override = _schema_rule_properties_read.actions.Element.discriminate_by("name", "RouteConfigurationOverride")
        disc_route_configuration_override.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.actions.Element.discriminate_by("name", "RouteConfigurationOverride").parameters
        parameters.cache_configuration = AAZObjectType(
            serialized_name="cacheConfiguration",
        )
        parameters.origin_group_override = AAZObjectType(
            serialized_name="originGroupOverride",
        )
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        cache_configuration = _schema_rule_properties_read.actions.Element.discriminate_by("name", "RouteConfigurationOverride").parameters.cache_configuration
        cache_configuration.cache_behavior = AAZStrType(
            serialized_name="cacheBehavior",
        )
        cache_configuration.cache_duration = AAZStrType(
            serialized_name="cacheDuration",
        )
        cache_configuration.is_compression_enabled = AAZStrType(
            serialized_name="isCompressionEnabled",
        )
        cache_configuration.query_parameters = AAZStrType(
            serialized_name="queryParameters",
        )
        cache_configuration.query_string_caching_behavior = AAZStrType(
            serialized_name="queryStringCachingBehavior",
        )

        origin_group_override = _schema_rule_properties_read.actions.Element.discriminate_by("name", "RouteConfigurationOverride").parameters.origin_group_override
        origin_group_override.forwarding_protocol = AAZStrType(
            serialized_name="forwardingProtocol",
        )
        origin_group_override.origin_group = AAZObjectType(
            serialized_name="originGroup",
        )
        cls._build_schema_resource_reference_read(origin_group_override.origin_group)

        disc_url_redirect = _schema_rule_properties_read.actions.Element.discriminate_by("name", "UrlRedirect")
        disc_url_redirect.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.actions.Element.discriminate_by("name", "UrlRedirect").parameters
        parameters.custom_fragment = AAZStrType(
            serialized_name="customFragment",
        )
        parameters.custom_hostname = AAZStrType(
            serialized_name="customHostname",
        )
        parameters.custom_path = AAZStrType(
            serialized_name="customPath",
        )
        parameters.custom_query_string = AAZStrType(
            serialized_name="customQueryString",
        )
        parameters.destination_protocol = AAZStrType(
            serialized_name="destinationProtocol",
        )
        parameters.redirect_type = AAZStrType(
            serialized_name="redirectType",
            flags={"required": True},
        )
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        disc_url_rewrite = _schema_rule_properties_read.actions.Element.discriminate_by("name", "UrlRewrite")
        disc_url_rewrite.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.actions.Element.discriminate_by("name", "UrlRewrite").parameters
        parameters.destination = AAZStrType(
            flags={"required": True},
        )
        parameters.preserve_unmatched_path = AAZBoolType(
            serialized_name="preserveUnmatchedPath",
        )
        parameters.source_pattern = AAZStrType(
            serialized_name="sourcePattern",
            flags={"required": True},
        )
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        disc_url_signing = _schema_rule_properties_read.actions.Element.discriminate_by("name", "UrlSigning")
        disc_url_signing.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.actions.Element.discriminate_by("name", "UrlSigning").parameters
        parameters.algorithm = AAZStrType()
        parameters.parameter_name_override = AAZListType(
            serialized_name="parameterNameOverride",
        )
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        parameter_name_override = _schema_rule_properties_read.actions.Element.discriminate_by("name", "UrlSigning").parameters.parameter_name_override
        parameter_name_override.Element = AAZObjectType()

        _element = _schema_rule_properties_read.actions.Element.discriminate_by("name", "UrlSigning").parameters.parameter_name_override.Element
        _element.param_indicator = AAZStrType(
            serialized_name="paramIndicator",
            flags={"required": True},
        )
        _element.param_name = AAZStrType(
            serialized_name="paramName",
            flags={"required": True},
        )

        conditions = _schema_rule_properties_read.conditions
        conditions.Element = AAZObjectType()

        _element = _schema_rule_properties_read.conditions.Element
        _element.name = AAZStrType(
            flags={"required": True},
        )

        disc_client_port = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "ClientPort")
        disc_client_port.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "ClientPort").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "ClientPort").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "ClientPort").parameters.transforms
        transforms.Element = AAZStrType()

        disc_cookies = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "Cookies")
        disc_cookies.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "Cookies").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.selector = AAZStrType()
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "Cookies").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "Cookies").parameters.transforms
        transforms.Element = AAZStrType()

        disc_host_name = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "HostName")
        disc_host_name.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "HostName").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "HostName").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "HostName").parameters.transforms
        transforms.Element = AAZStrType()

        disc_http_version = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "HttpVersion")
        disc_http_version.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "HttpVersion").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "HttpVersion").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "HttpVersion").parameters.transforms
        transforms.Element = AAZStrType()

        disc_is_device = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "IsDevice")
        disc_is_device.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "IsDevice").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "IsDevice").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "IsDevice").parameters.transforms
        transforms.Element = AAZStrType()

        disc_post_args = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "PostArgs")
        disc_post_args.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "PostArgs").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.selector = AAZStrType()
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "PostArgs").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "PostArgs").parameters.transforms
        transforms.Element = AAZStrType()

        disc_query_string = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "QueryString")
        disc_query_string.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "QueryString").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "QueryString").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "QueryString").parameters.transforms
        transforms.Element = AAZStrType()

        disc_remote_address = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RemoteAddress")
        disc_remote_address.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RemoteAddress").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RemoteAddress").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RemoteAddress").parameters.transforms
        transforms.Element = AAZStrType()

        disc_request_body = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestBody")
        disc_request_body.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestBody").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestBody").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestBody").parameters.transforms
        transforms.Element = AAZStrType()

        disc_request_header = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestHeader")
        disc_request_header.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestHeader").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.selector = AAZStrType()
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestHeader").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestHeader").parameters.transforms
        transforms.Element = AAZStrType()

        disc_request_method = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestMethod")
        disc_request_method.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestMethod").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestMethod").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestMethod").parameters.transforms
        transforms.Element = AAZStrType()

        disc_request_scheme = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestScheme")
        disc_request_scheme.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestScheme").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestScheme").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestScheme").parameters.transforms
        transforms.Element = AAZStrType()

        disc_request_uri = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestUri")
        disc_request_uri.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestUri").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestUri").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "RequestUri").parameters.transforms
        transforms.Element = AAZStrType()

        disc_server_port = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "ServerPort")
        disc_server_port.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "ServerPort").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "ServerPort").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "ServerPort").parameters.transforms
        transforms.Element = AAZStrType()

        disc_socket_addr = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "SocketAddr")
        disc_socket_addr.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "SocketAddr").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "SocketAddr").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "SocketAddr").parameters.transforms
        transforms.Element = AAZStrType()

        disc_ssl_protocol = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "SslProtocol")
        disc_ssl_protocol.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "SslProtocol").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "SslProtocol").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "SslProtocol").parameters.transforms
        transforms.Element = AAZStrType()

        disc_url_file_extension = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlFileExtension")
        disc_url_file_extension.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlFileExtension").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlFileExtension").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlFileExtension").parameters.transforms
        transforms.Element = AAZStrType()

        disc_url_file_name = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlFileName")
        disc_url_file_name.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlFileName").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlFileName").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlFileName").parameters.transforms
        transforms.Element = AAZStrType()

        disc_url_path = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlPath")
        disc_url_path.parameters = AAZObjectType(
            flags={"required": True},
        )

        parameters = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlPath").parameters
        parameters.match_values = AAZListType(
            serialized_name="matchValues",
        )
        parameters.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        parameters.operator = AAZStrType(
            flags={"required": True},
        )
        parameters.transforms = AAZListType()
        parameters.type_name = AAZStrType(
            serialized_name="typeName",
            flags={"required": True},
        )

        match_values = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlPath").parameters.match_values
        match_values.Element = AAZStrType()

        transforms = _schema_rule_properties_read.conditions.Element.discriminate_by("name", "UrlPath").parameters.transforms
        transforms.Element = AAZStrType()

        _schema.actions = cls._schema_rule_properties_read.actions
        _schema.conditions = cls._schema_rule_properties_read.conditions
        _schema.deployment_status = cls._schema_rule_properties_read.deployment_status
        _schema.match_processing_behavior = cls._schema_rule_properties_read.match_processing_behavior
        _schema.order = cls._schema_rule_properties_read.order
        _schema.provisioning_state = cls._schema_rule_properties_read.provisioning_state
        _schema.rule_set_name = cls._schema_rule_properties_read.rule_set_name

    _schema_rule_set_properties_read = None

    @classmethod
    def _build_schema_rule_set_properties_read(cls, _schema):
        if cls._schema_rule_set_properties_read is not None:
            _schema.deployment_status = cls._schema_rule_set_properties_read.deployment_status
            _schema.profile_name = cls._schema_rule_set_properties_read.profile_name
            _schema.provisioning_state = cls._schema_rule_set_properties_read.provisioning_state
            return

        cls._schema_rule_set_properties_read = _schema_rule_set_properties_read = AAZObjectType()

        rule_set_properties_read = _schema_rule_set_properties_read
        rule_set_properties_read.deployment_status = AAZStrType(
            serialized_name="deploymentStatus",
            flags={"read_only": True},
        )
        rule_set_properties_read.profile_name = AAZStrType(
            serialized_name="profileName",
            flags={"read_only": True},
        )
        rule_set_properties_read.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        _schema.deployment_status = cls._schema_rule_set_properties_read.deployment_status
        _schema.profile_name = cls._schema_rule_set_properties_read.profile_name
        _schema.provisioning_state = cls._schema_rule_set_properties_read.provisioning_state

    _schema_security_policy_properties_with_embedded_waf_policy_read = None

    @classmethod
    def _build_schema_security_policy_properties_with_embedded_waf_policy_read(cls, _schema):
        if cls._schema_security_policy_properties_with_embedded_waf_policy_read is not None:
            _schema.deployment_status = cls._schema_security_policy_properties_with_embedded_waf_policy_read.deployment_status
            _schema.parameters = cls._schema_security_policy_properties_with_embedded_waf_policy_read.parameters
            _schema.profile_name = cls._schema_security_policy_properties_with_embedded_waf_policy_read.profile_name
            _schema.provisioning_state = cls._schema_security_policy_properties_with_embedded_waf_policy_read.provisioning_state
            return

        cls._schema_security_policy_properties_with_embedded_waf_policy_read = _schema_security_policy_properties_with_embedded_waf_policy_read = AAZObjectType()

        security_policy_properties_with_embedded_waf_policy_read = _schema_security_policy_properties_with_embedded_waf_policy_read
        security_policy_properties_with_embedded_waf_policy_read.deployment_status = AAZStrType(
            serialized_name="deploymentStatus",
            flags={"read_only": True},
        )
        security_policy_properties_with_embedded_waf_policy_read.parameters = AAZObjectType()
        security_policy_properties_with_embedded_waf_policy_read.profile_name = AAZStrType(
            serialized_name="profileName",
            flags={"read_only": True},
        )
        security_policy_properties_with_embedded_waf_policy_read.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        parameters = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters
        parameters.associations = AAZListType()
        parameters.type = AAZStrType(
            flags={"required": True},
        )
        parameters.waf_policy = AAZObjectType(
            serialized_name="wafPolicy",
        )

        associations = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.associations
        associations.Element = AAZObjectType()

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.associations.Element
        _element.domains = AAZListType()
        _element.patterns_to_match = AAZListType(
            serialized_name="patternsToMatch",
        )

        domains = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.associations.Element.domains
        domains.Element = AAZObjectType()
        cls._build_schema_activated_resource_reference_read(domains.Element)

        patterns_to_match = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.associations.Element.patterns_to_match
        patterns_to_match.Element = AAZStrType()

        waf_policy = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy
        waf_policy.etag = AAZStrType()
        waf_policy.id = AAZStrType(
            flags={"read_only": True},
        )
        waf_policy.name = AAZStrType(
            flags={"read_only": True},
        )
        waf_policy.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        waf_policy.sku = AAZObjectType()
        waf_policy.system_data = AAZObjectType(
            serialized_name="systemData",
            flags={"read_only": True},
        )
        waf_policy.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties
        properties.custom_rules = AAZObjectType(
            serialized_name="customRules",
        )
        properties.frontend_endpoint_links = AAZListType(
            serialized_name="frontendEndpointLinks",
            flags={"read_only": True},
        )
        properties.managed_rules = AAZObjectType(
            serialized_name="managedRules",
        )
        properties.policy_settings = AAZObjectType(
            serialized_name="policySettings",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_state = AAZStrType(
            serialized_name="resourceState",
            flags={"read_only": True},
        )
        properties.routing_rule_links = AAZListType(
            serialized_name="routingRuleLinks",
            flags={"read_only": True},
        )
        properties.security_policy_links = AAZListType(
            serialized_name="securityPolicyLinks",
            flags={"read_only": True},
        )

        custom_rules = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.custom_rules
        custom_rules.rules = AAZListType()

        rules = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.custom_rules.rules
        rules.Element = AAZObjectType()

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.custom_rules.rules.Element
        _element.action = AAZStrType(
            flags={"required": True},
        )
        _element.enabled_state = AAZStrType(
            serialized_name="enabledState",
        )
        _element.group_by = AAZListType(
            serialized_name="groupBy",
        )
        _element.match_conditions = AAZListType(
            serialized_name="matchConditions",
            flags={"required": True},
        )
        _element.name = AAZStrType()
        _element.priority = AAZIntType(
            flags={"required": True},
        )
        _element.rate_limit_duration_in_minutes = AAZIntType(
            serialized_name="rateLimitDurationInMinutes",
        )
        _element.rate_limit_threshold = AAZIntType(
            serialized_name="rateLimitThreshold",
        )
        _element.rule_type = AAZStrType(
            serialized_name="ruleType",
            flags={"required": True},
        )

        group_by = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.custom_rules.rules.Element.group_by
        group_by.Element = AAZObjectType()

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.custom_rules.rules.Element.group_by.Element
        _element.variable_name = AAZStrType(
            serialized_name="variableName",
            flags={"required": True},
        )

        match_conditions = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.custom_rules.rules.Element.match_conditions
        match_conditions.Element = AAZObjectType()

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.custom_rules.rules.Element.match_conditions.Element
        _element.match_value = AAZListType(
            serialized_name="matchValue",
            flags={"required": True},
        )
        _element.match_variable = AAZStrType(
            serialized_name="matchVariable",
            flags={"required": True},
        )
        _element.negate_condition = AAZBoolType(
            serialized_name="negateCondition",
        )
        _element.operator = AAZStrType(
            flags={"required": True},
        )
        _element.selector = AAZStrType()
        _element.transforms = AAZListType()

        match_value = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.custom_rules.rules.Element.match_conditions.Element.match_value
        match_value.Element = AAZStrType()

        transforms = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.custom_rules.rules.Element.match_conditions.Element.transforms
        transforms.Element = AAZStrType()

        frontend_endpoint_links = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.frontend_endpoint_links
        frontend_endpoint_links.Element = AAZObjectType(
            flags={"read_only": True},
        )

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.frontend_endpoint_links.Element
        _element.id = AAZStrType()

        managed_rules = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.managed_rules
        managed_rules.managed_rule_sets = AAZListType(
            serialized_name="managedRuleSets",
        )

        managed_rule_sets = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.managed_rules.managed_rule_sets
        managed_rule_sets.Element = AAZObjectType()

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.managed_rules.managed_rule_sets.Element
        _element.exclusions = AAZListType()
        _element.rule_group_overrides = AAZListType(
            serialized_name="ruleGroupOverrides",
        )
        _element.rule_set_action = AAZStrType(
            serialized_name="ruleSetAction",
        )
        _element.rule_set_type = AAZStrType(
            serialized_name="ruleSetType",
            flags={"required": True},
        )
        _element.rule_set_version = AAZStrType(
            serialized_name="ruleSetVersion",
            flags={"required": True},
        )

        exclusions = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.managed_rules.managed_rule_sets.Element.exclusions
        exclusions.Element = AAZObjectType()
        cls._build_schema_managed_rule_exclusion_read(exclusions.Element)

        rule_group_overrides = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.managed_rules.managed_rule_sets.Element.rule_group_overrides
        rule_group_overrides.Element = AAZObjectType()

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element
        _element.exclusions = AAZListType()
        _element.rule_group_name = AAZStrType(
            serialized_name="ruleGroupName",
            flags={"required": True},
        )
        _element.rules = AAZListType()

        exclusions = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element.exclusions
        exclusions.Element = AAZObjectType()
        cls._build_schema_managed_rule_exclusion_read(exclusions.Element)

        rules = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element.rules
        rules.Element = AAZObjectType()

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element.rules.Element
        _element.action = AAZStrType()
        _element.enabled_state = AAZStrType(
            serialized_name="enabledState",
        )
        _element.exclusions = AAZListType()
        _element.rule_id = AAZStrType(
            serialized_name="ruleId",
            flags={"required": True},
        )

        exclusions = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element.rules.Element.exclusions
        exclusions.Element = AAZObjectType()
        cls._build_schema_managed_rule_exclusion_read(exclusions.Element)

        policy_settings = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.policy_settings
        policy_settings.captcha_expiration_in_minutes = AAZIntType(
            serialized_name="captchaExpirationInMinutes",
        )
        policy_settings.custom_block_response_body = AAZStrType(
            serialized_name="customBlockResponseBody",
        )
        policy_settings.custom_block_response_status_code = AAZIntType(
            serialized_name="customBlockResponseStatusCode",
        )
        policy_settings.enabled_state = AAZStrType(
            serialized_name="enabledState",
        )
        policy_settings.javascript_challenge_expiration_in_minutes = AAZIntType(
            serialized_name="javascriptChallengeExpirationInMinutes",
        )
        policy_settings.log_scrubbing = AAZObjectType(
            serialized_name="logScrubbing",
            flags={"client_flatten": True},
        )
        policy_settings.mode = AAZStrType()
        policy_settings.redirect_url = AAZStrType(
            serialized_name="redirectUrl",
        )
        policy_settings.request_body_check = AAZStrType(
            serialized_name="requestBodyCheck",
        )

        log_scrubbing = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.policy_settings.log_scrubbing
        log_scrubbing.scrubbing_rules = AAZListType(
            serialized_name="scrubbingRules",
        )
        log_scrubbing.state = AAZStrType()

        scrubbing_rules = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.policy_settings.log_scrubbing.scrubbing_rules
        scrubbing_rules.Element = AAZObjectType()

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.policy_settings.log_scrubbing.scrubbing_rules.Element
        _element.match_variable = AAZStrType(
            serialized_name="matchVariable",
            flags={"required": True},
        )
        _element.selector = AAZStrType()
        _element.selector_match_operator = AAZStrType(
            serialized_name="selectorMatchOperator",
            flags={"required": True},
        )
        _element.state = AAZStrType()

        routing_rule_links = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.routing_rule_links
        routing_rule_links.Element = AAZObjectType(
            flags={"read_only": True},
        )

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.routing_rule_links.Element
        _element.id = AAZStrType()

        security_policy_links = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.security_policy_links
        security_policy_links.Element = AAZObjectType(
            flags={"read_only": True},
        )

        _element = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.properties.security_policy_links.Element
        _element.id = AAZStrType()

        sku = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.sku
        sku.name = AAZStrType()

        system_data = _schema_security_policy_properties_with_embedded_waf_policy_read.parameters.waf_policy.system_data
        system_data.created_at = AAZStrType(
            serialized_name="createdAt",
        )
        system_data.created_by = AAZStrType(
            serialized_name="createdBy",
        )
        system_data.created_by_type = AAZStrType(
            serialized_name="createdByType",
        )
        system_data.last_modified_at = AAZStrType(
            serialized_name="lastModifiedAt",
        )
        system_data.last_modified_by = AAZStrType(
            serialized_name="lastModifiedBy",
        )
        system_data.last_modified_by_type = AAZStrType(
            serialized_name="lastModifiedByType",
        )

        _schema.deployment_status = cls._schema_security_policy_properties_with_embedded_waf_policy_read.deployment_status
        _schema.parameters = cls._schema_security_policy_properties_with_embedded_waf_policy_read.parameters
        _schema.profile_name = cls._schema_security_policy_properties_with_embedded_waf_policy_read.profile_name
        _schema.provisioning_state = cls._schema_security_policy_properties_with_embedded_waf_policy_read.provisioning_state


__all__ = ["Compare"]
