# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "lab vm apply-artifacts",
    is_preview=True,
)
class ApplyArtifacts(AAZCommand):
    """Apply artifacts to virtual machine. This operation can take a while to complete.

    :example: Apply artifacts to a virtual machine in Azure DevTest Lab.
        az lab vm apply-artifacts --artifacts artifacts.json --lab-name MyLab --name MyVirtualMachine --resource-group MyResourceGroup
    """

    _aaz_info = {
        "version": "2018-09-15",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.devtestlab/labs/{}/virtualmachines/{}/applyartifacts", "2018-09-15"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, None)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.lab_name = AAZStrArg(
            options=["--lab-name"],
            help="The name of the lab.",
            required=True,
            id_part="name",
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the virtual machine.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "ApplyArtifactsRequest"

        _args_schema = cls._args_schema
        _args_schema.artifacts_org = AAZListArg(
            options=["--artifacts-org"],
            arg_group="ApplyArtifactsRequest",
            help="The list of artifacts to apply.",
        )

        artifacts_org = cls._args_schema.artifacts_org
        artifacts_org.Element = AAZObjectArg()

        _element = cls._args_schema.artifacts_org.Element
        _element.artifact_id = AAZStrArg(
            options=["artifact-id"],
            help="The artifact's identifier.",
        )
        _element.artifact_title = AAZStrArg(
            options=["artifact-title"],
            help="The artifact's title.",
        )
        _element.deployment_status_message = AAZStrArg(
            options=["deployment-status-message"],
            help="The status message from the deployment.",
        )
        _element.install_time = AAZDateTimeArg(
            options=["install-time"],
            help="The time that the artifact starts to install on the virtual machine.",
        )
        _element.parameters = AAZListArg(
            options=["parameters"],
            help="The parameters of the artifact.",
        )
        _element.status = AAZStrArg(
            options=["status"],
            help="The status of the artifact.",
        )
        _element.vm_extension_status_message = AAZStrArg(
            options=["vm-extension-status-message"],
            help="The status message from the virtual machine extension.",
        )

        parameters = cls._args_schema.artifacts_org.Element.parameters
        parameters.Element = AAZObjectArg()

        _element = cls._args_schema.artifacts_org.Element.parameters.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the artifact parameter.",
        )
        _element.value = AAZStrArg(
            options=["value"],
            help="The value of the artifact parameter.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.VirtualMachinesApplyArtifacts(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    class VirtualMachinesApplyArtifacts(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}/applyArtifacts",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "labName", self.ctx.args.lab_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-09-15",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("artifacts", AAZListType, ".artifacts_org")

            artifacts = _builder.get(".artifacts")
            if artifacts is not None:
                artifacts.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".artifacts[]")
            if _elements is not None:
                _elements.set_prop("artifactId", AAZStrType, ".artifact_id")
                _elements.set_prop("artifactTitle", AAZStrType, ".artifact_title")
                _elements.set_prop("deploymentStatusMessage", AAZStrType, ".deployment_status_message")
                _elements.set_prop("installTime", AAZStrType, ".install_time")
                _elements.set_prop("parameters", AAZListType, ".parameters")
                _elements.set_prop("status", AAZStrType, ".status")
                _elements.set_prop("vmExtensionStatusMessage", AAZStrType, ".vm_extension_status_message")

            parameters = _builder.get(".artifacts[].parameters")
            if parameters is not None:
                parameters.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".artifacts[].parameters[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("value", AAZStrType, ".value")

            return self.serialize_content(_content_value)

        def on_200(self, session):
            pass


class _ApplyArtifactsHelper:
    """Helper class for ApplyArtifacts"""


__all__ = ["ApplyArtifacts"]
