// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file aliasesTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "aliasesTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "aliases.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

void register_alias_int16_type_identifier(
        TypeIdentifierPair& type_ids_alias_int16)
{
    ReturnCode_t return_code_alias_int16 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_int16 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_int16", type_ids_alias_int16);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_int16)
    {
        AliasTypeFlag alias_flags_alias_int16 = 0;
        QualifiedTypeName type_name_alias_int16 = "alias_int16";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_int16;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_int16;
        CompleteTypeDetail detail_alias_int16 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_int16, ann_custom_alias_int16, type_name_alias_int16.to_string());
        CompleteAliasHeader header_alias_int16 = TypeObjectUtils::build_complete_alias_header(detail_alias_int16);
        AliasMemberFlag related_flags_alias_int16 = 0;
        return_code_alias_int16 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int16_t", type_ids_alias_int16);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_int16)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_int16 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_int16_ec {false};
        CommonAliasBody common_alias_int16 {TypeObjectUtils::build_common_alias_body(related_flags_alias_int16,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_int16, common_alias_int16_ec))};
        if (!common_alias_int16_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_int16 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_int16;
        ann_custom_alias_int16.reset();
        CompleteAliasBody body_alias_int16 = TypeObjectUtils::build_complete_alias_body(common_alias_int16,
                member_ann_builtin_alias_int16, ann_custom_alias_int16);
        CompleteAliasType alias_type_alias_int16 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_int16,
                header_alias_int16, body_alias_int16);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_int16,
                    type_name_alias_int16.to_string(), type_ids_alias_int16))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_int16 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_uint16_type_identifier(
        TypeIdentifierPair& type_ids_alias_uint16)
{
    ReturnCode_t return_code_alias_uint16 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_uint16 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_uint16", type_ids_alias_uint16);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_uint16)
    {
        AliasTypeFlag alias_flags_alias_uint16 = 0;
        QualifiedTypeName type_name_alias_uint16 = "alias_uint16";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_uint16;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_uint16;
        CompleteTypeDetail detail_alias_uint16 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_uint16, ann_custom_alias_uint16, type_name_alias_uint16.to_string());
        CompleteAliasHeader header_alias_uint16 = TypeObjectUtils::build_complete_alias_header(detail_alias_uint16);
        AliasMemberFlag related_flags_alias_uint16 = 0;
        return_code_alias_uint16 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_uint16_t", type_ids_alias_uint16);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_uint16)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_uint16 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_uint16_ec {false};
        CommonAliasBody common_alias_uint16 {TypeObjectUtils::build_common_alias_body(related_flags_alias_uint16,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_uint16, common_alias_uint16_ec))};
        if (!common_alias_uint16_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_uint16 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_uint16;
        ann_custom_alias_uint16.reset();
        CompleteAliasBody body_alias_uint16 = TypeObjectUtils::build_complete_alias_body(common_alias_uint16,
                member_ann_builtin_alias_uint16, ann_custom_alias_uint16);
        CompleteAliasType alias_type_alias_uint16 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_uint16,
                header_alias_uint16, body_alias_uint16);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_uint16,
                    type_name_alias_uint16.to_string(), type_ids_alias_uint16))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_uint16 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_int32_type_identifier(
        TypeIdentifierPair& type_ids_alias_int32)
{
    ReturnCode_t return_code_alias_int32 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_int32 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_int32", type_ids_alias_int32);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_int32)
    {
        AliasTypeFlag alias_flags_alias_int32 = 0;
        QualifiedTypeName type_name_alias_int32 = "alias_int32";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_int32;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_int32;
        CompleteTypeDetail detail_alias_int32 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_int32, ann_custom_alias_int32, type_name_alias_int32.to_string());
        CompleteAliasHeader header_alias_int32 = TypeObjectUtils::build_complete_alias_header(detail_alias_int32);
        AliasMemberFlag related_flags_alias_int32 = 0;
        return_code_alias_int32 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_alias_int32);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_int32)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_int32 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_int32_ec {false};
        CommonAliasBody common_alias_int32 {TypeObjectUtils::build_common_alias_body(related_flags_alias_int32,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_int32, common_alias_int32_ec))};
        if (!common_alias_int32_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_int32 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_int32;
        ann_custom_alias_int32.reset();
        CompleteAliasBody body_alias_int32 = TypeObjectUtils::build_complete_alias_body(common_alias_int32,
                member_ann_builtin_alias_int32, ann_custom_alias_int32);
        CompleteAliasType alias_type_alias_int32 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_int32,
                header_alias_int32, body_alias_int32);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_int32,
                    type_name_alias_int32.to_string(), type_ids_alias_int32))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_int32 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_uint32_type_identifier(
        TypeIdentifierPair& type_ids_alias_uint32)
{
    ReturnCode_t return_code_alias_uint32 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_uint32 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_uint32", type_ids_alias_uint32);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_uint32)
    {
        AliasTypeFlag alias_flags_alias_uint32 = 0;
        QualifiedTypeName type_name_alias_uint32 = "alias_uint32";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_uint32;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_uint32;
        CompleteTypeDetail detail_alias_uint32 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_uint32, ann_custom_alias_uint32, type_name_alias_uint32.to_string());
        CompleteAliasHeader header_alias_uint32 = TypeObjectUtils::build_complete_alias_header(detail_alias_uint32);
        AliasMemberFlag related_flags_alias_uint32 = 0;
        return_code_alias_uint32 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_uint32_t", type_ids_alias_uint32);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_uint32)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_uint32 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_uint32_ec {false};
        CommonAliasBody common_alias_uint32 {TypeObjectUtils::build_common_alias_body(related_flags_alias_uint32,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_uint32, common_alias_uint32_ec))};
        if (!common_alias_uint32_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_uint32 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_uint32;
        ann_custom_alias_uint32.reset();
        CompleteAliasBody body_alias_uint32 = TypeObjectUtils::build_complete_alias_body(common_alias_uint32,
                member_ann_builtin_alias_uint32, ann_custom_alias_uint32);
        CompleteAliasType alias_type_alias_uint32 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_uint32,
                header_alias_uint32, body_alias_uint32);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_uint32,
                    type_name_alias_uint32.to_string(), type_ids_alias_uint32))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_uint32 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_int64_type_identifier(
        TypeIdentifierPair& type_ids_alias_int64)
{
    ReturnCode_t return_code_alias_int64 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_int64 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_int64", type_ids_alias_int64);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_int64)
    {
        AliasTypeFlag alias_flags_alias_int64 = 0;
        QualifiedTypeName type_name_alias_int64 = "alias_int64";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_int64;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_int64;
        CompleteTypeDetail detail_alias_int64 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_int64, ann_custom_alias_int64, type_name_alias_int64.to_string());
        CompleteAliasHeader header_alias_int64 = TypeObjectUtils::build_complete_alias_header(detail_alias_int64);
        AliasMemberFlag related_flags_alias_int64 = 0;
        return_code_alias_int64 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int64_t", type_ids_alias_int64);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_int64)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_int64 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_int64_ec {false};
        CommonAliasBody common_alias_int64 {TypeObjectUtils::build_common_alias_body(related_flags_alias_int64,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_int64, common_alias_int64_ec))};
        if (!common_alias_int64_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_int64 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_int64;
        ann_custom_alias_int64.reset();
        CompleteAliasBody body_alias_int64 = TypeObjectUtils::build_complete_alias_body(common_alias_int64,
                member_ann_builtin_alias_int64, ann_custom_alias_int64);
        CompleteAliasType alias_type_alias_int64 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_int64,
                header_alias_int64, body_alias_int64);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_int64,
                    type_name_alias_int64.to_string(), type_ids_alias_int64))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_int64 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_uint64_type_identifier(
        TypeIdentifierPair& type_ids_alias_uint64)
{
    ReturnCode_t return_code_alias_uint64 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_uint64 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_uint64", type_ids_alias_uint64);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_uint64)
    {
        AliasTypeFlag alias_flags_alias_uint64 = 0;
        QualifiedTypeName type_name_alias_uint64 = "alias_uint64";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_uint64;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_uint64;
        CompleteTypeDetail detail_alias_uint64 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_uint64, ann_custom_alias_uint64, type_name_alias_uint64.to_string());
        CompleteAliasHeader header_alias_uint64 = TypeObjectUtils::build_complete_alias_header(detail_alias_uint64);
        AliasMemberFlag related_flags_alias_uint64 = 0;
        return_code_alias_uint64 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_uint64_t", type_ids_alias_uint64);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_uint64)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_uint64 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_uint64_ec {false};
        CommonAliasBody common_alias_uint64 {TypeObjectUtils::build_common_alias_body(related_flags_alias_uint64,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_uint64, common_alias_uint64_ec))};
        if (!common_alias_uint64_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_uint64 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_uint64;
        ann_custom_alias_uint64.reset();
        CompleteAliasBody body_alias_uint64 = TypeObjectUtils::build_complete_alias_body(common_alias_uint64,
                member_ann_builtin_alias_uint64, ann_custom_alias_uint64);
        CompleteAliasType alias_type_alias_uint64 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_uint64,
                header_alias_uint64, body_alias_uint64);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_uint64,
                    type_name_alias_uint64.to_string(), type_ids_alias_uint64))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_uint64 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_float32_type_identifier(
        TypeIdentifierPair& type_ids_alias_float32)
{
    ReturnCode_t return_code_alias_float32 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_float32 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_float32", type_ids_alias_float32);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_float32)
    {
        AliasTypeFlag alias_flags_alias_float32 = 0;
        QualifiedTypeName type_name_alias_float32 = "alias_float32";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_float32;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_float32;
        CompleteTypeDetail detail_alias_float32 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_float32, ann_custom_alias_float32, type_name_alias_float32.to_string());
        CompleteAliasHeader header_alias_float32 = TypeObjectUtils::build_complete_alias_header(detail_alias_float32);
        AliasMemberFlag related_flags_alias_float32 = 0;
        return_code_alias_float32 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_float", type_ids_alias_float32);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_float32)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_float32 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_float32_ec {false};
        CommonAliasBody common_alias_float32 {TypeObjectUtils::build_common_alias_body(related_flags_alias_float32,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_float32, common_alias_float32_ec))};
        if (!common_alias_float32_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_float32 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_float32;
        ann_custom_alias_float32.reset();
        CompleteAliasBody body_alias_float32 = TypeObjectUtils::build_complete_alias_body(common_alias_float32,
                member_ann_builtin_alias_float32, ann_custom_alias_float32);
        CompleteAliasType alias_type_alias_float32 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_float32,
                header_alias_float32, body_alias_float32);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_float32,
                    type_name_alias_float32.to_string(), type_ids_alias_float32))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_float32 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_float64_type_identifier(
        TypeIdentifierPair& type_ids_alias_float64)
{
    ReturnCode_t return_code_alias_float64 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_float64 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_float64", type_ids_alias_float64);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_float64)
    {
        AliasTypeFlag alias_flags_alias_float64 = 0;
        QualifiedTypeName type_name_alias_float64 = "alias_float64";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_float64;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_float64;
        CompleteTypeDetail detail_alias_float64 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_float64, ann_custom_alias_float64, type_name_alias_float64.to_string());
        CompleteAliasHeader header_alias_float64 = TypeObjectUtils::build_complete_alias_header(detail_alias_float64);
        AliasMemberFlag related_flags_alias_float64 = 0;
        return_code_alias_float64 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_double", type_ids_alias_float64);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_float64)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_float64 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_float64_ec {false};
        CommonAliasBody common_alias_float64 {TypeObjectUtils::build_common_alias_body(related_flags_alias_float64,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_float64, common_alias_float64_ec))};
        if (!common_alias_float64_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_float64 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_float64;
        ann_custom_alias_float64.reset();
        CompleteAliasBody body_alias_float64 = TypeObjectUtils::build_complete_alias_body(common_alias_float64,
                member_ann_builtin_alias_float64, ann_custom_alias_float64);
        CompleteAliasType alias_type_alias_float64 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_float64,
                header_alias_float64, body_alias_float64);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_float64,
                    type_name_alias_float64.to_string(), type_ids_alias_float64))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_float64 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_float128_type_identifier(
        TypeIdentifierPair& type_ids_alias_float128)
{
    ReturnCode_t return_code_alias_float128 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_float128 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_float128", type_ids_alias_float128);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_float128)
    {
        AliasTypeFlag alias_flags_alias_float128 = 0;
        QualifiedTypeName type_name_alias_float128 = "alias_float128";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_float128;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_float128;
        CompleteTypeDetail detail_alias_float128 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_float128, ann_custom_alias_float128, type_name_alias_float128.to_string());
        CompleteAliasHeader header_alias_float128 = TypeObjectUtils::build_complete_alias_header(detail_alias_float128);
        AliasMemberFlag related_flags_alias_float128 = 0;
        return_code_alias_float128 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_longdouble", type_ids_alias_float128);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_float128)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_float128 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_float128_ec {false};
        CommonAliasBody common_alias_float128 {TypeObjectUtils::build_common_alias_body(related_flags_alias_float128,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_float128, common_alias_float128_ec))};
        if (!common_alias_float128_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_float128 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_float128;
        ann_custom_alias_float128.reset();
        CompleteAliasBody body_alias_float128 = TypeObjectUtils::build_complete_alias_body(common_alias_float128,
                member_ann_builtin_alias_float128, ann_custom_alias_float128);
        CompleteAliasType alias_type_alias_float128 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_float128,
                header_alias_float128, body_alias_float128);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_float128,
                    type_name_alias_float128.to_string(), type_ids_alias_float128))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_float128 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_bool_type_identifier(
        TypeIdentifierPair& type_ids_alias_bool)
{
    ReturnCode_t return_code_alias_bool {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_bool =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_bool", type_ids_alias_bool);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_bool)
    {
        AliasTypeFlag alias_flags_alias_bool = 0;
        QualifiedTypeName type_name_alias_bool = "alias_bool";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_bool;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_bool;
        CompleteTypeDetail detail_alias_bool = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_bool, ann_custom_alias_bool, type_name_alias_bool.to_string());
        CompleteAliasHeader header_alias_bool = TypeObjectUtils::build_complete_alias_header(detail_alias_bool);
        AliasMemberFlag related_flags_alias_bool = 0;
        return_code_alias_bool =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_bool", type_ids_alias_bool);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_bool)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_bool related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_bool_ec {false};
        CommonAliasBody common_alias_bool {TypeObjectUtils::build_common_alias_body(related_flags_alias_bool,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_bool, common_alias_bool_ec))};
        if (!common_alias_bool_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_bool related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_bool;
        ann_custom_alias_bool.reset();
        CompleteAliasBody body_alias_bool = TypeObjectUtils::build_complete_alias_body(common_alias_bool,
                member_ann_builtin_alias_bool, ann_custom_alias_bool);
        CompleteAliasType alias_type_alias_bool = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_bool,
                header_alias_bool, body_alias_bool);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_bool,
                    type_name_alias_bool.to_string(), type_ids_alias_bool))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_bool already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_octet_type_identifier(
        TypeIdentifierPair& type_ids_alias_octet)
{
    ReturnCode_t return_code_alias_octet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_octet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_octet", type_ids_alias_octet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_octet)
    {
        AliasTypeFlag alias_flags_alias_octet = 0;
        QualifiedTypeName type_name_alias_octet = "alias_octet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_octet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_octet;
        CompleteTypeDetail detail_alias_octet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_octet, ann_custom_alias_octet, type_name_alias_octet.to_string());
        CompleteAliasHeader header_alias_octet = TypeObjectUtils::build_complete_alias_header(detail_alias_octet);
        AliasMemberFlag related_flags_alias_octet = 0;
        return_code_alias_octet =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_byte", type_ids_alias_octet);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_octet)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_octet related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_octet_ec {false};
        CommonAliasBody common_alias_octet {TypeObjectUtils::build_common_alias_body(related_flags_alias_octet,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_octet, common_alias_octet_ec))};
        if (!common_alias_octet_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_octet related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_octet;
        ann_custom_alias_octet.reset();
        CompleteAliasBody body_alias_octet = TypeObjectUtils::build_complete_alias_body(common_alias_octet,
                member_ann_builtin_alias_octet, ann_custom_alias_octet);
        CompleteAliasType alias_type_alias_octet = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_octet,
                header_alias_octet, body_alias_octet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_octet,
                    type_name_alias_octet.to_string(), type_ids_alias_octet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_octet already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_char8_type_identifier(
        TypeIdentifierPair& type_ids_alias_char8)
{
    ReturnCode_t return_code_alias_char8 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_char8 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_char8", type_ids_alias_char8);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_char8)
    {
        AliasTypeFlag alias_flags_alias_char8 = 0;
        QualifiedTypeName type_name_alias_char8 = "alias_char8";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_char8;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_char8;
        CompleteTypeDetail detail_alias_char8 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_char8, ann_custom_alias_char8, type_name_alias_char8.to_string());
        CompleteAliasHeader header_alias_char8 = TypeObjectUtils::build_complete_alias_header(detail_alias_char8);
        AliasMemberFlag related_flags_alias_char8 = 0;
        return_code_alias_char8 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_char", type_ids_alias_char8);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_char8)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_char8 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_char8_ec {false};
        CommonAliasBody common_alias_char8 {TypeObjectUtils::build_common_alias_body(related_flags_alias_char8,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_char8, common_alias_char8_ec))};
        if (!common_alias_char8_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_char8 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_char8;
        ann_custom_alias_char8.reset();
        CompleteAliasBody body_alias_char8 = TypeObjectUtils::build_complete_alias_body(common_alias_char8,
                member_ann_builtin_alias_char8, ann_custom_alias_char8);
        CompleteAliasType alias_type_alias_char8 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_char8,
                header_alias_char8, body_alias_char8);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_char8,
                    type_name_alias_char8.to_string(), type_ids_alias_char8))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_char8 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_char16_type_identifier(
        TypeIdentifierPair& type_ids_alias_char16)
{
    ReturnCode_t return_code_alias_char16 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_char16 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_char16", type_ids_alias_char16);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_char16)
    {
        AliasTypeFlag alias_flags_alias_char16 = 0;
        QualifiedTypeName type_name_alias_char16 = "alias_char16";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_char16;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_char16;
        CompleteTypeDetail detail_alias_char16 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_char16, ann_custom_alias_char16, type_name_alias_char16.to_string());
        CompleteAliasHeader header_alias_char16 = TypeObjectUtils::build_complete_alias_header(detail_alias_char16);
        AliasMemberFlag related_flags_alias_char16 = 0;
        return_code_alias_char16 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_wchar_t", type_ids_alias_char16);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_char16)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_char16 related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_char16_ec {false};
        CommonAliasBody common_alias_char16 {TypeObjectUtils::build_common_alias_body(related_flags_alias_char16,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_char16, common_alias_char16_ec))};
        if (!common_alias_char16_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_char16 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_char16;
        ann_custom_alias_char16.reset();
        CompleteAliasBody body_alias_char16 = TypeObjectUtils::build_complete_alias_body(common_alias_char16,
                member_ann_builtin_alias_char16, ann_custom_alias_char16);
        CompleteAliasType alias_type_alias_char16 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_char16,
                header_alias_char16, body_alias_char16);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_char16,
                    type_name_alias_char16.to_string(), type_ids_alias_char16))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_char16 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_string8_type_identifier(
        TypeIdentifierPair& type_ids_alias_string8)
{
    ReturnCode_t return_code_alias_string8 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_string8 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_string8", type_ids_alias_string8);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_string8)
    {
        AliasTypeFlag alias_flags_alias_string8 = 0;
        QualifiedTypeName type_name_alias_string8 = "alias_string8";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_string8;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_string8;
        CompleteTypeDetail detail_alias_string8 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_string8, ann_custom_alias_string8, type_name_alias_string8.to_string());
        CompleteAliasHeader header_alias_string8 = TypeObjectUtils::build_complete_alias_header(detail_alias_string8);
        AliasMemberFlag related_flags_alias_string8 = 0;
        return_code_alias_string8 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "anonymous_string_unbounded", type_ids_alias_string8);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_string8)
        {
            {
                SBound bound = 0;
                StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                        TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                        "anonymous_string_unbounded", type_ids_alias_string8))
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                }
            }
        }
        bool common_alias_string8_ec {false};
        CommonAliasBody common_alias_string8 {TypeObjectUtils::build_common_alias_body(related_flags_alias_string8,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_string8, common_alias_string8_ec))};
        if (!common_alias_string8_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_string8 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_string8;
        ann_custom_alias_string8.reset();
        CompleteAliasBody body_alias_string8 = TypeObjectUtils::build_complete_alias_body(common_alias_string8,
                member_ann_builtin_alias_string8, ann_custom_alias_string8);
        CompleteAliasType alias_type_alias_string8 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_string8,
                header_alias_string8, body_alias_string8);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_string8,
                    type_name_alias_string8.to_string(), type_ids_alias_string8))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_string8 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_string16_type_identifier(
        TypeIdentifierPair& type_ids_alias_string16)
{
    ReturnCode_t return_code_alias_string16 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_string16 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_string16", type_ids_alias_string16);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_string16)
    {
        AliasTypeFlag alias_flags_alias_string16 = 0;
        QualifiedTypeName type_name_alias_string16 = "alias_string16";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_string16;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_string16;
        CompleteTypeDetail detail_alias_string16 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_string16, ann_custom_alias_string16, type_name_alias_string16.to_string());
        CompleteAliasHeader header_alias_string16 = TypeObjectUtils::build_complete_alias_header(detail_alias_string16);
        AliasMemberFlag related_flags_alias_string16 = 0;
        return_code_alias_string16 =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "anonymous_wstring_unbounded", type_ids_alias_string16);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_string16)
        {
            {
                SBound bound = 0;
                StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                        TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                        "anonymous_wstring_unbounded", type_ids_alias_string16, true))
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                }
            }
        }
        bool common_alias_string16_ec {false};
        CommonAliasBody common_alias_string16 {TypeObjectUtils::build_common_alias_body(related_flags_alias_string16,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_string16, common_alias_string16_ec))};
        if (!common_alias_string16_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_string16 related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_string16;
        ann_custom_alias_string16.reset();
        CompleteAliasBody body_alias_string16 = TypeObjectUtils::build_complete_alias_body(common_alias_string16,
                member_ann_builtin_alias_string16, ann_custom_alias_string16);
        CompleteAliasType alias_type_alias_string16 = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_string16,
                header_alias_string16, body_alias_string16);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_string16,
                    type_name_alias_string16.to_string(), type_ids_alias_string16))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_string16 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_enum_type_identifier(
        TypeIdentifierPair& type_ids_alias_enum)
{
    ReturnCode_t return_code_alias_enum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_enum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_enum", type_ids_alias_enum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_enum)
    {
        AliasTypeFlag alias_flags_alias_enum = 0;
        QualifiedTypeName type_name_alias_enum = "alias_enum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_enum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_enum;
        CompleteTypeDetail detail_alias_enum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_enum, ann_custom_alias_enum, type_name_alias_enum.to_string());
        CompleteAliasHeader header_alias_enum = TypeObjectUtils::build_complete_alias_header(detail_alias_enum);
        AliasMemberFlag related_flags_alias_enum = 0;
        return_code_alias_enum =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerEnumHelper", type_ids_alias_enum);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_enum)
        {
        ::register_InnerEnumHelper_type_identifier(type_ids_alias_enum);
        }
        bool common_alias_enum_ec {false};
        CommonAliasBody common_alias_enum {TypeObjectUtils::build_common_alias_body(related_flags_alias_enum,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_enum, common_alias_enum_ec))};
        if (!common_alias_enum_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_enum related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_enum;
        ann_custom_alias_enum.reset();
        CompleteAliasBody body_alias_enum = TypeObjectUtils::build_complete_alias_body(common_alias_enum,
                member_ann_builtin_alias_enum, ann_custom_alias_enum);
        CompleteAliasType alias_type_alias_enum = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_enum,
                header_alias_enum, body_alias_enum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_enum,
                    type_name_alias_enum.to_string(), type_ids_alias_enum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_enum already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_bitmask_type_identifier(
        TypeIdentifierPair& type_ids_alias_bitmask)
{
    ReturnCode_t return_code_alias_bitmask {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_bitmask =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_bitmask", type_ids_alias_bitmask);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_bitmask)
    {
        AliasTypeFlag alias_flags_alias_bitmask = 0;
        QualifiedTypeName type_name_alias_bitmask = "alias_bitmask";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_bitmask;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_bitmask;
        CompleteTypeDetail detail_alias_bitmask = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_bitmask, ann_custom_alias_bitmask, type_name_alias_bitmask.to_string());
        CompleteAliasHeader header_alias_bitmask = TypeObjectUtils::build_complete_alias_header(detail_alias_bitmask);
        AliasMemberFlag related_flags_alias_bitmask = 0;
        return_code_alias_bitmask =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerBitMaskHelper", type_ids_alias_bitmask);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_bitmask)
        {
        ::register_InnerBitMaskHelper_type_identifier(type_ids_alias_bitmask);
        }
        bool common_alias_bitmask_ec {false};
        CommonAliasBody common_alias_bitmask {TypeObjectUtils::build_common_alias_body(related_flags_alias_bitmask,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_bitmask, common_alias_bitmask_ec))};
        if (!common_alias_bitmask_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_bitmask related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_bitmask;
        ann_custom_alias_bitmask.reset();
        CompleteAliasBody body_alias_bitmask = TypeObjectUtils::build_complete_alias_body(common_alias_bitmask,
                member_ann_builtin_alias_bitmask, ann_custom_alias_bitmask);
        CompleteAliasType alias_type_alias_bitmask = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_bitmask,
                header_alias_bitmask, body_alias_bitmask);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_bitmask,
                    type_name_alias_bitmask.to_string(), type_ids_alias_bitmask))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_bitmask already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_alias_type_identifier(
        TypeIdentifierPair& type_ids_alias_alias)
{
    ReturnCode_t return_code_alias_alias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_alias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_alias", type_ids_alias_alias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_alias)
    {
        AliasTypeFlag alias_flags_alias_alias = 0;
        QualifiedTypeName type_name_alias_alias = "alias_alias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_alias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_alias;
        CompleteTypeDetail detail_alias_alias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_alias, ann_custom_alias_alias, type_name_alias_alias.to_string());
        CompleteAliasHeader header_alias_alias = TypeObjectUtils::build_complete_alias_header(detail_alias_alias);
        AliasMemberFlag related_flags_alias_alias = 0;
        return_code_alias_alias =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerAliasHelper", type_ids_alias_alias);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_alias)
        {
        ::register_InnerAliasHelper_type_identifier(type_ids_alias_alias);
        }
        bool common_alias_alias_ec {false};
        CommonAliasBody common_alias_alias {TypeObjectUtils::build_common_alias_body(related_flags_alias_alias,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_alias, common_alias_alias_ec))};
        if (!common_alias_alias_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_alias related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_alias;
        ann_custom_alias_alias.reset();
        CompleteAliasBody body_alias_alias = TypeObjectUtils::build_complete_alias_body(common_alias_alias,
                member_ann_builtin_alias_alias, ann_custom_alias_alias);
        CompleteAliasType alias_type_alias_alias = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_alias,
                header_alias_alias, body_alias_alias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_alias,
                    type_name_alias_alias.to_string(), type_ids_alias_alias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_alias already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_array_type_identifier(
        TypeIdentifierPair& type_ids_alias_array)
{
    ReturnCode_t return_code_alias_array {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_array =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_array", type_ids_alias_array);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_array)
    {
        AliasTypeFlag alias_flags_alias_array = 0;
        QualifiedTypeName type_name_alias_array = "alias_array";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_array;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_array;
        CompleteTypeDetail detail_alias_array = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_array, ann_custom_alias_array, type_name_alias_array.to_string());
        CompleteAliasHeader header_alias_array = TypeObjectUtils::build_complete_alias_header(detail_alias_array);
        AliasMemberFlag related_flags_alias_array = 0;
        return_code_alias_array =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "anonymous_array_int16_t_2", type_ids_alias_array);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_array)
        {
            return_code_alias_array =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_alias_array);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_array)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            bool element_identifier_anonymous_array_int16_t_2_ec {false};
            TypeIdentifier* element_identifier_anonymous_array_int16_t_2 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_array, element_identifier_anonymous_array_int16_t_2_ec))};
            if (!element_identifier_anonymous_array_int16_t_2_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                return;
            }
            EquivalenceKind equiv_kind_anonymous_array_int16_t_2 = EK_COMPLETE;
            if (TK_NONE == type_ids_alias_array.type_identifier2()._d())
            {
                equiv_kind_anonymous_array_int16_t_2 = EK_BOTH;
            }
            CollectionElementFlag element_flags_anonymous_array_int16_t_2 = 0;
            PlainCollectionHeader header_anonymous_array_int16_t_2 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_2, element_flags_anonymous_array_int16_t_2);
            {
                SBoundSeq array_bound_seq;
                    TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(2));

                PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_2, array_bound_seq,
                            eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_2));
                if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                        TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_2", type_ids_alias_array))
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_array_int16_t_2 already registered in TypeObjectRegistry for a different type.");
                }
            }
        }
        bool common_alias_array_ec {false};
        CommonAliasBody common_alias_array {TypeObjectUtils::build_common_alias_body(related_flags_alias_array,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_array, common_alias_array_ec))};
        if (!common_alias_array_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_array related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_array;
        ann_custom_alias_array.reset();
        CompleteAliasBody body_alias_array = TypeObjectUtils::build_complete_alias_body(common_alias_array,
                member_ann_builtin_alias_array, ann_custom_alias_array);
        CompleteAliasType alias_type_alias_array = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_array,
                header_alias_array, body_alias_array);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_array,
                    type_name_alias_array.to_string(), type_ids_alias_array))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_array already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_multiarray_type_identifier(
        TypeIdentifierPair& type_ids_alias_multiarray)
{
    ReturnCode_t return_code_alias_multiarray {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_multiarray =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_multiarray", type_ids_alias_multiarray);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_multiarray)
    {
        AliasTypeFlag alias_flags_alias_multiarray = 0;
        QualifiedTypeName type_name_alias_multiarray = "alias_multiarray";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_multiarray;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_multiarray;
        CompleteTypeDetail detail_alias_multiarray = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_multiarray, ann_custom_alias_multiarray, type_name_alias_multiarray.to_string());
        CompleteAliasHeader header_alias_multiarray = TypeObjectUtils::build_complete_alias_header(detail_alias_multiarray);
        AliasMemberFlag related_flags_alias_multiarray = 0;
        return_code_alias_multiarray =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "anonymous_array_int16_t_2_2", type_ids_alias_multiarray);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_multiarray)
        {
            return_code_alias_multiarray =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_alias_multiarray);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_multiarray)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            bool element_identifier_anonymous_array_int16_t_2_2_ec {false};
            TypeIdentifier* element_identifier_anonymous_array_int16_t_2_2 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_multiarray, element_identifier_anonymous_array_int16_t_2_2_ec))};
            if (!element_identifier_anonymous_array_int16_t_2_2_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                return;
            }
            EquivalenceKind equiv_kind_anonymous_array_int16_t_2_2 = EK_COMPLETE;
            if (TK_NONE == type_ids_alias_multiarray.type_identifier2()._d())
            {
                equiv_kind_anonymous_array_int16_t_2_2 = EK_BOTH;
            }
            CollectionElementFlag element_flags_anonymous_array_int16_t_2_2 = 0;
            PlainCollectionHeader header_anonymous_array_int16_t_2_2 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_2_2, element_flags_anonymous_array_int16_t_2_2);
            {
                SBoundSeq array_bound_seq;
                    TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(2));

                    TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(2));

                PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_2_2, array_bound_seq,
                            eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_2_2));
                if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                        TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_2_2", type_ids_alias_multiarray))
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_array_int16_t_2_2 already registered in TypeObjectRegistry for a different type.");
                }
            }
        }
        bool common_alias_multiarray_ec {false};
        CommonAliasBody common_alias_multiarray {TypeObjectUtils::build_common_alias_body(related_flags_alias_multiarray,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_multiarray, common_alias_multiarray_ec))};
        if (!common_alias_multiarray_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_multiarray related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_multiarray;
        ann_custom_alias_multiarray.reset();
        CompleteAliasBody body_alias_multiarray = TypeObjectUtils::build_complete_alias_body(common_alias_multiarray,
                member_ann_builtin_alias_multiarray, ann_custom_alias_multiarray);
        CompleteAliasType alias_type_alias_multiarray = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_multiarray,
                header_alias_multiarray, body_alias_multiarray);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_multiarray,
                    type_name_alias_multiarray.to_string(), type_ids_alias_multiarray))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_multiarray already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_sequence_type_identifier(
        TypeIdentifierPair& type_ids_alias_sequence)
{
    ReturnCode_t return_code_alias_sequence {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_sequence =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_sequence", type_ids_alias_sequence);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_sequence)
    {
        AliasTypeFlag alias_flags_alias_sequence = 0;
        QualifiedTypeName type_name_alias_sequence = "alias_sequence";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_sequence;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_sequence;
        CompleteTypeDetail detail_alias_sequence = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_sequence, ann_custom_alias_sequence, type_name_alias_sequence.to_string());
        CompleteAliasHeader header_alias_sequence = TypeObjectUtils::build_complete_alias_header(detail_alias_sequence);
        AliasMemberFlag related_flags_alias_sequence = 0;
        return_code_alias_sequence =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "anonymous_sequence_int16_t_unbounded", type_ids_alias_sequence);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_sequence)
        {
            return_code_alias_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_alias_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_sequence)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            bool element_identifier_anonymous_sequence_int16_t_unbounded_ec {false};
            TypeIdentifier* element_identifier_anonymous_sequence_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_sequence, element_identifier_anonymous_sequence_int16_t_unbounded_ec))};
            if (!element_identifier_anonymous_sequence_int16_t_unbounded_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                return;
            }
            EquivalenceKind equiv_kind_anonymous_sequence_int16_t_unbounded = EK_COMPLETE;
            if (TK_NONE == type_ids_alias_sequence.type_identifier2()._d())
            {
                equiv_kind_anonymous_sequence_int16_t_unbounded = EK_BOTH;
            }
            CollectionElementFlag element_flags_anonymous_sequence_int16_t_unbounded = 0;
            PlainCollectionHeader header_anonymous_sequence_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_unbounded, element_flags_anonymous_sequence_int16_t_unbounded);
            {
                SBound bound = 0;
                PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_unbounded, bound,
                            eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_unbounded));
                if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                        TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_unbounded", type_ids_alias_sequence))
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_sequence_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                }
            }
        }
        bool common_alias_sequence_ec {false};
        CommonAliasBody common_alias_sequence {TypeObjectUtils::build_common_alias_body(related_flags_alias_sequence,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_sequence, common_alias_sequence_ec))};
        if (!common_alias_sequence_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_sequence related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_sequence;
        ann_custom_alias_sequence.reset();
        CompleteAliasBody body_alias_sequence = TypeObjectUtils::build_complete_alias_body(common_alias_sequence,
                member_ann_builtin_alias_sequence, ann_custom_alias_sequence);
        CompleteAliasType alias_type_alias_sequence = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_sequence,
                header_alias_sequence, body_alias_sequence);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_sequence,
                    type_name_alias_sequence.to_string(), type_ids_alias_sequence))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_sequence already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_map_type_identifier(
        TypeIdentifierPair& type_ids_alias_map)
{
    ReturnCode_t return_code_alias_map {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_map =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_map", type_ids_alias_map);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_map)
    {
        AliasTypeFlag alias_flags_alias_map = 0;
        QualifiedTypeName type_name_alias_map = "alias_map";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_map;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_map;
        CompleteTypeDetail detail_alias_map = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_map, ann_custom_alias_map, type_name_alias_map.to_string());
        CompleteAliasHeader header_alias_map = TypeObjectUtils::build_complete_alias_header(detail_alias_map);
        AliasMemberFlag related_flags_alias_map = 0;
        return_code_alias_map =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "anonymous_map_int16_t_int16_t_unbounded", type_ids_alias_map);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_map)
        {
            return_code_alias_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_alias_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_map)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            bool element_identifier_anonymous_map_int16_t_int16_t_unbounded_ec {false};
            TypeIdentifier* element_identifier_anonymous_map_int16_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_map, element_identifier_anonymous_map_int16_t_int16_t_unbounded_ec))};
            if (!element_identifier_anonymous_map_int16_t_int16_t_unbounded_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "anonymous_map_int16_t_int16_t_unbounded inconsistent element TypeIdentifier.");
                return;
            }
            return_code_alias_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_alias_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_map)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            bool key_identifier_anonymous_map_int16_t_int16_t_unbounded_ec {false};
            TypeIdentifier* key_identifier_anonymous_map_int16_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_map, key_identifier_anonymous_map_int16_t_int16_t_unbounded_ec))};
            if (!key_identifier_anonymous_map_int16_t_int16_t_unbounded_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "anonymous_map_int16_t_int16_t_unbounded inconsistent key TypeIdentifier.");
                return;
            }
            EquivalenceKind equiv_kind_anonymous_map_int16_t_int16_t_unbounded = EK_BOTH;
            if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d()) ||
                    (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                    (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                    (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                    (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                    (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                    (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->map_ldefn().header().equiv_kind())))
            {
                equiv_kind_anonymous_map_int16_t_int16_t_unbounded = EK_COMPLETE;
            }
            CollectionElementFlag element_flags_anonymous_map_int16_t_int16_t_unbounded = 0;
            CollectionElementFlag key_flags_anonymous_map_int16_t_int16_t_unbounded = 0;
            PlainCollectionHeader header_anonymous_map_int16_t_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_int16_t_unbounded, element_flags_anonymous_map_int16_t_int16_t_unbounded);
            {
                SBound bound = 0;
                PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_int16_t_unbounded, bound,
                            eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_int16_t_unbounded), key_flags_anonymous_map_int16_t_int16_t_unbounded,
                            eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_int16_t_unbounded));
                if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                        TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_int16_t_unbounded", type_ids_alias_map))
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                }
            }
        }
        bool common_alias_map_ec {false};
        CommonAliasBody common_alias_map {TypeObjectUtils::build_common_alias_body(related_flags_alias_map,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_map, common_alias_map_ec))};
        if (!common_alias_map_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_map related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_map;
        ann_custom_alias_map.reset();
        CompleteAliasBody body_alias_map = TypeObjectUtils::build_complete_alias_body(common_alias_map,
                member_ann_builtin_alias_map, ann_custom_alias_map);
        CompleteAliasType alias_type_alias_map = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_map,
                header_alias_map, body_alias_map);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_map,
                    type_name_alias_map.to_string(), type_ids_alias_map))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_map already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_union_type_identifier(
        TypeIdentifierPair& type_ids_alias_union)
{
    ReturnCode_t return_code_alias_union {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_union =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_union", type_ids_alias_union);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_union)
    {
        AliasTypeFlag alias_flags_alias_union = 0;
        QualifiedTypeName type_name_alias_union = "alias_union";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_union;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_union;
        CompleteTypeDetail detail_alias_union = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_union, ann_custom_alias_union, type_name_alias_union.to_string());
        CompleteAliasHeader header_alias_union = TypeObjectUtils::build_complete_alias_header(detail_alias_union);
        AliasMemberFlag related_flags_alias_union = 0;
        return_code_alias_union =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerUnionHelper", type_ids_alias_union);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_union)
        {
        ::register_InnerUnionHelper_type_identifier(type_ids_alias_union);
        }
        bool common_alias_union_ec {false};
        CommonAliasBody common_alias_union {TypeObjectUtils::build_common_alias_body(related_flags_alias_union,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_union, common_alias_union_ec))};
        if (!common_alias_union_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_union related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_union;
        ann_custom_alias_union.reset();
        CompleteAliasBody body_alias_union = TypeObjectUtils::build_complete_alias_body(common_alias_union,
                member_ann_builtin_alias_union, ann_custom_alias_union);
        CompleteAliasType alias_type_alias_union = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_union,
                header_alias_union, body_alias_union);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_union,
                    type_name_alias_union.to_string(), type_ids_alias_union))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_union already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_structure_type_identifier(
        TypeIdentifierPair& type_ids_alias_structure)
{
    ReturnCode_t return_code_alias_structure {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_structure =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_structure", type_ids_alias_structure);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_structure)
    {
        AliasTypeFlag alias_flags_alias_structure = 0;
        QualifiedTypeName type_name_alias_structure = "alias_structure";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_structure;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_structure;
        CompleteTypeDetail detail_alias_structure = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_structure, ann_custom_alias_structure, type_name_alias_structure.to_string());
        CompleteAliasHeader header_alias_structure = TypeObjectUtils::build_complete_alias_header(detail_alias_structure);
        AliasMemberFlag related_flags_alias_structure = 0;
        return_code_alias_structure =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerStructureHelper", type_ids_alias_structure);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_structure)
        {
        ::register_InnerStructureHelper_type_identifier(type_ids_alias_structure);
        }
        bool common_alias_structure_ec {false};
        CommonAliasBody common_alias_structure {TypeObjectUtils::build_common_alias_body(related_flags_alias_structure,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_structure, common_alias_structure_ec))};
        if (!common_alias_structure_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_structure related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_structure;
        ann_custom_alias_structure.reset();
        CompleteAliasBody body_alias_structure = TypeObjectUtils::build_complete_alias_body(common_alias_structure,
                member_ann_builtin_alias_structure, ann_custom_alias_structure);
        CompleteAliasType alias_type_alias_structure = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_structure,
                header_alias_structure, body_alias_structure);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_structure,
                    type_name_alias_structure.to_string(), type_ids_alias_structure))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_structure already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_alias_bitset_type_identifier(
        TypeIdentifierPair& type_ids_alias_bitset)
{
    ReturnCode_t return_code_alias_bitset {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_bitset =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_bitset", type_ids_alias_bitset);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_bitset)
    {
        AliasTypeFlag alias_flags_alias_bitset = 0;
        QualifiedTypeName type_name_alias_bitset = "alias_bitset";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_bitset;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_bitset;
        CompleteTypeDetail detail_alias_bitset = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_bitset, ann_custom_alias_bitset, type_name_alias_bitset.to_string());
        CompleteAliasHeader header_alias_bitset = TypeObjectUtils::build_complete_alias_header(detail_alias_bitset);
        AliasMemberFlag related_flags_alias_bitset = 0;
        return_code_alias_bitset =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerBitsetHelper", type_ids_alias_bitset);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_bitset)
        {
        ::register_InnerBitsetHelper_type_identifier(type_ids_alias_bitset);
        }
        bool common_alias_bitset_ec {false};
        CommonAliasBody common_alias_bitset {TypeObjectUtils::build_common_alias_body(related_flags_alias_bitset,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_bitset, common_alias_bitset_ec))};
        if (!common_alias_bitset_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_bitset related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_bitset;
        ann_custom_alias_bitset.reset();
        CompleteAliasBody body_alias_bitset = TypeObjectUtils::build_complete_alias_body(common_alias_bitset,
                member_ann_builtin_alias_bitset, ann_custom_alias_bitset);
        CompleteAliasType alias_type_alias_bitset = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_bitset,
                header_alias_bitset, body_alias_bitset);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_bitset,
                    type_name_alias_bitset.to_string(), type_ids_alias_bitset))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_bitset already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasInt16_type_identifier(
        TypeIdentifierPair& type_ids_AliasInt16)
{

    ReturnCode_t return_code_AliasInt16 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasInt16 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasInt16", type_ids_AliasInt16);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasInt16)
    {
        StructTypeFlag struct_flags_AliasInt16 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasInt16 = "AliasInt16";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasInt16;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasInt16;
        CompleteTypeDetail detail_AliasInt16 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasInt16, ann_custom_AliasInt16, type_name_AliasInt16.to_string());
        CompleteStructHeader header_AliasInt16;
        header_AliasInt16 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasInt16);
        CompleteStructMemberSeq member_seq_AliasInt16;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_int16", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_int16_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasInt16.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasInt16);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasInt16, member_value);
        }
        CompleteStructType struct_type_AliasInt16 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasInt16, header_AliasInt16, member_seq_AliasInt16);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasInt16, type_name_AliasInt16.to_string(), type_ids_AliasInt16))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasInt16 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasUint16_type_identifier(
        TypeIdentifierPair& type_ids_AliasUint16)
{

    ReturnCode_t return_code_AliasUint16 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasUint16 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasUint16", type_ids_AliasUint16);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasUint16)
    {
        StructTypeFlag struct_flags_AliasUint16 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasUint16 = "AliasUint16";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasUint16;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasUint16;
        CompleteTypeDetail detail_AliasUint16 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasUint16, ann_custom_AliasUint16, type_name_AliasUint16.to_string());
        CompleteStructHeader header_AliasUint16;
        header_AliasUint16 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasUint16);
        CompleteStructMemberSeq member_seq_AliasUint16;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_uint16", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_uint16_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasUint16.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasUint16);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasUint16, member_value);
        }
        CompleteStructType struct_type_AliasUint16 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasUint16, header_AliasUint16, member_seq_AliasUint16);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasUint16, type_name_AliasUint16.to_string(), type_ids_AliasUint16))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasUint16 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasInt32_type_identifier(
        TypeIdentifierPair& type_ids_AliasInt32)
{

    ReturnCode_t return_code_AliasInt32 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasInt32 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasInt32", type_ids_AliasInt32);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasInt32)
    {
        StructTypeFlag struct_flags_AliasInt32 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasInt32 = "AliasInt32";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasInt32;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasInt32;
        CompleteTypeDetail detail_AliasInt32 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasInt32, ann_custom_AliasInt32, type_name_AliasInt32.to_string());
        CompleteStructHeader header_AliasInt32;
        header_AliasInt32 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasInt32);
        CompleteStructMemberSeq member_seq_AliasInt32;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_int32", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_int32_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasInt32.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasInt32);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasInt32, member_value);
        }
        CompleteStructType struct_type_AliasInt32 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasInt32, header_AliasInt32, member_seq_AliasInt32);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasInt32, type_name_AliasInt32.to_string(), type_ids_AliasInt32))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasInt32 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasUInt32_type_identifier(
        TypeIdentifierPair& type_ids_AliasUInt32)
{

    ReturnCode_t return_code_AliasUInt32 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasUInt32 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasUInt32", type_ids_AliasUInt32);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasUInt32)
    {
        StructTypeFlag struct_flags_AliasUInt32 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasUInt32 = "AliasUInt32";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasUInt32;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasUInt32;
        CompleteTypeDetail detail_AliasUInt32 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasUInt32, ann_custom_AliasUInt32, type_name_AliasUInt32.to_string());
        CompleteStructHeader header_AliasUInt32;
        header_AliasUInt32 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasUInt32);
        CompleteStructMemberSeq member_seq_AliasUInt32;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_uint32", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_uint32_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasUInt32.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasUInt32);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasUInt32, member_value);
        }
        CompleteStructType struct_type_AliasUInt32 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasUInt32, header_AliasUInt32, member_seq_AliasUInt32);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasUInt32, type_name_AliasUInt32.to_string(), type_ids_AliasUInt32))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasUInt32 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasInt64_type_identifier(
        TypeIdentifierPair& type_ids_AliasInt64)
{

    ReturnCode_t return_code_AliasInt64 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasInt64 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasInt64", type_ids_AliasInt64);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasInt64)
    {
        StructTypeFlag struct_flags_AliasInt64 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasInt64 = "AliasInt64";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasInt64;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasInt64;
        CompleteTypeDetail detail_AliasInt64 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasInt64, ann_custom_AliasInt64, type_name_AliasInt64.to_string());
        CompleteStructHeader header_AliasInt64;
        header_AliasInt64 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasInt64);
        CompleteStructMemberSeq member_seq_AliasInt64;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_int64", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_int64_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasInt64.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasInt64);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasInt64, member_value);
        }
        CompleteStructType struct_type_AliasInt64 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasInt64, header_AliasInt64, member_seq_AliasInt64);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasInt64, type_name_AliasInt64.to_string(), type_ids_AliasInt64))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasInt64 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasUInt64_type_identifier(
        TypeIdentifierPair& type_ids_AliasUInt64)
{

    ReturnCode_t return_code_AliasUInt64 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasUInt64 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasUInt64", type_ids_AliasUInt64);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasUInt64)
    {
        StructTypeFlag struct_flags_AliasUInt64 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasUInt64 = "AliasUInt64";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasUInt64;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasUInt64;
        CompleteTypeDetail detail_AliasUInt64 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasUInt64, ann_custom_AliasUInt64, type_name_AliasUInt64.to_string());
        CompleteStructHeader header_AliasUInt64;
        header_AliasUInt64 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasUInt64);
        CompleteStructMemberSeq member_seq_AliasUInt64;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_uint64", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_uint64_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasUInt64.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasUInt64);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasUInt64, member_value);
        }
        CompleteStructType struct_type_AliasUInt64 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasUInt64, header_AliasUInt64, member_seq_AliasUInt64);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasUInt64, type_name_AliasUInt64.to_string(), type_ids_AliasUInt64))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasUInt64 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasFloat32_type_identifier(
        TypeIdentifierPair& type_ids_AliasFloat32)
{

    ReturnCode_t return_code_AliasFloat32 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasFloat32 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasFloat32", type_ids_AliasFloat32);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasFloat32)
    {
        StructTypeFlag struct_flags_AliasFloat32 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasFloat32 = "AliasFloat32";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasFloat32;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasFloat32;
        CompleteTypeDetail detail_AliasFloat32 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasFloat32, ann_custom_AliasFloat32, type_name_AliasFloat32.to_string());
        CompleteStructHeader header_AliasFloat32;
        header_AliasFloat32 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasFloat32);
        CompleteStructMemberSeq member_seq_AliasFloat32;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_float32", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_float32_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasFloat32.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasFloat32);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasFloat32, member_value);
        }
        CompleteStructType struct_type_AliasFloat32 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasFloat32, header_AliasFloat32, member_seq_AliasFloat32);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasFloat32, type_name_AliasFloat32.to_string(), type_ids_AliasFloat32))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasFloat32 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasFloat64_type_identifier(
        TypeIdentifierPair& type_ids_AliasFloat64)
{

    ReturnCode_t return_code_AliasFloat64 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasFloat64 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasFloat64", type_ids_AliasFloat64);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasFloat64)
    {
        StructTypeFlag struct_flags_AliasFloat64 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasFloat64 = "AliasFloat64";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasFloat64;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasFloat64;
        CompleteTypeDetail detail_AliasFloat64 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasFloat64, ann_custom_AliasFloat64, type_name_AliasFloat64.to_string());
        CompleteStructHeader header_AliasFloat64;
        header_AliasFloat64 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasFloat64);
        CompleteStructMemberSeq member_seq_AliasFloat64;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_float64", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_float64_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasFloat64.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasFloat64);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasFloat64, member_value);
        }
        CompleteStructType struct_type_AliasFloat64 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasFloat64, header_AliasFloat64, member_seq_AliasFloat64);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasFloat64, type_name_AliasFloat64.to_string(), type_ids_AliasFloat64))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasFloat64 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasFloat128_type_identifier(
        TypeIdentifierPair& type_ids_AliasFloat128)
{

    ReturnCode_t return_code_AliasFloat128 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasFloat128 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasFloat128", type_ids_AliasFloat128);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasFloat128)
    {
        StructTypeFlag struct_flags_AliasFloat128 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasFloat128 = "AliasFloat128";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasFloat128;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasFloat128;
        CompleteTypeDetail detail_AliasFloat128 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasFloat128, ann_custom_AliasFloat128, type_name_AliasFloat128.to_string());
        CompleteStructHeader header_AliasFloat128;
        header_AliasFloat128 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasFloat128);
        CompleteStructMemberSeq member_seq_AliasFloat128;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_float128", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_float128_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasFloat128.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasFloat128);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasFloat128, member_value);
        }
        CompleteStructType struct_type_AliasFloat128 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasFloat128, header_AliasFloat128, member_seq_AliasFloat128);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasFloat128, type_name_AliasFloat128.to_string(), type_ids_AliasFloat128))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasFloat128 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasBool_type_identifier(
        TypeIdentifierPair& type_ids_AliasBool)
{

    ReturnCode_t return_code_AliasBool {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasBool =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasBool", type_ids_AliasBool);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasBool)
    {
        StructTypeFlag struct_flags_AliasBool = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasBool = "AliasBool";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasBool;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasBool;
        CompleteTypeDetail detail_AliasBool = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasBool, ann_custom_AliasBool, type_name_AliasBool.to_string());
        CompleteStructHeader header_AliasBool;
        header_AliasBool = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasBool);
        CompleteStructMemberSeq member_seq_AliasBool;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_bool", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_bool_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasBool.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasBool);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasBool, member_value);
        }
        CompleteStructType struct_type_AliasBool = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasBool, header_AliasBool, member_seq_AliasBool);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasBool, type_name_AliasBool.to_string(), type_ids_AliasBool))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasBool already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasOctet_type_identifier(
        TypeIdentifierPair& type_ids_AliasOctet)
{

    ReturnCode_t return_code_AliasOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasOctet", type_ids_AliasOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasOctet)
    {
        StructTypeFlag struct_flags_AliasOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasOctet = "AliasOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasOctet;
        CompleteTypeDetail detail_AliasOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasOctet, ann_custom_AliasOctet, type_name_AliasOctet.to_string());
        CompleteStructHeader header_AliasOctet;
        header_AliasOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasOctet);
        CompleteStructMemberSeq member_seq_AliasOctet;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_octet", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_octet_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasOctet.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasOctet);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasOctet, member_value);
        }
        CompleteStructType struct_type_AliasOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasOctet, header_AliasOctet, member_seq_AliasOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasOctet, type_name_AliasOctet.to_string(), type_ids_AliasOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasChar8_type_identifier(
        TypeIdentifierPair& type_ids_AliasChar8)
{

    ReturnCode_t return_code_AliasChar8 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasChar8 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasChar8", type_ids_AliasChar8);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasChar8)
    {
        StructTypeFlag struct_flags_AliasChar8 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasChar8 = "AliasChar8";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasChar8;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasChar8;
        CompleteTypeDetail detail_AliasChar8 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasChar8, ann_custom_AliasChar8, type_name_AliasChar8.to_string());
        CompleteStructHeader header_AliasChar8;
        header_AliasChar8 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasChar8);
        CompleteStructMemberSeq member_seq_AliasChar8;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_char8", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_char8_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasChar8.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasChar8);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasChar8, member_value);
        }
        CompleteStructType struct_type_AliasChar8 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasChar8, header_AliasChar8, member_seq_AliasChar8);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasChar8, type_name_AliasChar8.to_string(), type_ids_AliasChar8))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasChar8 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasChar16_type_identifier(
        TypeIdentifierPair& type_ids_AliasChar16)
{

    ReturnCode_t return_code_AliasChar16 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasChar16 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasChar16", type_ids_AliasChar16);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasChar16)
    {
        StructTypeFlag struct_flags_AliasChar16 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasChar16 = "AliasChar16";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasChar16;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasChar16;
        CompleteTypeDetail detail_AliasChar16 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasChar16, ann_custom_AliasChar16, type_name_AliasChar16.to_string());
        CompleteStructHeader header_AliasChar16;
        header_AliasChar16 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasChar16);
        CompleteStructMemberSeq member_seq_AliasChar16;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_char16", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_char16_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasChar16.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasChar16);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasChar16, member_value);
        }
        CompleteStructType struct_type_AliasChar16 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasChar16, header_AliasChar16, member_seq_AliasChar16);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasChar16, type_name_AliasChar16.to_string(), type_ids_AliasChar16))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasChar16 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasString8_type_identifier(
        TypeIdentifierPair& type_ids_AliasString8)
{

    ReturnCode_t return_code_AliasString8 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasString8 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasString8", type_ids_AliasString8);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasString8)
    {
        StructTypeFlag struct_flags_AliasString8 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasString8 = "AliasString8";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasString8;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasString8;
        CompleteTypeDetail detail_AliasString8 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasString8, ann_custom_AliasString8, type_name_AliasString8.to_string());
        CompleteStructHeader header_AliasString8;
        header_AliasString8 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasString8);
        CompleteStructMemberSeq member_seq_AliasString8;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_string8", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_string8_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasString8.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasString8);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasString8, member_value);
        }
        CompleteStructType struct_type_AliasString8 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasString8, header_AliasString8, member_seq_AliasString8);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasString8, type_name_AliasString8.to_string(), type_ids_AliasString8))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasString8 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasString16_type_identifier(
        TypeIdentifierPair& type_ids_AliasString16)
{

    ReturnCode_t return_code_AliasString16 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasString16 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasString16", type_ids_AliasString16);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasString16)
    {
        StructTypeFlag struct_flags_AliasString16 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasString16 = "AliasString16";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasString16;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasString16;
        CompleteTypeDetail detail_AliasString16 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasString16, ann_custom_AliasString16, type_name_AliasString16.to_string());
        CompleteStructHeader header_AliasString16;
        header_AliasString16 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasString16);
        CompleteStructMemberSeq member_seq_AliasString16;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_string16", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_string16_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasString16.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasString16);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasString16, member_value);
        }
        CompleteStructType struct_type_AliasString16 = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasString16, header_AliasString16, member_seq_AliasString16);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasString16, type_name_AliasString16.to_string(), type_ids_AliasString16))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasString16 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasEnum_type_identifier(
        TypeIdentifierPair& type_ids_AliasEnum)
{

    ReturnCode_t return_code_AliasEnum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasEnum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasEnum", type_ids_AliasEnum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasEnum)
    {
        StructTypeFlag struct_flags_AliasEnum = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasEnum = "AliasEnum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasEnum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasEnum;
        CompleteTypeDetail detail_AliasEnum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasEnum, ann_custom_AliasEnum, type_name_AliasEnum.to_string());
        CompleteStructHeader header_AliasEnum;
        header_AliasEnum = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasEnum);
        CompleteStructMemberSeq member_seq_AliasEnum;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_enum", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_enum_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasEnum.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasEnum);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasEnum, member_value);
        }
        CompleteStructType struct_type_AliasEnum = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasEnum, header_AliasEnum, member_seq_AliasEnum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasEnum, type_name_AliasEnum.to_string(), type_ids_AliasEnum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasEnum already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasBitmask_type_identifier(
        TypeIdentifierPair& type_ids_AliasBitmask)
{

    ReturnCode_t return_code_AliasBitmask {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasBitmask =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasBitmask", type_ids_AliasBitmask);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasBitmask)
    {
        StructTypeFlag struct_flags_AliasBitmask = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasBitmask = "AliasBitmask";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasBitmask;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasBitmask;
        CompleteTypeDetail detail_AliasBitmask = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasBitmask, ann_custom_AliasBitmask, type_name_AliasBitmask.to_string());
        CompleteStructHeader header_AliasBitmask;
        header_AliasBitmask = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasBitmask);
        CompleteStructMemberSeq member_seq_AliasBitmask;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_bitmask", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_bitmask_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasBitmask.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasBitmask);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasBitmask, member_value);
        }
        CompleteStructType struct_type_AliasBitmask = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasBitmask, header_AliasBitmask, member_seq_AliasBitmask);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasBitmask, type_name_AliasBitmask.to_string(), type_ids_AliasBitmask))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasBitmask already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasAlias_type_identifier(
        TypeIdentifierPair& type_ids_AliasAlias)
{

    ReturnCode_t return_code_AliasAlias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasAlias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasAlias", type_ids_AliasAlias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasAlias)
    {
        StructTypeFlag struct_flags_AliasAlias = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasAlias = "AliasAlias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasAlias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasAlias;
        CompleteTypeDetail detail_AliasAlias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasAlias, ann_custom_AliasAlias, type_name_AliasAlias.to_string());
        CompleteStructHeader header_AliasAlias;
        header_AliasAlias = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasAlias);
        CompleteStructMemberSeq member_seq_AliasAlias;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_alias", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_alias_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasAlias.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasAlias);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasAlias, member_value);
        }
        CompleteStructType struct_type_AliasAlias = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasAlias, header_AliasAlias, member_seq_AliasAlias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasAlias, type_name_AliasAlias.to_string(), type_ids_AliasAlias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasAlias already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasArray_type_identifier(
        TypeIdentifierPair& type_ids_AliasArray)
{

    ReturnCode_t return_code_AliasArray {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasArray =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasArray", type_ids_AliasArray);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasArray)
    {
        StructTypeFlag struct_flags_AliasArray = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasArray = "AliasArray";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasArray;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasArray;
        CompleteTypeDetail detail_AliasArray = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasArray, ann_custom_AliasArray, type_name_AliasArray.to_string());
        CompleteStructHeader header_AliasArray;
        header_AliasArray = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasArray);
        CompleteStructMemberSeq member_seq_AliasArray;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_array", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_array_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasArray.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasArray);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasArray, member_value);
        }
        CompleteStructType struct_type_AliasArray = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasArray, header_AliasArray, member_seq_AliasArray);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasArray, type_name_AliasArray.to_string(), type_ids_AliasArray))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasArray already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasMultiArray_type_identifier(
        TypeIdentifierPair& type_ids_AliasMultiArray)
{

    ReturnCode_t return_code_AliasMultiArray {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasMultiArray =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasMultiArray", type_ids_AliasMultiArray);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasMultiArray)
    {
        StructTypeFlag struct_flags_AliasMultiArray = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasMultiArray = "AliasMultiArray";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasMultiArray;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasMultiArray;
        CompleteTypeDetail detail_AliasMultiArray = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasMultiArray, ann_custom_AliasMultiArray, type_name_AliasMultiArray.to_string());
        CompleteStructHeader header_AliasMultiArray;
        header_AliasMultiArray = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasMultiArray);
        CompleteStructMemberSeq member_seq_AliasMultiArray;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_multiarray", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_multiarray_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasMultiArray.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasMultiArray);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasMultiArray, member_value);
        }
        CompleteStructType struct_type_AliasMultiArray = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasMultiArray, header_AliasMultiArray, member_seq_AliasMultiArray);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasMultiArray, type_name_AliasMultiArray.to_string(), type_ids_AliasMultiArray))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasMultiArray already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasSequence_type_identifier(
        TypeIdentifierPair& type_ids_AliasSequence)
{

    ReturnCode_t return_code_AliasSequence {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasSequence =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasSequence", type_ids_AliasSequence);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasSequence)
    {
        StructTypeFlag struct_flags_AliasSequence = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasSequence = "AliasSequence";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasSequence;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasSequence;
        CompleteTypeDetail detail_AliasSequence = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasSequence, ann_custom_AliasSequence, type_name_AliasSequence.to_string());
        CompleteStructHeader header_AliasSequence;
        header_AliasSequence = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasSequence);
        CompleteStructMemberSeq member_seq_AliasSequence;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_sequence", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_sequence_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasSequence.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasSequence);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasSequence, member_value);
        }
        CompleteStructType struct_type_AliasSequence = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasSequence, header_AliasSequence, member_seq_AliasSequence);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasSequence, type_name_AliasSequence.to_string(), type_ids_AliasSequence))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasSequence already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasMap_type_identifier(
        TypeIdentifierPair& type_ids_AliasMap)
{

    ReturnCode_t return_code_AliasMap {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasMap =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasMap", type_ids_AliasMap);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasMap)
    {
        StructTypeFlag struct_flags_AliasMap = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasMap = "AliasMap";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasMap;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasMap;
        CompleteTypeDetail detail_AliasMap = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasMap, ann_custom_AliasMap, type_name_AliasMap.to_string());
        CompleteStructHeader header_AliasMap;
        header_AliasMap = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasMap);
        CompleteStructMemberSeq member_seq_AliasMap;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_map", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_map_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasMap.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasMap);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasMap, member_value);
        }
        CompleteStructType struct_type_AliasMap = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasMap, header_AliasMap, member_seq_AliasMap);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasMap, type_name_AliasMap.to_string(), type_ids_AliasMap))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasMap already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasUnion_type_identifier(
        TypeIdentifierPair& type_ids_AliasUnion)
{

    ReturnCode_t return_code_AliasUnion {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasUnion =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasUnion", type_ids_AliasUnion);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasUnion)
    {
        StructTypeFlag struct_flags_AliasUnion = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasUnion = "AliasUnion";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasUnion;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasUnion;
        CompleteTypeDetail detail_AliasUnion = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasUnion, ann_custom_AliasUnion, type_name_AliasUnion.to_string());
        CompleteStructHeader header_AliasUnion;
        header_AliasUnion = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasUnion);
        CompleteStructMemberSeq member_seq_AliasUnion;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_union", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_union_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasUnion.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasUnion);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasUnion, member_value);
        }
        CompleteStructType struct_type_AliasUnion = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasUnion, header_AliasUnion, member_seq_AliasUnion);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasUnion, type_name_AliasUnion.to_string(), type_ids_AliasUnion))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasUnion already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasStruct_type_identifier(
        TypeIdentifierPair& type_ids_AliasStruct)
{

    ReturnCode_t return_code_AliasStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasStruct", type_ids_AliasStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasStruct)
    {
        StructTypeFlag struct_flags_AliasStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasStruct = "AliasStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasStruct;
        CompleteTypeDetail detail_AliasStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasStruct, ann_custom_AliasStruct, type_name_AliasStruct.to_string());
        CompleteStructHeader header_AliasStruct;
        header_AliasStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasStruct);
        CompleteStructMemberSeq member_seq_AliasStruct;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_structure", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_structure_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasStruct.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasStruct);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasStruct, member_value);
        }
        CompleteStructType struct_type_AliasStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasStruct, header_AliasStruct, member_seq_AliasStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasStruct, type_name_AliasStruct.to_string(), type_ids_AliasStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AliasBitset_type_identifier(
        TypeIdentifierPair& type_ids_AliasBitset)
{

    ReturnCode_t return_code_AliasBitset {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasBitset =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AliasBitset", type_ids_AliasBitset);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasBitset)
    {
        StructTypeFlag struct_flags_AliasBitset = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AliasBitset = "AliasBitset";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasBitset;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasBitset;
        CompleteTypeDetail detail_AliasBitset = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasBitset, ann_custom_AliasBitset, type_name_AliasBitset.to_string());
        CompleteStructHeader header_AliasBitset;
        header_AliasBitset = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AliasBitset);
        CompleteStructMemberSeq member_seq_AliasBitset;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_bitset", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_alias_bitset_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_AliasBitset.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_AliasBitset);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AliasBitset, member_value);
        }
        CompleteStructType struct_type_AliasBitset = TypeObjectUtils::build_complete_struct_type(struct_flags_AliasBitset, header_AliasBitset, member_seq_AliasBitset);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AliasBitset, type_name_AliasBitset.to_string(), type_ids_AliasBitset))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AliasBitset already registered in TypeObjectRegistry for a different type.");
        }
    }
}
