// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file structuresCdrAux.hpp
 * This source file contains some definitions of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__STRUCTURESCDRAUX_HPP
#define FAST_DDS_GENERATED__STRUCTURESCDRAUX_HPP

#include "structures.hpp"
constexpr uint32_t StructChar8_max_cdr_typesize {5UL};
constexpr uint32_t StructChar8_max_key_cdr_typesize {0UL};

constexpr uint32_t StructBoolean_max_cdr_typesize {5UL};
constexpr uint32_t StructBoolean_max_key_cdr_typesize {0UL};

constexpr uint32_t StructBoundedString_max_cdr_typesize {19UL};
constexpr uint32_t StructBoundedString_max_key_cdr_typesize {0UL};

constexpr uint32_t StructChar16_max_cdr_typesize {6UL};
constexpr uint32_t StructChar16_max_key_cdr_typesize {0UL};

constexpr uint32_t StructOctet_max_cdr_typesize {5UL};
constexpr uint32_t StructOctet_max_key_cdr_typesize {0UL};

constexpr uint32_t StructShort_max_cdr_typesize {6UL};
constexpr uint32_t StructShort_max_key_cdr_typesize {0UL};

constexpr uint32_t StructStructure_max_cdr_typesize {16UL};
constexpr uint32_t StructStructure_max_key_cdr_typesize {0UL};

constexpr uint32_t StructEmpty_max_cdr_typesize {4UL};
constexpr uint32_t StructEmpty_max_key_cdr_typesize {0UL};

constexpr uint32_t bar_max_cdr_typesize {16UL};
constexpr uint32_t bar_max_key_cdr_typesize {0UL};

constexpr uint32_t StructBitMask_max_cdr_typesize {8UL};
constexpr uint32_t StructBitMask_max_key_cdr_typesize {0UL};

constexpr uint32_t testing_1_foo_max_cdr_typesize {12UL};
constexpr uint32_t testing_1_foo_max_key_cdr_typesize {0UL};

constexpr uint32_t StructShortArray_max_cdr_typesize {24UL};
constexpr uint32_t StructShortArray_max_key_cdr_typesize {0UL};


constexpr uint32_t StructLongDouble_max_cdr_typesize {24UL};
constexpr uint32_t StructLongDouble_max_key_cdr_typesize {0UL};

constexpr uint32_t StructMap_max_cdr_typesize {8UL};
constexpr uint32_t StructMap_max_key_cdr_typesize {0UL};

constexpr uint32_t StructUnsignedShort_max_cdr_typesize {6UL};
constexpr uint32_t StructUnsignedShort_max_key_cdr_typesize {0UL};



constexpr uint32_t StructLongLong_max_cdr_typesize {16UL};
constexpr uint32_t StructLongLong_max_key_cdr_typesize {0UL};

constexpr uint32_t StructString_max_cdr_typesize {264UL};
constexpr uint32_t StructString_max_key_cdr_typesize {0UL};

constexpr uint32_t StructBitset_max_cdr_typesize {16UL};
constexpr uint32_t StructBitset_max_key_cdr_typesize {0UL};





constexpr uint32_t StructFloat_max_cdr_typesize {8UL};
constexpr uint32_t StructFloat_max_key_cdr_typesize {0UL};

constexpr uint32_t StructAlias_max_cdr_typesize {8UL};
constexpr uint32_t StructAlias_max_key_cdr_typesize {0UL};

constexpr uint32_t StructSequence_max_cdr_typesize {8UL};
constexpr uint32_t StructSequence_max_key_cdr_typesize {0UL};

constexpr uint32_t StructBoundedWString_max_cdr_typesize {28UL};
constexpr uint32_t StructBoundedWString_max_key_cdr_typesize {0UL};

constexpr uint32_t StructEnum_max_cdr_typesize {8UL};
constexpr uint32_t StructEnum_max_key_cdr_typesize {0UL};

constexpr uint32_t StructLong_max_cdr_typesize {8UL};
constexpr uint32_t StructLong_max_key_cdr_typesize {0UL};

constexpr uint32_t root_max_cdr_typesize {48UL};
constexpr uint32_t root_max_key_cdr_typesize {0UL};

constexpr uint32_t Structures_max_cdr_typesize {1092UL};
constexpr uint32_t Structures_max_key_cdr_typesize {0UL};

constexpr uint32_t StructUnsignedLong_max_cdr_typesize {8UL};
constexpr uint32_t StructUnsignedLong_max_key_cdr_typesize {0UL};

constexpr uint32_t StructDouble_max_cdr_typesize {16UL};
constexpr uint32_t StructDouble_max_key_cdr_typesize {0UL};


constexpr uint32_t StructWString_max_cdr_typesize {518UL};
constexpr uint32_t StructWString_max_key_cdr_typesize {0UL};


constexpr uint32_t root2_max_cdr_typesize {24UL};
constexpr uint32_t root2_max_key_cdr_typesize {0UL};

constexpr uint32_t testing_2_foo_max_cdr_typesize {5UL};
constexpr uint32_t testing_2_foo_max_key_cdr_typesize {0UL};




constexpr uint32_t root1_max_cdr_typesize {20UL};
constexpr uint32_t root1_max_key_cdr_typesize {0UL};

constexpr uint32_t StructUnion_max_cdr_typesize {16UL};
constexpr uint32_t StructUnion_max_key_cdr_typesize {0UL};

constexpr uint32_t StructUnsignedLongLong_max_cdr_typesize {16UL};
constexpr uint32_t StructUnsignedLongLong_max_key_cdr_typesize {0UL};




namespace eprosima {
namespace fastcdr {

class Cdr;
class CdrSizeCalculator;

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructShort& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructUnsignedShort& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructLong& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructUnsignedLong& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructLongLong& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructUnsignedLongLong& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructFloat& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructDouble& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructLongDouble& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructBoolean& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructOctet& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructChar8& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructChar16& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructString& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructWString& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructBoundedString& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructBoundedWString& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructEnum& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructBitMask& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructAlias& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructShortArray& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructSequence& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructMap& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructUnion& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructStructure& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructBitset& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructEmpty& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const Structures& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const testing_1::foo& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const testing_2::foo& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const bar& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const root1& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const root2& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const root& data);


} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__STRUCTURESCDRAUX_HPP

