/*
    Copyright (C) 2012 Sebastian Pancratz
    Copyright (C) 2012 Andres Goens
    Copyright (C) 2013 Mike Hansen

    This file is part of FLINT.

    FLINT is free software: you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License (LGPL) as published
    by the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.  See <https://www.gnu.org/licenses/>.
*/

#ifdef T

#include "test_helpers.h"
#include "templates.h"

TEST_TEMPLATE_FUNCTION_START(T, pth_root, state)
{
    int i, result;

    /* Compare with sum of Galois conjugates */
    for (i = 0; i < 100 * flint_test_multiplier(); i++)
    {
        TEMPLATE(T, ctx_t) ctx;
        TEMPLATE(T, t) a, b;

#if defined(FQ_NMOD_H) || defined(FQ_ZECH_H)
        TEMPLATE(T, ctx_init_randtest)(ctx, state, 1);
#else
        TEMPLATE(T, ctx_init_randtest)(ctx, state, 0);
#endif

        TEMPLATE(T, init)(a, ctx);
        TEMPLATE(T, init)(b, ctx);

        TEMPLATE(T, randtest)(a, state, ctx);
        TEMPLATE(T, pth_root)(b, a, ctx);
#if defined(FQ_NMOD_H) || defined(FQ_ZECH_H)
        TEMPLATE(T, pow_ui)(b, b, TEMPLATE(T, ctx_prime)(ctx), ctx);
#else
        TEMPLATE(T, pow)(b, b, TEMPLATE(T, ctx_prime)(ctx), ctx);
#endif

        result = TEMPLATE(T, equal)(a, b, ctx);
        if (!result)
        {
            flint_printf("FAIL:\n\n");
            flint_printf("a = "), TEMPLATE(T, print_pretty)(a, ctx), flint_printf("\n");
            flint_printf("b = "), TEMPLATE(T, print_pretty)(b, ctx), flint_printf("\n");
            fflush(stdout);
            flint_abort();
        }

        TEMPLATE(T, clear)(a, ctx);
        TEMPLATE(T, clear)(b, ctx);

        TEMPLATE(T, ctx_clear)(ctx);
    }

    TEST_FUNCTION_END(state);
}
#endif
