/*
 *  Copyright 1994-2022 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "globals.h"
#include "sequences.h"


/* TODO un g_list_find */
GList *
Sequences_find(const uint64_t id)
{
  GList *tmp;

  assert(NULL != sequences);
  tmp = sequences->seqs;

  while (NULL != tmp) {
    Sequence_t *s = (Sequence_t *)tmp->data;

    if (s->id == id) {
      return tmp;
    }

    tmp = g_list_next(tmp);
  }

  return NULL;
}
