; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --no_x86_scrub_sp

; Combined ABI tests for fp128 and i128

; RUN: sed 's/PrimTy/fp128/g' %s | sed 's/Prim0/0xL0/g' | llc -mtriple=x86_64-unknown-linux-gnu -verify-machineinstrs | FileCheck %s --check-prefix=CHECK-X64-F128
; RUN: sed 's/PrimTy/i128/g'  %s | sed 's/Prim0/0/g'    | llc -mtriple=x86_64-unknown-linux-gnu -verify-machineinstrs | FileCheck %s --check-prefix=CHECK-X64-I128
; RUN: sed 's/PrimTy/fp128/g' %s | sed 's/Prim0/0xL0/g' | llc -mtriple=x86_64-pc-windows-msvc -verify-machineinstrs   | FileCheck %s --check-prefix=CHECK-MSVC64-F128
; RUN: sed 's/PrimTy/i128/g'  %s | sed 's/Prim0/0/g'    | llc -mtriple=x86_64-pc-windows-msvc -verify-machineinstrs   | FileCheck %s --check-prefix=CHECK-MSVC64-I128
; RUN: sed 's/PrimTy/fp128/g' %s | sed 's/Prim0/0xL0/g' | llc -mtriple=x86_64-pc-windows-gnu -verify-machineinstrs    | FileCheck %s --check-prefix=CHECK-MINGW-F128
; RUN: sed 's/PrimTy/i128/g'  %s | sed 's/Prim0/0/g'    | llc -mtriple=x86_64-pc-windows-gnu -verify-machineinstrs    | FileCheck %s --check-prefix=CHECK-MINGW-I128
;
; Use the same directive for i128 and fp128 on x86-32 since both are passed and returned on the stack.
; RUN: sed 's/PrimTy/fp128/g' %s | sed 's/Prim0/0xL0/g' | llc -mtriple=i686-unknown-linux-gnu -verify-machineinstrs   | FileCheck %s --check-prefix=CHECK-X86
; RUN: sed 's/PrimTy/i128/g'  %s | sed 's/Prim0/0/g'    | llc -mtriple=i686-unknown-linux-gnu -verify-machineinstrs   | FileCheck %s --check-prefix=CHECK-X86
; RUN: sed 's/PrimTy/fp128/g' %s | sed 's/Prim0/0xL0/g' | llc -mtriple=i686-pc-windows-msvc -verify-machineinstrs     | FileCheck %s --check-prefix=CHECK-MSVC32
; RUN: sed 's/PrimTy/i128/g'  %s | sed 's/Prim0/0/g'    | llc -mtriple=i686-pc-windows-msvc -verify-machineinstrs     | FileCheck %s --check-prefix=CHECK-MSVC32

define void @store(PrimTy %x, ptr %p) nounwind {
; CHECK-X64-F128-LABEL: store:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    movaps %xmm0, (%rdi)
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: store:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    movq %rsi, 8(%rdx)
; CHECK-X64-I128-NEXT:    movq %rdi, (%rdx)
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: store:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MSVC64-F128-NEXT:    movaps %xmm0, (%rdx)
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: store:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    movq %rdx, 8(%r8)
; CHECK-MSVC64-I128-NEXT:    movq %rcx, (%r8)
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: store:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MINGW-F128-NEXT:    movaps %xmm0, (%rdx)
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: store:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    movq %rdx, 8(%r8)
; CHECK-MINGW-I128-NEXT:    movq %rcx, (%r8)
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: store:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %edi
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    pushl %eax
; CHECK-X86-NEXT:    movl 16(%esp), %eax
; CHECK-X86-NEXT:    movl 20(%esp), %ecx
; CHECK-X86-NEXT:    movl 24(%esp), %edx
; CHECK-X86-NEXT:    movl 28(%esp), %esi
; CHECK-X86-NEXT:    movl 32(%esp), %edi
; CHECK-X86-NEXT:    movl %esi, 12(%edi)
; CHECK-X86-NEXT:    movl %edx, 8(%edi)
; CHECK-X86-NEXT:    movl %ecx, 4(%edi)
; CHECK-X86-NEXT:    movl %eax, (%edi)
; CHECK-X86-NEXT:    addl $4, %esp
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    popl %edi
; CHECK-X86-NEXT:    retl
;
; CHECK-MSVC32-LABEL: store:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %ebp
; CHECK-MSVC32-NEXT:    movl %esp, %ebp
; CHECK-MSVC32-NEXT:    pushl %edi
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    andl $-16, %esp
; CHECK-MSVC32-NEXT:    movl 8(%ebp), %eax
; CHECK-MSVC32-NEXT:    movl 12(%ebp), %ecx
; CHECK-MSVC32-NEXT:    movl 16(%ebp), %edx
; CHECK-MSVC32-NEXT:    movl 20(%ebp), %esi
; CHECK-MSVC32-NEXT:    movl 24(%ebp), %edi
; CHECK-MSVC32-NEXT:    movl %esi, 12(%edi)
; CHECK-MSVC32-NEXT:    movl %edx, 8(%edi)
; CHECK-MSVC32-NEXT:    movl %ecx, 4(%edi)
; CHECK-MSVC32-NEXT:    movl %eax, (%edi)
; CHECK-MSVC32-NEXT:    leal -8(%ebp), %esp
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %edi
; CHECK-MSVC32-NEXT:    popl %ebp
; CHECK-MSVC32-NEXT:    retl
  store PrimTy %x, ptr %p
  ret void
}

; Illustrate stack alignment
define void @store_perturbed(i8 %_0, PrimTy %x, ptr %p) nounwind {
; CHECK-X64-F128-LABEL: store_perturbed:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    movaps %xmm0, (%rsi)
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: store_perturbed:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    movq %rdx, 8(%rcx)
; CHECK-X64-I128-NEXT:    movq %rsi, (%rcx)
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: store_perturbed:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    movaps (%rdx), %xmm0
; CHECK-MSVC64-F128-NEXT:    movaps %xmm0, (%r8)
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: store_perturbed:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    movq %r8, 8(%r9)
; CHECK-MSVC64-I128-NEXT:    movq %rdx, (%r9)
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: store_perturbed:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    movaps (%rdx), %xmm0
; CHECK-MINGW-F128-NEXT:    movaps %xmm0, (%r8)
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: store_perturbed:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    movq %r8, 8(%r9)
; CHECK-MINGW-I128-NEXT:    movq %rdx, (%r9)
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: store_perturbed:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %edi
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    pushl %eax
; CHECK-X86-NEXT:    movl 32(%esp), %eax
; CHECK-X86-NEXT:    movl 36(%esp), %ecx
; CHECK-X86-NEXT:    movl 40(%esp), %edx
; CHECK-X86-NEXT:    movl 44(%esp), %esi
; CHECK-X86-NEXT:    movl 48(%esp), %edi
; CHECK-X86-NEXT:    movl %esi, 12(%edi)
; CHECK-X86-NEXT:    movl %edx, 8(%edi)
; CHECK-X86-NEXT:    movl %ecx, 4(%edi)
; CHECK-X86-NEXT:    movl %eax, (%edi)
; CHECK-X86-NEXT:    addl $4, %esp
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    popl %edi
; CHECK-X86-NEXT:    retl
;
; CHECK-MSVC32-LABEL: store_perturbed:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %ebp
; CHECK-MSVC32-NEXT:    movl %esp, %ebp
; CHECK-MSVC32-NEXT:    pushl %edi
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    andl $-16, %esp
; CHECK-MSVC32-NEXT:    movl 24(%ebp), %eax
; CHECK-MSVC32-NEXT:    movl 28(%ebp), %ecx
; CHECK-MSVC32-NEXT:    movl 32(%ebp), %edx
; CHECK-MSVC32-NEXT:    movl 36(%ebp), %esi
; CHECK-MSVC32-NEXT:    movl 40(%ebp), %edi
; CHECK-MSVC32-NEXT:    movl %esi, 12(%edi)
; CHECK-MSVC32-NEXT:    movl %edx, 8(%edi)
; CHECK-MSVC32-NEXT:    movl %ecx, 4(%edi)
; CHECK-MSVC32-NEXT:    movl %eax, (%edi)
; CHECK-MSVC32-NEXT:    leal -8(%ebp), %esp
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %edi
; CHECK-MSVC32-NEXT:    popl %ebp
; CHECK-MSVC32-NEXT:    retl
  store PrimTy %x, ptr %p
  ret void
}

define PrimTy @return(ptr %p) nounwind {
; CHECK-X64-F128-LABEL: return:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    movaps (%rdi), %xmm0
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: return:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    movq (%rdi), %rax
; CHECK-X64-I128-NEXT:    movq 8(%rdi), %rdx
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: return:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: return:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    movq (%rcx), %rax
; CHECK-MSVC64-I128-NEXT:    movq 8(%rcx), %rdx
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: return:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: return:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    movq (%rcx), %rax
; CHECK-MINGW-I128-NEXT:    movq 8(%rcx), %rdx
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: return:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %edi
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    movl 12(%esp), %eax
; CHECK-X86-NEXT:    movl 16(%esp), %ecx
; CHECK-X86-NEXT:    movl (%ecx), %edx
; CHECK-X86-NEXT:    movl 4(%ecx), %esi
; CHECK-X86-NEXT:    movl 8(%ecx), %edi
; CHECK-X86-NEXT:    movl 12(%ecx), %ecx
; CHECK-X86-NEXT:    movl %ecx, 12(%eax)
; CHECK-X86-NEXT:    movl %edi, 8(%eax)
; CHECK-X86-NEXT:    movl %esi, 4(%eax)
; CHECK-X86-NEXT:    movl %edx, (%eax)
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    popl %edi
; CHECK-X86-NEXT:    retl $4
;
; CHECK-MSVC32-LABEL: return:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %edi
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    movl 12(%esp), %eax
; CHECK-MSVC32-NEXT:    movl 16(%esp), %ecx
; CHECK-MSVC32-NEXT:    movl (%ecx), %edx
; CHECK-MSVC32-NEXT:    movl 4(%ecx), %esi
; CHECK-MSVC32-NEXT:    movl 8(%ecx), %edi
; CHECK-MSVC32-NEXT:    movl 12(%ecx), %ecx
; CHECK-MSVC32-NEXT:    movl %ecx, 12(%eax)
; CHECK-MSVC32-NEXT:    movl %edi, 8(%eax)
; CHECK-MSVC32-NEXT:    movl %esi, 4(%eax)
; CHECK-MSVC32-NEXT:    movl %edx, (%eax)
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %edi
; CHECK-MSVC32-NEXT:    retl
  %r = load PrimTy, ptr %p, align 16
  ret PrimTy %r
}

define PrimTy @first_arg(PrimTy %x) nounwind {
; CHECK-X64-F128-LABEL: first_arg:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: first_arg:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    movq %rsi, %rdx
; CHECK-X64-I128-NEXT:    movq %rdi, %rax
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: first_arg:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: first_arg:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    movq %rcx, %rax
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: first_arg:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: first_arg:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    movq %rcx, %rax
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: first_arg:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %edi
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    pushl %eax
; CHECK-X86-NEXT:    movl 16(%esp), %eax
; CHECK-X86-NEXT:    movl 32(%esp), %ecx
; CHECK-X86-NEXT:    movl 36(%esp), %edx
; CHECK-X86-NEXT:    movl 40(%esp), %esi
; CHECK-X86-NEXT:    movl 44(%esp), %edi
; CHECK-X86-NEXT:    movl %edi, 12(%eax)
; CHECK-X86-NEXT:    movl %esi, 8(%eax)
; CHECK-X86-NEXT:    movl %edx, 4(%eax)
; CHECK-X86-NEXT:    movl %ecx, (%eax)
; CHECK-X86-NEXT:    addl $4, %esp
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    popl %edi
; CHECK-X86-NEXT:    retl $4
;
; CHECK-MSVC32-LABEL: first_arg:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %ebp
; CHECK-MSVC32-NEXT:    movl %esp, %ebp
; CHECK-MSVC32-NEXT:    pushl %edi
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    andl $-16, %esp
; CHECK-MSVC32-NEXT:    movl 8(%ebp), %eax
; CHECK-MSVC32-NEXT:    movl 24(%ebp), %ecx
; CHECK-MSVC32-NEXT:    movl 28(%ebp), %edx
; CHECK-MSVC32-NEXT:    movl 32(%ebp), %esi
; CHECK-MSVC32-NEXT:    movl 36(%ebp), %edi
; CHECK-MSVC32-NEXT:    movl %edi, 12(%eax)
; CHECK-MSVC32-NEXT:    movl %esi, 8(%eax)
; CHECK-MSVC32-NEXT:    movl %edx, 4(%eax)
; CHECK-MSVC32-NEXT:    movl %ecx, (%eax)
; CHECK-MSVC32-NEXT:    leal -8(%ebp), %esp
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %edi
; CHECK-MSVC32-NEXT:    popl %ebp
; CHECK-MSVC32-NEXT:    retl
  ret PrimTy %x
}

; Leading args such that i128 is the last possible position where it still
; gets passed in registers.
define PrimTy @leading_args(i64 %_0, i64 %_1, i64 %_2, i64 %_3, PrimTy %x) nounwind {
; CHECK-X64-F128-LABEL: leading_args:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: leading_args:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    movq %r9, %rdx
; CHECK-X64-I128-NEXT:    movq %r8, %rax
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: leading_args:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    movq 40(%rsp), %rax
; CHECK-MSVC64-F128-NEXT:    movaps (%rax), %xmm0
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: leading_args:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    movq 40(%rsp), %rax
; CHECK-MSVC64-I128-NEXT:    movq 48(%rsp), %rdx
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: leading_args:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    movq 40(%rsp), %rax
; CHECK-MINGW-F128-NEXT:    movaps (%rax), %xmm0
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: leading_args:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    movq 40(%rsp), %rax
; CHECK-MINGW-I128-NEXT:    movq 48(%rsp), %rdx
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: leading_args:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %edi
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    pushl %eax
; CHECK-X86-NEXT:    movl 16(%esp), %eax
; CHECK-X86-NEXT:    movl 64(%esp), %ecx
; CHECK-X86-NEXT:    movl 68(%esp), %edx
; CHECK-X86-NEXT:    movl 72(%esp), %esi
; CHECK-X86-NEXT:    movl 76(%esp), %edi
; CHECK-X86-NEXT:    movl %edi, 12(%eax)
; CHECK-X86-NEXT:    movl %esi, 8(%eax)
; CHECK-X86-NEXT:    movl %edx, 4(%eax)
; CHECK-X86-NEXT:    movl %ecx, (%eax)
; CHECK-X86-NEXT:    addl $4, %esp
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    popl %edi
; CHECK-X86-NEXT:    retl $4
;
; CHECK-MSVC32-LABEL: leading_args:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %ebp
; CHECK-MSVC32-NEXT:    movl %esp, %ebp
; CHECK-MSVC32-NEXT:    pushl %edi
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    andl $-16, %esp
; CHECK-MSVC32-NEXT:    movl 8(%ebp), %eax
; CHECK-MSVC32-NEXT:    movl 56(%ebp), %ecx
; CHECK-MSVC32-NEXT:    movl 60(%ebp), %edx
; CHECK-MSVC32-NEXT:    movl 64(%ebp), %esi
; CHECK-MSVC32-NEXT:    movl 68(%ebp), %edi
; CHECK-MSVC32-NEXT:    movl %edi, 12(%eax)
; CHECK-MSVC32-NEXT:    movl %esi, 8(%eax)
; CHECK-MSVC32-NEXT:    movl %edx, 4(%eax)
; CHECK-MSVC32-NEXT:    movl %ecx, (%eax)
; CHECK-MSVC32-NEXT:    leal -8(%ebp), %esp
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %edi
; CHECK-MSVC32-NEXT:    popl %ebp
; CHECK-MSVC32-NEXT:    retl
  ret PrimTy %x
}

; The i128 of interest must be in memory.
define PrimTy @many_leading_args(i64 %_0, i64 %_1, i64 %_2, i64 %_3, i64 %_4, PrimTy %_5, PrimTy %x) nounwind {
; CHECK-X64-F128-LABEL: many_leading_args:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    movaps %xmm1, %xmm0
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: many_leading_args:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    movq 24(%rsp), %rax
; CHECK-X64-I128-NEXT:    movq 32(%rsp), %rdx
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: many_leading_args:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    movq 56(%rsp), %rax
; CHECK-MSVC64-F128-NEXT:    movaps (%rax), %xmm0
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: many_leading_args:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    movq 64(%rsp), %rax
; CHECK-MSVC64-I128-NEXT:    movq 72(%rsp), %rdx
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: many_leading_args:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    movq 56(%rsp), %rax
; CHECK-MINGW-F128-NEXT:    movaps (%rax), %xmm0
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: many_leading_args:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    movq 64(%rsp), %rax
; CHECK-MINGW-I128-NEXT:    movq 72(%rsp), %rdx
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: many_leading_args:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %edi
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    pushl %eax
; CHECK-X86-NEXT:    movl 16(%esp), %eax
; CHECK-X86-NEXT:    movl 80(%esp), %ecx
; CHECK-X86-NEXT:    movl 84(%esp), %edx
; CHECK-X86-NEXT:    movl 88(%esp), %esi
; CHECK-X86-NEXT:    movl 92(%esp), %edi
; CHECK-X86-NEXT:    movl %edi, 12(%eax)
; CHECK-X86-NEXT:    movl %esi, 8(%eax)
; CHECK-X86-NEXT:    movl %edx, 4(%eax)
; CHECK-X86-NEXT:    movl %ecx, (%eax)
; CHECK-X86-NEXT:    addl $4, %esp
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    popl %edi
; CHECK-X86-NEXT:    retl $4
;
; CHECK-MSVC32-LABEL: many_leading_args:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %ebp
; CHECK-MSVC32-NEXT:    movl %esp, %ebp
; CHECK-MSVC32-NEXT:    pushl %edi
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    andl $-16, %esp
; CHECK-MSVC32-NEXT:    movl 8(%ebp), %eax
; CHECK-MSVC32-NEXT:    movl 72(%ebp), %ecx
; CHECK-MSVC32-NEXT:    movl 76(%ebp), %edx
; CHECK-MSVC32-NEXT:    movl 80(%ebp), %esi
; CHECK-MSVC32-NEXT:    movl 84(%ebp), %edi
; CHECK-MSVC32-NEXT:    movl %edi, 12(%eax)
; CHECK-MSVC32-NEXT:    movl %esi, 8(%eax)
; CHECK-MSVC32-NEXT:    movl %edx, 4(%eax)
; CHECK-MSVC32-NEXT:    movl %ecx, (%eax)
; CHECK-MSVC32-NEXT:    leal -8(%ebp), %esp
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %edi
; CHECK-MSVC32-NEXT:    popl %ebp
; CHECK-MSVC32-NEXT:    retl
  ret PrimTy %x
}

define PrimTy @trailing_arg(i64 %_0, i64 %_1, i64 %_2, i64 %_3, i64 %_4, PrimTy %x, i64 %_5) nounwind {
; CHECK-X64-F128-LABEL: trailing_arg:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: trailing_arg:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    movq 8(%rsp), %rax
; CHECK-X64-I128-NEXT:    movq 16(%rsp), %rdx
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: trailing_arg:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    movq 48(%rsp), %rax
; CHECK-MSVC64-F128-NEXT:    movaps (%rax), %xmm0
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: trailing_arg:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    movq 48(%rsp), %rax
; CHECK-MSVC64-I128-NEXT:    movq 56(%rsp), %rdx
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: trailing_arg:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    movq 48(%rsp), %rax
; CHECK-MINGW-F128-NEXT:    movaps (%rax), %xmm0
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: trailing_arg:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    movq 48(%rsp), %rax
; CHECK-MINGW-I128-NEXT:    movq 56(%rsp), %rdx
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: trailing_arg:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %edi
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    pushl %eax
; CHECK-X86-NEXT:    movl 16(%esp), %eax
; CHECK-X86-NEXT:    movl 64(%esp), %ecx
; CHECK-X86-NEXT:    movl 68(%esp), %edx
; CHECK-X86-NEXT:    movl 72(%esp), %esi
; CHECK-X86-NEXT:    movl 76(%esp), %edi
; CHECK-X86-NEXT:    movl %edi, 12(%eax)
; CHECK-X86-NEXT:    movl %esi, 8(%eax)
; CHECK-X86-NEXT:    movl %edx, 4(%eax)
; CHECK-X86-NEXT:    movl %ecx, (%eax)
; CHECK-X86-NEXT:    addl $4, %esp
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    popl %edi
; CHECK-X86-NEXT:    retl $4
;
; CHECK-MSVC32-LABEL: trailing_arg:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %ebp
; CHECK-MSVC32-NEXT:    movl %esp, %ebp
; CHECK-MSVC32-NEXT:    pushl %edi
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    andl $-16, %esp
; CHECK-MSVC32-NEXT:    movl 8(%ebp), %eax
; CHECK-MSVC32-NEXT:    movl 56(%ebp), %ecx
; CHECK-MSVC32-NEXT:    movl 60(%ebp), %edx
; CHECK-MSVC32-NEXT:    movl 64(%ebp), %esi
; CHECK-MSVC32-NEXT:    movl 68(%ebp), %edi
; CHECK-MSVC32-NEXT:    movl %edi, 12(%eax)
; CHECK-MSVC32-NEXT:    movl %esi, 8(%eax)
; CHECK-MSVC32-NEXT:    movl %edx, 4(%eax)
; CHECK-MSVC32-NEXT:    movl %ecx, (%eax)
; CHECK-MSVC32-NEXT:    leal -8(%ebp), %esp
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %edi
; CHECK-MSVC32-NEXT:    popl %ebp
; CHECK-MSVC32-NEXT:    retl
  ret PrimTy %x
}

define void @call_first_arg(PrimTy %x) nounwind {
; CHECK-X64-F128-LABEL: call_first_arg:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    pushq %rax
; CHECK-X64-F128-NEXT:    callq first_arg@PLT
; CHECK-X64-F128-NEXT:    popq %rax
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: call_first_arg:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    pushq %rax
; CHECK-X64-I128-NEXT:    callq first_arg@PLT
; CHECK-X64-I128-NEXT:    popq %rax
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: call_first_arg:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    subq $56, %rsp
; CHECK-MSVC64-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MSVC64-F128-NEXT:    movaps %xmm0, 32(%rsp)
; CHECK-MSVC64-F128-NEXT:    leaq 32(%rsp), %rcx
; CHECK-MSVC64-F128-NEXT:    callq first_arg
; CHECK-MSVC64-F128-NEXT:    addq $56, %rsp
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: call_first_arg:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    subq $40, %rsp
; CHECK-MSVC64-I128-NEXT:    callq first_arg
; CHECK-MSVC64-I128-NEXT:    addq $40, %rsp
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: call_first_arg:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    subq $56, %rsp
; CHECK-MINGW-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MINGW-F128-NEXT:    movaps %xmm0, 32(%rsp)
; CHECK-MINGW-F128-NEXT:    leaq 32(%rsp), %rcx
; CHECK-MINGW-F128-NEXT:    callq first_arg
; CHECK-MINGW-F128-NEXT:    addq $56, %rsp
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: call_first_arg:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    subq $40, %rsp
; CHECK-MINGW-I128-NEXT:    callq first_arg
; CHECK-MINGW-I128-NEXT:    addq $40, %rsp
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: call_first_arg:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    subl $56, %esp
; CHECK-X86-NEXT:    movl 64(%esp), %eax
; CHECK-X86-NEXT:    movl 68(%esp), %ecx
; CHECK-X86-NEXT:    movl 72(%esp), %edx
; CHECK-X86-NEXT:    movl 76(%esp), %esi
; CHECK-X86-NEXT:    movl %esi, 28(%esp)
; CHECK-X86-NEXT:    movl %edx, 24(%esp)
; CHECK-X86-NEXT:    movl %ecx, 20(%esp)
; CHECK-X86-NEXT:    movl %eax, 16(%esp)
; CHECK-X86-NEXT:    leal 32(%esp), %eax
; CHECK-X86-NEXT:    movl %eax, (%esp)
; CHECK-X86-NEXT:    calll first_arg@PLT
; CHECK-X86-NEXT:    addl $52, %esp
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    retl
;
; CHECK-MSVC32-LABEL: call_first_arg:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %ebp
; CHECK-MSVC32-NEXT:    movl %esp, %ebp
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    andl $-16, %esp
; CHECK-MSVC32-NEXT:    subl $64, %esp
; CHECK-MSVC32-NEXT:    movl 8(%ebp), %eax
; CHECK-MSVC32-NEXT:    movl 12(%ebp), %ecx
; CHECK-MSVC32-NEXT:    movl 16(%ebp), %edx
; CHECK-MSVC32-NEXT:    movl 20(%ebp), %esi
; CHECK-MSVC32-NEXT:    movl %esi, 28(%esp)
; CHECK-MSVC32-NEXT:    movl %edx, 24(%esp)
; CHECK-MSVC32-NEXT:    movl %ecx, 20(%esp)
; CHECK-MSVC32-NEXT:    movl %eax, 16(%esp)
; CHECK-MSVC32-NEXT:    leal 32(%esp), %eax
; CHECK-MSVC32-NEXT:    movl %eax, (%esp)
; CHECK-MSVC32-NEXT:    calll _first_arg
; CHECK-MSVC32-NEXT:    leal -4(%ebp), %esp
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %ebp
; CHECK-MSVC32-NEXT:    retl
  call PrimTy @first_arg(PrimTy %x)
  ret void
}

define void @call_leading_args(PrimTy %x) nounwind {
; CHECK-X64-F128-LABEL: call_leading_args:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    pushq %rax
; CHECK-X64-F128-NEXT:    xorl %edi, %edi
; CHECK-X64-F128-NEXT:    xorl %esi, %esi
; CHECK-X64-F128-NEXT:    xorl %edx, %edx
; CHECK-X64-F128-NEXT:    xorl %ecx, %ecx
; CHECK-X64-F128-NEXT:    callq leading_args@PLT
; CHECK-X64-F128-NEXT:    popq %rax
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: call_leading_args:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    pushq %rax
; CHECK-X64-I128-NEXT:    movq %rsi, %r9
; CHECK-X64-I128-NEXT:    movq %rdi, %r8
; CHECK-X64-I128-NEXT:    xorl %edi, %edi
; CHECK-X64-I128-NEXT:    xorl %esi, %esi
; CHECK-X64-I128-NEXT:    xorl %edx, %edx
; CHECK-X64-I128-NEXT:    xorl %ecx, %ecx
; CHECK-X64-I128-NEXT:    callq leading_args@PLT
; CHECK-X64-I128-NEXT:    popq %rax
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: call_leading_args:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    subq $72, %rsp
; CHECK-MSVC64-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MSVC64-F128-NEXT:    movaps %xmm0, 48(%rsp)
; CHECK-MSVC64-F128-NEXT:    leaq 48(%rsp), %rax
; CHECK-MSVC64-F128-NEXT:    movq %rax, 32(%rsp)
; CHECK-MSVC64-F128-NEXT:    xorl %ecx, %ecx
; CHECK-MSVC64-F128-NEXT:    xorl %edx, %edx
; CHECK-MSVC64-F128-NEXT:    xorl %r8d, %r8d
; CHECK-MSVC64-F128-NEXT:    xorl %r9d, %r9d
; CHECK-MSVC64-F128-NEXT:    callq leading_args
; CHECK-MSVC64-F128-NEXT:    addq $72, %rsp
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: call_leading_args:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    subq $56, %rsp
; CHECK-MSVC64-I128-NEXT:    movq %rdx, 40(%rsp)
; CHECK-MSVC64-I128-NEXT:    movq %rcx, 32(%rsp)
; CHECK-MSVC64-I128-NEXT:    xorl %ecx, %ecx
; CHECK-MSVC64-I128-NEXT:    xorl %edx, %edx
; CHECK-MSVC64-I128-NEXT:    xorl %r8d, %r8d
; CHECK-MSVC64-I128-NEXT:    xorl %r9d, %r9d
; CHECK-MSVC64-I128-NEXT:    callq leading_args
; CHECK-MSVC64-I128-NEXT:    addq $56, %rsp
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: call_leading_args:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    subq $72, %rsp
; CHECK-MINGW-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MINGW-F128-NEXT:    movaps %xmm0, 48(%rsp)
; CHECK-MINGW-F128-NEXT:    leaq 48(%rsp), %rax
; CHECK-MINGW-F128-NEXT:    movq %rax, 32(%rsp)
; CHECK-MINGW-F128-NEXT:    xorl %ecx, %ecx
; CHECK-MINGW-F128-NEXT:    xorl %edx, %edx
; CHECK-MINGW-F128-NEXT:    xorl %r8d, %r8d
; CHECK-MINGW-F128-NEXT:    xorl %r9d, %r9d
; CHECK-MINGW-F128-NEXT:    callq leading_args
; CHECK-MINGW-F128-NEXT:    addq $72, %rsp
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: call_leading_args:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    subq $56, %rsp
; CHECK-MINGW-I128-NEXT:    movq %rdx, 40(%rsp)
; CHECK-MINGW-I128-NEXT:    movq %rcx, 32(%rsp)
; CHECK-MINGW-I128-NEXT:    xorl %ecx, %ecx
; CHECK-MINGW-I128-NEXT:    xorl %edx, %edx
; CHECK-MINGW-I128-NEXT:    xorl %r8d, %r8d
; CHECK-MINGW-I128-NEXT:    xorl %r9d, %r9d
; CHECK-MINGW-I128-NEXT:    callq leading_args
; CHECK-MINGW-I128-NEXT:    addq $56, %rsp
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: call_leading_args:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    subl $88, %esp
; CHECK-X86-NEXT:    movl 96(%esp), %eax
; CHECK-X86-NEXT:    movl 100(%esp), %ecx
; CHECK-X86-NEXT:    movl 104(%esp), %edx
; CHECK-X86-NEXT:    movl 108(%esp), %esi
; CHECK-X86-NEXT:    movl %esi, 60(%esp)
; CHECK-X86-NEXT:    movl %edx, 56(%esp)
; CHECK-X86-NEXT:    movl %ecx, 52(%esp)
; CHECK-X86-NEXT:    movl %eax, 48(%esp)
; CHECK-X86-NEXT:    leal 64(%esp), %eax
; CHECK-X86-NEXT:    movl %eax, (%esp)
; CHECK-X86-NEXT:    movl $0, 32(%esp)
; CHECK-X86-NEXT:    movl $0, 28(%esp)
; CHECK-X86-NEXT:    movl $0, 24(%esp)
; CHECK-X86-NEXT:    movl $0, 20(%esp)
; CHECK-X86-NEXT:    movl $0, 16(%esp)
; CHECK-X86-NEXT:    movl $0, 12(%esp)
; CHECK-X86-NEXT:    movl $0, 8(%esp)
; CHECK-X86-NEXT:    movl $0, 4(%esp)
; CHECK-X86-NEXT:    calll leading_args@PLT
; CHECK-X86-NEXT:    addl $84, %esp
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    retl
;
; CHECK-MSVC32-LABEL: call_leading_args:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %ebp
; CHECK-MSVC32-NEXT:    movl %esp, %ebp
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    andl $-16, %esp
; CHECK-MSVC32-NEXT:    subl $96, %esp
; CHECK-MSVC32-NEXT:    movl 8(%ebp), %eax
; CHECK-MSVC32-NEXT:    movl 12(%ebp), %ecx
; CHECK-MSVC32-NEXT:    movl 16(%ebp), %edx
; CHECK-MSVC32-NEXT:    movl 20(%ebp), %esi
; CHECK-MSVC32-NEXT:    movl %esi, 60(%esp)
; CHECK-MSVC32-NEXT:    movl %edx, 56(%esp)
; CHECK-MSVC32-NEXT:    movl %ecx, 52(%esp)
; CHECK-MSVC32-NEXT:    movl %eax, 48(%esp)
; CHECK-MSVC32-NEXT:    leal 64(%esp), %eax
; CHECK-MSVC32-NEXT:    movl %eax, (%esp)
; CHECK-MSVC32-NEXT:    movl $0, 32(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 28(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 24(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 20(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 16(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 12(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 8(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 4(%esp)
; CHECK-MSVC32-NEXT:    calll _leading_args
; CHECK-MSVC32-NEXT:    leal -4(%ebp), %esp
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %ebp
; CHECK-MSVC32-NEXT:    retl
  call PrimTy @leading_args(i64 0, i64 0, i64 0, i64 0, PrimTy %x)
  ret void
}

define void @call_many_leading_args(PrimTy %x) nounwind {
; CHECK-X64-F128-LABEL: call_many_leading_args:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    pushq %rax
; CHECK-X64-F128-NEXT:    movaps %xmm0, %xmm1
; CHECK-X64-F128-NEXT:    xorps %xmm0, %xmm0
; CHECK-X64-F128-NEXT:    xorl %edi, %edi
; CHECK-X64-F128-NEXT:    xorl %esi, %esi
; CHECK-X64-F128-NEXT:    xorl %edx, %edx
; CHECK-X64-F128-NEXT:    xorl %ecx, %ecx
; CHECK-X64-F128-NEXT:    callq many_leading_args@PLT
; CHECK-X64-F128-NEXT:    popq %rax
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: call_many_leading_args:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    pushq %rax
; CHECK-X64-I128-NEXT:    movq %rsi, %rax
; CHECK-X64-I128-NEXT:    movq %rdi, %r10
; CHECK-X64-I128-NEXT:    xorl %edi, %edi
; CHECK-X64-I128-NEXT:    xorl %esi, %esi
; CHECK-X64-I128-NEXT:    xorl %edx, %edx
; CHECK-X64-I128-NEXT:    xorl %ecx, %ecx
; CHECK-X64-I128-NEXT:    xorl %r8d, %r8d
; CHECK-X64-I128-NEXT:    xorl %r9d, %r9d
; CHECK-X64-I128-NEXT:    pushq %rax
; CHECK-X64-I128-NEXT:    pushq %r10
; CHECK-X64-I128-NEXT:    callq many_leading_args@PLT
; CHECK-X64-I128-NEXT:    addq $16, %rsp
; CHECK-X64-I128-NEXT:    popq %rax
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: call_many_leading_args:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    subq $88, %rsp
; CHECK-MSVC64-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MSVC64-F128-NEXT:    xorps %xmm1, %xmm1
; CHECK-MSVC64-F128-NEXT:    movaps %xmm1, 64(%rsp)
; CHECK-MSVC64-F128-NEXT:    movaps %xmm0, 48(%rsp)
; CHECK-MSVC64-F128-NEXT:    leaq 48(%rsp), %rax
; CHECK-MSVC64-F128-NEXT:    movq %rax, 40(%rsp)
; CHECK-MSVC64-F128-NEXT:    leaq 64(%rsp), %rax
; CHECK-MSVC64-F128-NEXT:    movq %rax, 32(%rsp)
; CHECK-MSVC64-F128-NEXT:    xorl %ecx, %ecx
; CHECK-MSVC64-F128-NEXT:    xorl %edx, %edx
; CHECK-MSVC64-F128-NEXT:    xorl %r8d, %r8d
; CHECK-MSVC64-F128-NEXT:    xorl %r9d, %r9d
; CHECK-MSVC64-F128-NEXT:    callq many_leading_args
; CHECK-MSVC64-F128-NEXT:    addq $88, %rsp
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: call_many_leading_args:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    subq $72, %rsp
; CHECK-MSVC64-I128-NEXT:    movq %rdx, 56(%rsp)
; CHECK-MSVC64-I128-NEXT:    movq %rcx, 48(%rsp)
; CHECK-MSVC64-I128-NEXT:    movq $0, 40(%rsp)
; CHECK-MSVC64-I128-NEXT:    movq $0, 32(%rsp)
; CHECK-MSVC64-I128-NEXT:    xorl %ecx, %ecx
; CHECK-MSVC64-I128-NEXT:    xorl %edx, %edx
; CHECK-MSVC64-I128-NEXT:    xorl %r8d, %r8d
; CHECK-MSVC64-I128-NEXT:    xorl %r9d, %r9d
; CHECK-MSVC64-I128-NEXT:    callq many_leading_args
; CHECK-MSVC64-I128-NEXT:    addq $72, %rsp
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: call_many_leading_args:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    subq $88, %rsp
; CHECK-MINGW-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MINGW-F128-NEXT:    xorps %xmm1, %xmm1
; CHECK-MINGW-F128-NEXT:    movaps %xmm1, 64(%rsp)
; CHECK-MINGW-F128-NEXT:    movaps %xmm0, 48(%rsp)
; CHECK-MINGW-F128-NEXT:    leaq 48(%rsp), %rax
; CHECK-MINGW-F128-NEXT:    movq %rax, 40(%rsp)
; CHECK-MINGW-F128-NEXT:    leaq 64(%rsp), %rax
; CHECK-MINGW-F128-NEXT:    movq %rax, 32(%rsp)
; CHECK-MINGW-F128-NEXT:    xorl %ecx, %ecx
; CHECK-MINGW-F128-NEXT:    xorl %edx, %edx
; CHECK-MINGW-F128-NEXT:    xorl %r8d, %r8d
; CHECK-MINGW-F128-NEXT:    xorl %r9d, %r9d
; CHECK-MINGW-F128-NEXT:    callq many_leading_args
; CHECK-MINGW-F128-NEXT:    addq $88, %rsp
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: call_many_leading_args:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    subq $72, %rsp
; CHECK-MINGW-I128-NEXT:    movq %rdx, 56(%rsp)
; CHECK-MINGW-I128-NEXT:    movq %rcx, 48(%rsp)
; CHECK-MINGW-I128-NEXT:    movq $0, 40(%rsp)
; CHECK-MINGW-I128-NEXT:    movq $0, 32(%rsp)
; CHECK-MINGW-I128-NEXT:    xorl %ecx, %ecx
; CHECK-MINGW-I128-NEXT:    xorl %edx, %edx
; CHECK-MINGW-I128-NEXT:    xorl %r8d, %r8d
; CHECK-MINGW-I128-NEXT:    xorl %r9d, %r9d
; CHECK-MINGW-I128-NEXT:    callq many_leading_args
; CHECK-MINGW-I128-NEXT:    addq $72, %rsp
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: call_many_leading_args:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    subl $104, %esp
; CHECK-X86-NEXT:    movl 112(%esp), %eax
; CHECK-X86-NEXT:    movl 116(%esp), %ecx
; CHECK-X86-NEXT:    movl 120(%esp), %edx
; CHECK-X86-NEXT:    movl 124(%esp), %esi
; CHECK-X86-NEXT:    movl %esi, 76(%esp)
; CHECK-X86-NEXT:    movl %edx, 72(%esp)
; CHECK-X86-NEXT:    movl %ecx, 68(%esp)
; CHECK-X86-NEXT:    movl %eax, 64(%esp)
; CHECK-X86-NEXT:    leal 80(%esp), %eax
; CHECK-X86-NEXT:    movl %eax, (%esp)
; CHECK-X86-NEXT:    movl $0, 60(%esp)
; CHECK-X86-NEXT:    movl $0, 56(%esp)
; CHECK-X86-NEXT:    movl $0, 52(%esp)
; CHECK-X86-NEXT:    movl $0, 48(%esp)
; CHECK-X86-NEXT:    movl $0, 32(%esp)
; CHECK-X86-NEXT:    movl $0, 28(%esp)
; CHECK-X86-NEXT:    movl $0, 24(%esp)
; CHECK-X86-NEXT:    movl $0, 20(%esp)
; CHECK-X86-NEXT:    movl $0, 16(%esp)
; CHECK-X86-NEXT:    movl $0, 12(%esp)
; CHECK-X86-NEXT:    movl $0, 8(%esp)
; CHECK-X86-NEXT:    movl $0, 4(%esp)
; CHECK-X86-NEXT:    calll many_leading_args@PLT
; CHECK-X86-NEXT:    addl $100, %esp
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    retl
;
; CHECK-MSVC32-LABEL: call_many_leading_args:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %ebp
; CHECK-MSVC32-NEXT:    movl %esp, %ebp
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    andl $-16, %esp
; CHECK-MSVC32-NEXT:    subl $112, %esp
; CHECK-MSVC32-NEXT:    movl 8(%ebp), %eax
; CHECK-MSVC32-NEXT:    movl 12(%ebp), %ecx
; CHECK-MSVC32-NEXT:    movl 16(%ebp), %edx
; CHECK-MSVC32-NEXT:    movl 20(%ebp), %esi
; CHECK-MSVC32-NEXT:    movl %esi, 76(%esp)
; CHECK-MSVC32-NEXT:    movl %edx, 72(%esp)
; CHECK-MSVC32-NEXT:    movl %ecx, 68(%esp)
; CHECK-MSVC32-NEXT:    movl %eax, 64(%esp)
; CHECK-MSVC32-NEXT:    leal 80(%esp), %eax
; CHECK-MSVC32-NEXT:    movl %eax, (%esp)
; CHECK-MSVC32-NEXT:    movl $0, 60(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 56(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 52(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 48(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 32(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 28(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 24(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 20(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 16(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 12(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 8(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 4(%esp)
; CHECK-MSVC32-NEXT:    calll _many_leading_args
; CHECK-MSVC32-NEXT:    leal -4(%ebp), %esp
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %ebp
; CHECK-MSVC32-NEXT:    retl
  call PrimTy @many_leading_args(i64 0, i64 0, i64 0, i64 0, PrimTy Prim0, PrimTy %x)
  ret void
}

define void @call_trailing_arg(PrimTy %x) nounwind {
; CHECK-X64-F128-LABEL: call_trailing_arg:
; CHECK-X64-F128:       # %bb.0:
; CHECK-X64-F128-NEXT:    pushq %rax
; CHECK-X64-F128-NEXT:    xorl %edi, %edi
; CHECK-X64-F128-NEXT:    xorl %esi, %esi
; CHECK-X64-F128-NEXT:    xorl %edx, %edx
; CHECK-X64-F128-NEXT:    xorl %ecx, %ecx
; CHECK-X64-F128-NEXT:    callq trailing_arg@PLT
; CHECK-X64-F128-NEXT:    popq %rax
; CHECK-X64-F128-NEXT:    retq
;
; CHECK-X64-I128-LABEL: call_trailing_arg:
; CHECK-X64-I128:       # %bb.0:
; CHECK-X64-I128-NEXT:    pushq %rax
; CHECK-X64-I128-NEXT:    movq %rsi, %r9
; CHECK-X64-I128-NEXT:    movq %rdi, %r8
; CHECK-X64-I128-NEXT:    xorl %edi, %edi
; CHECK-X64-I128-NEXT:    xorl %esi, %esi
; CHECK-X64-I128-NEXT:    xorl %edx, %edx
; CHECK-X64-I128-NEXT:    xorl %ecx, %ecx
; CHECK-X64-I128-NEXT:    callq trailing_arg@PLT
; CHECK-X64-I128-NEXT:    popq %rax
; CHECK-X64-I128-NEXT:    retq
;
; CHECK-MSVC64-F128-LABEL: call_trailing_arg:
; CHECK-MSVC64-F128:       # %bb.0:
; CHECK-MSVC64-F128-NEXT:    subq $72, %rsp
; CHECK-MSVC64-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MSVC64-F128-NEXT:    movaps %xmm0, 48(%rsp)
; CHECK-MSVC64-F128-NEXT:    leaq 48(%rsp), %rax
; CHECK-MSVC64-F128-NEXT:    movq %rax, 32(%rsp)
; CHECK-MSVC64-F128-NEXT:    xorl %ecx, %ecx
; CHECK-MSVC64-F128-NEXT:    xorl %edx, %edx
; CHECK-MSVC64-F128-NEXT:    xorl %r8d, %r8d
; CHECK-MSVC64-F128-NEXT:    xorl %r9d, %r9d
; CHECK-MSVC64-F128-NEXT:    callq trailing_arg
; CHECK-MSVC64-F128-NEXT:    addq $72, %rsp
; CHECK-MSVC64-F128-NEXT:    retq
;
; CHECK-MSVC64-I128-LABEL: call_trailing_arg:
; CHECK-MSVC64-I128:       # %bb.0:
; CHECK-MSVC64-I128-NEXT:    subq $56, %rsp
; CHECK-MSVC64-I128-NEXT:    movq %rdx, 40(%rsp)
; CHECK-MSVC64-I128-NEXT:    movq %rcx, 32(%rsp)
; CHECK-MSVC64-I128-NEXT:    xorl %ecx, %ecx
; CHECK-MSVC64-I128-NEXT:    xorl %edx, %edx
; CHECK-MSVC64-I128-NEXT:    xorl %r8d, %r8d
; CHECK-MSVC64-I128-NEXT:    xorl %r9d, %r9d
; CHECK-MSVC64-I128-NEXT:    callq trailing_arg
; CHECK-MSVC64-I128-NEXT:    addq $56, %rsp
; CHECK-MSVC64-I128-NEXT:    retq
;
; CHECK-MINGW-F128-LABEL: call_trailing_arg:
; CHECK-MINGW-F128:       # %bb.0:
; CHECK-MINGW-F128-NEXT:    subq $72, %rsp
; CHECK-MINGW-F128-NEXT:    movaps (%rcx), %xmm0
; CHECK-MINGW-F128-NEXT:    movaps %xmm0, 48(%rsp)
; CHECK-MINGW-F128-NEXT:    leaq 48(%rsp), %rax
; CHECK-MINGW-F128-NEXT:    movq %rax, 32(%rsp)
; CHECK-MINGW-F128-NEXT:    xorl %ecx, %ecx
; CHECK-MINGW-F128-NEXT:    xorl %edx, %edx
; CHECK-MINGW-F128-NEXT:    xorl %r8d, %r8d
; CHECK-MINGW-F128-NEXT:    xorl %r9d, %r9d
; CHECK-MINGW-F128-NEXT:    callq trailing_arg
; CHECK-MINGW-F128-NEXT:    addq $72, %rsp
; CHECK-MINGW-F128-NEXT:    retq
;
; CHECK-MINGW-I128-LABEL: call_trailing_arg:
; CHECK-MINGW-I128:       # %bb.0:
; CHECK-MINGW-I128-NEXT:    subq $56, %rsp
; CHECK-MINGW-I128-NEXT:    movq %rdx, 40(%rsp)
; CHECK-MINGW-I128-NEXT:    movq %rcx, 32(%rsp)
; CHECK-MINGW-I128-NEXT:    xorl %ecx, %ecx
; CHECK-MINGW-I128-NEXT:    xorl %edx, %edx
; CHECK-MINGW-I128-NEXT:    xorl %r8d, %r8d
; CHECK-MINGW-I128-NEXT:    xorl %r9d, %r9d
; CHECK-MINGW-I128-NEXT:    callq trailing_arg
; CHECK-MINGW-I128-NEXT:    addq $56, %rsp
; CHECK-MINGW-I128-NEXT:    retq
;
; CHECK-X86-LABEL: call_trailing_arg:
; CHECK-X86:       # %bb.0:
; CHECK-X86-NEXT:    pushl %esi
; CHECK-X86-NEXT:    subl $88, %esp
; CHECK-X86-NEXT:    movl 96(%esp), %eax
; CHECK-X86-NEXT:    movl 100(%esp), %ecx
; CHECK-X86-NEXT:    movl 104(%esp), %edx
; CHECK-X86-NEXT:    movl 108(%esp), %esi
; CHECK-X86-NEXT:    movl %esi, 60(%esp)
; CHECK-X86-NEXT:    movl %edx, 56(%esp)
; CHECK-X86-NEXT:    movl %ecx, 52(%esp)
; CHECK-X86-NEXT:    movl %eax, 48(%esp)
; CHECK-X86-NEXT:    leal 64(%esp), %eax
; CHECK-X86-NEXT:    movl %eax, (%esp)
; CHECK-X86-NEXT:    movl $0, 32(%esp)
; CHECK-X86-NEXT:    movl $0, 28(%esp)
; CHECK-X86-NEXT:    movl $0, 24(%esp)
; CHECK-X86-NEXT:    movl $0, 20(%esp)
; CHECK-X86-NEXT:    movl $0, 16(%esp)
; CHECK-X86-NEXT:    movl $0, 12(%esp)
; CHECK-X86-NEXT:    movl $0, 8(%esp)
; CHECK-X86-NEXT:    movl $0, 4(%esp)
; CHECK-X86-NEXT:    calll trailing_arg@PLT
; CHECK-X86-NEXT:    addl $84, %esp
; CHECK-X86-NEXT:    popl %esi
; CHECK-X86-NEXT:    retl
;
; CHECK-MSVC32-LABEL: call_trailing_arg:
; CHECK-MSVC32:       # %bb.0:
; CHECK-MSVC32-NEXT:    pushl %ebp
; CHECK-MSVC32-NEXT:    movl %esp, %ebp
; CHECK-MSVC32-NEXT:    pushl %esi
; CHECK-MSVC32-NEXT:    andl $-16, %esp
; CHECK-MSVC32-NEXT:    subl $96, %esp
; CHECK-MSVC32-NEXT:    movl 8(%ebp), %eax
; CHECK-MSVC32-NEXT:    movl 12(%ebp), %ecx
; CHECK-MSVC32-NEXT:    movl 16(%ebp), %edx
; CHECK-MSVC32-NEXT:    movl 20(%ebp), %esi
; CHECK-MSVC32-NEXT:    movl %esi, 60(%esp)
; CHECK-MSVC32-NEXT:    movl %edx, 56(%esp)
; CHECK-MSVC32-NEXT:    movl %ecx, 52(%esp)
; CHECK-MSVC32-NEXT:    movl %eax, 48(%esp)
; CHECK-MSVC32-NEXT:    leal 64(%esp), %eax
; CHECK-MSVC32-NEXT:    movl %eax, (%esp)
; CHECK-MSVC32-NEXT:    movl $0, 32(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 28(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 24(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 20(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 16(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 12(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 8(%esp)
; CHECK-MSVC32-NEXT:    movl $0, 4(%esp)
; CHECK-MSVC32-NEXT:    calll _trailing_arg
; CHECK-MSVC32-NEXT:    leal -4(%ebp), %esp
; CHECK-MSVC32-NEXT:    popl %esi
; CHECK-MSVC32-NEXT:    popl %ebp
; CHECK-MSVC32-NEXT:    retl
  call PrimTy @trailing_arg(i64 0, i64 0, i64 0, i64 0, PrimTy %x)
  ret void
}
