# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class ApplicationServerVirtualMachineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the type of application server VM."""

    ACTIVE = "Active"
    STANDBY = "Standby"
    UNKNOWN = "Unknown"


class CentralServerVirtualMachineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the type of central server VM."""

    PRIMARY = "Primary"
    SECONDARY = "Secondary"
    UNKNOWN = "Unknown"
    ASCS = "ASCS"
    ERS_INACTIVE = "ERSInactive"
    ERS = "ERS"
    STANDBY = "Standby"


class ConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of file share config."""

    SKIP = "Skip"
    CREATE_AND_MOUNT = "CreateAndMount"
    MOUNT = "Mount"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DiskSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the disk sku name."""

    STANDARD_LRS = "Standard_LRS"
    PREMIUM_LRS = "Premium_LRS"
    STANDARD_SSD_LRS = "StandardSSD_LRS"
    ULTRA_SSD_LRS = "UltraSSD_LRS"
    PREMIUM_ZRS = "Premium_ZRS"
    STANDARD_SSD_ZRS = "StandardSSD_ZRS"
    PREMIUM_V2_LRS = "PremiumV2_LRS"


class EnqueueReplicationServerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the type of Enqueue Replication Server."""

    ENQUEUE_REPLICATOR1 = "EnqueueReplicator1"
    ENQUEUE_REPLICATOR2 = "EnqueueReplicator2"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (only None, UserAssigned types are allowed)."""

    NONE = "None"
    USER_ASSIGNED = "UserAssigned"


class NamingPatternType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The pattern type to be used for resource naming."""

    FULL_RESOURCE_NAME = "FullResourceName"


class OperationProperties(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the workload operation origin."""

    NOT_SPECIFIED = "NotSpecified"
    USER = "User"
    SYSTEM = "System"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class OSType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The OS Type."""

    LINUX = "Linux"
    WINDOWS = "Windows"


class RoutingPreference(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to
    the customer VNET.
    """

    DEFAULT = "Default"
    ROUTE_ALL = "RouteAll"


class SAPConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The configuration Type."""

    DEPLOYMENT = "Deployment"
    DISCOVERY = "Discovery"
    DEPLOYMENT_WITH_OS_CONFIG = "DeploymentWithOSConfig"


class SAPDatabaseScaleMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The database scale method."""

    SCALE_UP = "ScaleUp"


class SAPDatabaseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the supported SAP Database types."""

    HANA = "HANA"
    DB2 = "DB2"


class SAPDeploymentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of SAP deployment, single server or Three tier."""

    SINGLE_SERVER = "SingleServer"
    THREE_TIER = "ThreeTier"


class SAPEnvironmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the environment type - Production/Non Production."""

    NON_PROD = "NonProd"
    PROD = "Prod"


class SAPHealthState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the health of SAP Instances."""

    UNKNOWN = "Unknown"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    DEGRADED = "Degraded"


class SAPHighAvailabilityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The high availability type (AvailabilitySet or AvailabilityZone)."""

    AVAILABILITY_SET = "AvailabilitySet"
    AVAILABILITY_ZONE = "AvailabilityZone"


class SapLandscapeMonitorProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of provisioning of the SAP monitor."""

    ACCEPTED = "Accepted"
    CREATED = "Created"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"


class SAPProductType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the SAP Product type."""

    ECC = "ECC"
    S4_HANA = "S4HANA"
    OTHER = "Other"


class SAPSoftwareInstallationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SAP software installation Type."""

    SERVICE_INITIATED = "ServiceInitiated"
    SAP_INSTALL_WITHOUT_OS_CONFIG = "SAPInstallWithoutOSConfig"
    EXTERNAL = "External"


class SapVirtualInstanceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the provisioning states."""

    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"
    CREATING = "Creating"
    FAILED = "Failed"
    DELETING = "Deleting"


class SAPVirtualInstanceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the Virtual Instance for SAP state."""

    INFRASTRUCTURE_DEPLOYMENT_PENDING = "InfrastructureDeploymentPending"
    INFRASTRUCTURE_DEPLOYMENT_IN_PROGRESS = "InfrastructureDeploymentInProgress"
    INFRASTRUCTURE_DEPLOYMENT_FAILED = "InfrastructureDeploymentFailed"
    SOFTWARE_INSTALLATION_PENDING = "SoftwareInstallationPending"
    SOFTWARE_INSTALLATION_IN_PROGRESS = "SoftwareInstallationInProgress"
    SOFTWARE_INSTALLATION_FAILED = "SoftwareInstallationFailed"
    SOFTWARE_DETECTION_IN_PROGRESS = "SoftwareDetectionInProgress"
    SOFTWARE_DETECTION_FAILED = "SoftwareDetectionFailed"
    DISCOVERY_PENDING = "DiscoveryPending"
    DISCOVERY_IN_PROGRESS = "DiscoveryInProgress"
    DISCOVERY_FAILED = "DiscoveryFailed"
    REGISTRATION_COMPLETE = "RegistrationComplete"


class SAPVirtualInstanceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the SAP Instance status."""

    STARTING = "Starting"
    RUNNING = "Running"
    STOPPING = "Stopping"
    OFFLINE = "Offline"
    PARTIALLY_RUNNING = "PartiallyRunning"
    UNAVAILABLE = "Unavailable"
    SOFT_SHUTDOWN = "SoftShutdown"


class SslPreference(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets certificate preference if secure communication is enabled."""

    DISABLED = "Disabled"
    ROOT_CERTIFICATE = "RootCertificate"
    SERVER_CERTIFICATE = "ServerCertificate"


class WorkloadMonitorActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the action type of workload operation."""

    NOT_SPECIFIED = "NotSpecified"
    INTERNAL = "Internal"


class WorkloadMonitorProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of provisioning of the SAP monitor."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    MIGRATING = "Migrating"
