# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.authorization import AuthorizationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAuthorizationManagementAlertConfigurationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AuthorizationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_alert_configurations_get(self, resource_group):
        response = self.client.alert_configurations.get(
            scope="str",
            alert_id="str",
            api_version="2022-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_alert_configurations_update(self, resource_group):
        response = self.client.alert_configurations.update(
            scope="str",
            alert_id="str",
            parameters={
                "alertDefinition": {
                    "description": "str",
                    "displayName": "str",
                    "howToPrevent": "str",
                    "id": "str",
                    "isConfigurable": bool,
                    "isRemediatable": bool,
                    "mitigationSteps": "str",
                    "name": "str",
                    "scope": "str",
                    "securityImpact": "str",
                    "severityLevel": "str",
                    "type": "str",
                },
                "alertDefinitionId": "str",
                "id": "str",
                "isEnabled": bool,
                "name": "str",
                "scope": "str",
                "type": "str",
            },
            api_version="2022-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_alert_configurations_list_for_scope(self, resource_group):
        response = self.client.alert_configurations.list_for_scope(
            scope="str",
            api_version="2022-08-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
