# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datamigration import DataMigrationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataMigrationManagementTasksOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataMigrationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_list(self, resource_group):
        response = self.client.tasks.list(
            group_name="str",
            service_name="str",
            project_name="str",
            api_version="2025-03-15-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_create_or_update(self, resource_group):
        response = self.client.tasks.create_or_update(
            group_name="str",
            service_name="str",
            project_name="str",
            task_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": "project_task_properties",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_get(self, resource_group):
        response = self.client.tasks.get(
            group_name="str",
            service_name="str",
            project_name="str",
            task_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_delete(self, resource_group):
        response = self.client.tasks.delete(
            group_name="str",
            service_name="str",
            project_name="str",
            task_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_update(self, resource_group):
        response = self.client.tasks.update(
            group_name="str",
            service_name="str",
            project_name="str",
            task_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": "project_task_properties",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_cancel(self, resource_group):
        response = self.client.tasks.cancel(
            group_name="str",
            service_name="str",
            project_name="str",
            task_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_command(self, resource_group):
        response = self.client.tasks.command(
            group_name="str",
            service_name="str",
            project_name="str",
            task_name="str",
            parameters={
                "commandType": "Migrate.SqlServer.AzureDbSqlMi.Complete",
                "errors": [{"code": "str", "details": [...], "message": "str"}],
                "input": {"sourceDatabaseName": "str"},
                "output": {
                    "errors": [
                        {
                            "actionableMessage": "str",
                            "filePath": "str",
                            "hResult": 0,
                            "lineNumber": "str",
                            "message": "str",
                            "stackTrace": "str",
                        }
                    ]
                },
                "state": "str",
            },
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...
