# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementTagOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_list_by_operation(self, resource_group):
        response = self.client.tag.list_by_operation(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            operation_id="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_get_entity_state_by_operation(self, resource_group):
        response = self.client.tag.get_entity_state_by_operation(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            operation_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_get_by_operation(self, resource_group):
        response = self.client.tag.get_by_operation(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            operation_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_assign_to_operation(self, resource_group):
        response = self.client.tag.assign_to_operation(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            operation_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_detach_from_operation(self, resource_group):
        response = self.client.tag.detach_from_operation(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            operation_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_list_by_api(self, resource_group):
        response = self.client.tag.list_by_api(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_get_entity_state_by_api(self, resource_group):
        response = self.client.tag.get_entity_state_by_api(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_get_by_api(self, resource_group):
        response = self.client.tag.get_by_api(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_assign_to_api(self, resource_group):
        response = self.client.tag.assign_to_api(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_detach_from_api(self, resource_group):
        response = self.client.tag.detach_from_api(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_list_by_product(self, resource_group):
        response = self.client.tag.list_by_product(
            resource_group_name=resource_group.name,
            service_name="str",
            product_id="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_get_entity_state_by_product(self, resource_group):
        response = self.client.tag.get_entity_state_by_product(
            resource_group_name=resource_group.name,
            service_name="str",
            product_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_get_by_product(self, resource_group):
        response = self.client.tag.get_by_product(
            resource_group_name=resource_group.name,
            service_name="str",
            product_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_assign_to_product(self, resource_group):
        response = self.client.tag.assign_to_product(
            resource_group_name=resource_group.name,
            service_name="str",
            product_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_detach_from_product(self, resource_group):
        response = self.client.tag.detach_from_product(
            resource_group_name=resource_group.name,
            service_name="str",
            product_id="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_list_by_service(self, resource_group):
        response = self.client.tag.list_by_service(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_get_entity_state(self, resource_group):
        response = self.client.tag.get_entity_state(
            resource_group_name=resource_group.name,
            service_name="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_get(self, resource_group):
        response = self.client.tag.get(
            resource_group_name=resource_group.name,
            service_name="str",
            tag_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_create_or_update(self, resource_group):
        response = self.client.tag.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            tag_id="str",
            parameters={"displayName": "str"},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_update(self, resource_group):
        response = self.client.tag.update(
            resource_group_name=resource_group.name,
            service_name="str",
            tag_id="str",
            if_match="str",
            parameters={"displayName": "str"},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tag_delete(self, resource_group):
        response = self.client.tag.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            tag_id="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
