# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservice import ContainerServiceClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceManagedClusterSnapshotsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.managed_cluster_snapshots.list(
            api_version="2022-02-02-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.managed_cluster_snapshots.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-02-02-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.managed_cluster_snapshots.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2022-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update(self, resource_group):
        response = self.client.managed_cluster_snapshots.create_or_update(
            resource_group_name=resource_group.name,
            resource_name="str",
            parameters={
                "location": "str",
                "creationData": {"sourceResourceId": "str"},
                "id": "str",
                "managedClusterPropertiesReadOnly": {
                    "enableRbac": bool,
                    "kubernetesVersion": "str",
                    "networkProfile": {
                        "loadBalancerSku": "str",
                        "networkMode": "str",
                        "networkPlugin": "kubenet",
                        "networkPolicy": "str",
                    },
                    "sku": {"name": "str", "tier": "str"},
                },
                "name": "str",
                "snapshotType": "NodePool",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2022-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update_tags(self, resource_group):
        response = self.client.managed_cluster_snapshots.update_tags(
            resource_group_name=resource_group.name,
            resource_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2022-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.managed_cluster_snapshots.delete(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2022-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...
