# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementVpnSitesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_vpn_sites_get(self, resource_group):
        response = self.client.vpn_sites.get(
            resource_group_name=resource_group.name,
            vpn_site_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_vpn_sites_begin_create_or_update(self, resource_group):
        response = self.client.vpn_sites.begin_create_or_update(
            resource_group_name=resource_group.name,
            vpn_site_name="str",
            vpn_site_parameters={
                "addressSpace": {
                    "addressPrefixes": ["str"],
                    "ipamPoolPrefixAllocations": [
                        {"allocatedAddressPrefixes": ["str"], "id": "str", "numberOfIpAddresses": "str"}
                    ],
                },
                "bgpProperties": {
                    "asn": 0,
                    "bgpPeeringAddress": "str",
                    "bgpPeeringAddresses": [
                        {
                            "customBgpIpAddresses": ["str"],
                            "defaultBgpIpAddresses": ["str"],
                            "ipconfigurationId": "str",
                            "tunnelIpAddresses": ["str"],
                        }
                    ],
                    "peerWeight": 0,
                },
                "deviceProperties": {"deviceModel": "str", "deviceVendor": "str", "linkSpeedInMbps": 0},
                "etag": "str",
                "id": "str",
                "ipAddress": "str",
                "isSecuritySite": bool,
                "location": "str",
                "name": "str",
                "o365Policy": {"breakOutCategories": {"allow": bool, "default": bool, "optimize": bool}},
                "provisioningState": "str",
                "siteKey": "str",
                "tags": {"str": "str"},
                "type": "str",
                "virtualWan": {"id": "str"},
                "vpnSiteLinks": [
                    {
                        "bgpProperties": {"asn": 0, "bgpPeeringAddress": "str"},
                        "etag": "str",
                        "fqdn": "str",
                        "id": "str",
                        "ipAddress": "str",
                        "linkProperties": {"linkProviderName": "str", "linkSpeedInMbps": 0},
                        "name": "str",
                        "provisioningState": "str",
                        "type": "str",
                    }
                ],
            },
            api_version="2024-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_vpn_sites_update_tags(self, resource_group):
        response = self.client.vpn_sites.update_tags(
            resource_group_name=resource_group.name,
            vpn_site_name="str",
            vpn_site_parameters={"tags": {"str": "str"}},
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_vpn_sites_begin_delete(self, resource_group):
        response = self.client.vpn_sites.begin_delete(
            resource_group_name=resource_group.name,
            vpn_site_name="str",
            api_version="2024-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_vpn_sites_list_by_resource_group(self, resource_group):
        response = self.client.vpn_sites.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_vpn_sites_list(self, resource_group):
        response = self.client.vpn_sites.list(
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
