# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.web import WebSiteManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWebSiteManagementSiteCertificatesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WebSiteManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_site_certificates_list(self, resource_group):
        response = self.client.site_certificates.list(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_site_certificates_get(self, resource_group):
        response = self.client.site_certificates.get(
            resource_group_name=resource_group.name,
            name="str",
            certificate_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_site_certificates_create_or_update(self, resource_group):
        response = self.client.site_certificates.create_or_update(
            resource_group_name=resource_group.name,
            name="str",
            certificate_name="str",
            certificate_envelope={
                "location": "str",
                "canonicalName": "str",
                "cerBlob": bytes("bytes", encoding="utf-8"),
                "domainValidationMethod": "str",
                "expirationDate": "2020-02-20 00:00:00",
                "friendlyName": "str",
                "hostNames": ["str"],
                "hostingEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "id": "str",
                "issueDate": "2020-02-20 00:00:00",
                "issuer": "str",
                "keyVaultId": "str",
                "keyVaultSecretName": "str",
                "keyVaultSecretStatus": "str",
                "kind": "str",
                "name": "str",
                "password": "str",
                "pfxBlob": bytes("bytes", encoding="utf-8"),
                "publicKeyHash": "str",
                "selfLink": "str",
                "serverFarmId": "str",
                "siteName": "str",
                "subjectName": "str",
                "tags": {"str": "str"},
                "thumbprint": "str",
                "type": "str",
                "valid": bool,
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_site_certificates_delete(self, resource_group):
        response = self.client.site_certificates.delete(
            resource_group_name=resource_group.name,
            name="str",
            certificate_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_site_certificates_update(self, resource_group):
        response = self.client.site_certificates.update(
            resource_group_name=resource_group.name,
            name="str",
            certificate_name="str",
            certificate_envelope={
                "canonicalName": "str",
                "cerBlob": bytes("bytes", encoding="utf-8"),
                "domainValidationMethod": "str",
                "expirationDate": "2020-02-20 00:00:00",
                "friendlyName": "str",
                "hostNames": ["str"],
                "hostingEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "id": "str",
                "issueDate": "2020-02-20 00:00:00",
                "issuer": "str",
                "keyVaultId": "str",
                "keyVaultSecretName": "str",
                "keyVaultSecretStatus": "str",
                "kind": "str",
                "name": "str",
                "password": "str",
                "pfxBlob": bytes("bytes", encoding="utf-8"),
                "publicKeyHash": "str",
                "selfLink": "str",
                "serverFarmId": "str",
                "siteName": "str",
                "subjectName": "str",
                "thumbprint": "str",
                "type": "str",
                "valid": bool,
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_site_certificates_list_slot(self, resource_group):
        response = self.client.site_certificates.list_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_site_certificates_get_slot(self, resource_group):
        response = self.client.site_certificates.get_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            certificate_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_site_certificates_create_or_update_slot(self, resource_group):
        response = self.client.site_certificates.create_or_update_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            certificate_name="str",
            certificate_envelope={
                "location": "str",
                "canonicalName": "str",
                "cerBlob": bytes("bytes", encoding="utf-8"),
                "domainValidationMethod": "str",
                "expirationDate": "2020-02-20 00:00:00",
                "friendlyName": "str",
                "hostNames": ["str"],
                "hostingEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "id": "str",
                "issueDate": "2020-02-20 00:00:00",
                "issuer": "str",
                "keyVaultId": "str",
                "keyVaultSecretName": "str",
                "keyVaultSecretStatus": "str",
                "kind": "str",
                "name": "str",
                "password": "str",
                "pfxBlob": bytes("bytes", encoding="utf-8"),
                "publicKeyHash": "str",
                "selfLink": "str",
                "serverFarmId": "str",
                "siteName": "str",
                "subjectName": "str",
                "tags": {"str": "str"},
                "thumbprint": "str",
                "type": "str",
                "valid": bool,
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_site_certificates_delete_slot(self, resource_group):
        response = self.client.site_certificates.delete_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            certificate_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_site_certificates_update_slot(self, resource_group):
        response = self.client.site_certificates.update_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            certificate_name="str",
            certificate_envelope={
                "canonicalName": "str",
                "cerBlob": bytes("bytes", encoding="utf-8"),
                "domainValidationMethod": "str",
                "expirationDate": "2020-02-20 00:00:00",
                "friendlyName": "str",
                "hostNames": ["str"],
                "hostingEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "id": "str",
                "issueDate": "2020-02-20 00:00:00",
                "issuer": "str",
                "keyVaultId": "str",
                "keyVaultSecretName": "str",
                "keyVaultSecretStatus": "str",
                "kind": "str",
                "name": "str",
                "password": "str",
                "pfxBlob": bytes("bytes", encoding="utf-8"),
                "publicKeyHash": "str",
                "selfLink": "str",
                "serverFarmId": "str",
                "siteName": "str",
                "subjectName": "str",
                "thumbprint": "str",
                "type": "str",
                "valid": bool,
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...
