/*
 * Copyright © 2017 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Alexandros Frantzis <alexandros.frantzis@canonical.com>
 */

#pragma once

#include "src/core/display_information.h"

#include <atomic>

namespace repowerd
{
namespace test
{

class FakeDisplayInformation : public DisplayInformation
{
public:
    FakeDisplayInformation();

    bool has_active_external_displays() override;

    void set_has_active_external_displays(bool b);

private:
    std::atomic<bool> has_active_external_displays_;
};

}
}
