/*
 * Copyright (C) 2010 mbelib Author
 * GPG Key ID: 0xEA5EFE2C (9E7A 5527 9CDC EBF7 BF1B  D772 4F98 E863 EA5E FE2C)
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _IMBE7200X4400_CONST_H
#define _IMBE7200X4400_CONST_H

/*
 * Quantizer step size for higher order DCT coefficients
 */
const float quantstep[11] = {
  1.2, 0.85, 0.65, 0.40, 0.28, 0.15, 0.08, 0.04, 0.02, 0.01
};

/*
 * Standard Dev. for higer order DCT coefficients
 */
const float standdev[9] = {
  0.307, 0.241, 0.207, 0.190, 0.179, 0.173, 0.165, 0.170, 0.170
};

/*
 *
 */
const float B2[64] = {
  -2.842205, -2.694235, -2.558260, -2.382850,
  -2.221042, -2.095574, -1.980845, -1.836058,
  -1.645556, -1.417658, -1.261301, -1.125631,
  -0.958207, -0.781591, -0.555837, -0.346976,
  -0.147249, 0.027755, 0.211495, 0.388380,
  0.552873, 0.737223, 0.932197, 1.139032,
  1.320955, 1.483433, 1.648297, 1.801447,
  1.942731, 2.118613, 2.321486, 2.504443,
  2.653909, 2.780654, 2.925355, 3.076390,
  3.220825, 3.402869, 3.585096, 3.784606,
  3.955521, 4.155636, 4.314009, 4.444150,
  4.577542, 4.735552, 4.909493, 5.085264,
  5.254767, 5.411894, 5.568094, 5.738523,
  5.919215, 6.087701, 6.280685, 6.464201,
  6.647736, 6.834672, 7.022583, 7.211777,
  7.471016, 7.738948, 8.124863, 8.695827
};

/*
 * bit allocation and step size for transformed gain vector
 */
const float ba[48][5][2] = {

  // L=9
  10, 0.003100, 9, 0.004020, 9, 0.003360, 9, 0.002900, 9, 0.002640,
  // L=10
  9, 0.006200, 9, 0.004020, 8, 0.006720, 8, 0.005800, 8, 0.005280,
  // L=11
  8, 0.012400, 8, 0.008040, 8, 0.006720, 7, 0.011600, 7, 0.010560,
  // L=12 
  8, 0.012400, 7, 0.016080, 7, 0.013440, 7, 0.011600, 7, 0.010560,
  // L=13
  7, 0.024800, 7, 0.016080, 7, 0.013440, 6, 0.021750, 6, 0.019800,
  // L=14
  7, 0.024800, 6, 0.030150, 6, 0.025200, 6, 0.021750, 6, 0.019800,
  // L=15
  7, 0.024800, 6, 0.030150, 6, 0.025200, 6, 0.021750, 5, 0.036960,
  // L=16
  6, 0.046500, 6, 0.030150, 6, 0.025200, 5, 0.040600, 5, 0.036960,
  // L=17
  6, 0.046500, 6, 0.030150, 5, 0.047040, 5, 0.040600, 5, 0.036960,
  // L=18
  6, 0.046500, 5, 0.056280, 5, 0.047040, 5, 0.040600, 5, 0.036960,
  // L=19
  6, 0.046500, 5, 0.056280, 5, 0.047040, 4, 0.058000, 4, 0.052800,
  // L=20
  6, 0.046500, 5, 0.056280, 5, 0.047040, 4, 0.058000, 4, 0.052800,
  // L=21
  5, 0.086800, 5, 0.056280, 5, 0.047040, 4, 0.058000, 4, 0.052800,
  // L=22
  5, 0.086800, 5, 0.056280, 4, 0.067200, 4, 0.058000, 4, 0.052800,
  // L=23
  5, 0.086800, 4, 0.080400, 4, 0.067200, 4, 0.068000, 4, 0.052800,
  // L=24
  5, 0.086800, 4, 0.080400, 4, 0.067200, 4, 0.058000, 4, 0.052800,
  // L=25
  5, 0.086800, 4, 0.080400, 4, 0.067200, 4, 0.058000, 3, 0.085800,
  // L=26
  5, 0.086800, 4, 0.080400, 4, 0.067200, 3, 0.094250, 3, 0.085800,
  // L=27
  5, 0.086800, 4, 0.080400, 4, 0.067200, 3, 0.094250, 3, 0.085800,
  // L=28
  4, 0.124000, 4, 0.080400, 4, 0.067200, 3, 0.094250, 3, 0.085800,
  // L=29
  4, 0.124000, 4, 0.080400, 4, 0.067200, 3, 0.094250, 3, 0.085800,
  // L=30
  4, 0.124000, 4, 0.080400, 4, 0.067200, 3, 0.094250, 3, 0.085800,
  // L=31
  4, 0.124000, 4, 0.080400, 3, 0.109200, 3, 0.094250, 3, 0.085800,
  // L=32
  4, 0.124000, 4, 0.080400, 3, 0.109200, 3, 0.094250, 3, 0.085800,
  // L=33
  4, 0.124000, 3, 0.130650, 3, 0.109200, 3, 0.094250, 3, 0.085800,
  // L=34
  4, 0.124000, 3, 0.130650, 3, 0.109200, 3, 0.094250, 3, 0.085800,
  // L=35
  4, 0.124000, 3, 0.130650, 3, 0.109200, 3, 0.094250, 3, 0.085800,
  // L=36
  4, 0.124000, 3, 0.130650, 3, 0.109200, 3, 0.094250, 3, 0.085800,
  // L=37
  4, 0.124000, 3, 0.130650, 3, 0.109200, 3, 0.094250, 2, 0.112200,
  // L=38
  4, 0.124000, 3, 0.130650, 3, 0.109200, 3, 0.094250, 2, 0.112200,
  // L=39
  4, 0.124000, 3, 0.130650, 3, 0.109200, 3, 0.094250, 2, 0.112200,
  // L=40
  4, 0.124000, 3, 0.130650, 3, 0.109200, 3, 0.094250, 2, 0.112200,
  // L=41
  4, 0.124000, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=42
  4, 0.124000, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=43
  4, 0.124000, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=44
  4, 0.124000, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=45
  4, 0.124000, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=46
  3, 0.201500, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=47
  3, 0.201500, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=48
  3, 0.201500, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=49
  3, 0.201500, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=50
  3, 0.201500, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=51
  3, 0.201500, 3, 0.130650, 3, 0.109200, 2, 0.123250, 2, 0.112200,
  // L=52
  3, 0.201500, 3, 0.130650, 2, 0.142800, 2, 0.123250, 2, 0.112200,
  // L=53
  3, 0.201500, 3, 0.130650, 2, 0.142800, 2, 0.123250, 2, 0.112200,
  // L=54
  3, 0.201500, 3, 0.130650, 2, 0.142800, 2, 0.123250, 2, 0.112200,
  // L=55
  3, 0.201500, 3, 0.130650, 2, 0.142800, 2, 0.123250, 2, 0.112200,
  // L=56
  3, 0.201500, 3, 0.130650, 2, 0.142800, 2, 0.123250, 2, 0.112200
};

/*
 * Bit allocation for higher Order DCT Coefficients
 */
const int hoba[48][50] = {
  // L=9
  {9, 8, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=10
  {9, 7, 6, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=11
  {9, 7, 6, 5, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=12
  {8, 7, 6, 5, 4, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=13
  {7, 7, 6, 5, 4, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=14
  {7, 7, 5, 4, 4, 3, 4, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=15
  {6, 7, 5, 4, 4, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=16
  {6, 6, 5, 4, 4, 3, 3, 3, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=17
  {5, 5, 5, 4, 4, 4, 3, 3, 2, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=18
  {5, 4, 5, 5, 4, 3, 3, 3, 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=19
  {5, 4, 5, 4, 4, 3, 3, 3, 3, 2, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=20
  {5, 4, 5, 4, 4, 3, 3, 2, 3, 2, 1, 3, 2, 1, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=21
  {4, 4, 5, 4, 4, 3, 3, 2, 2, 3, 2, 1, 3, 2, 1, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=22
  {4, 4, 4, 4, 4, 3, 2, 3, 2, 2, 3, 2, 1, 2, 2, 1, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=23
  {4, 3, 4, 4, 3, 4, 3, 2, 3, 2, 2, 2, 2, 1, 2, 2, 1, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=24
  {4, 3, 3, 4, 3, 3, 3, 3, 2, 3, 2, 1, 2, 2, 1, 2, 2, 1, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=25
  {4, 3, 3, 4, 3, 3, 3, 3, 2, 3, 2, 1, 2, 2, 1, 2, 1, 1, 1, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=26
  {4, 3, 3, 4, 3, 3, 3, 2, 2, 3, 2, 1, 2, 2, 1, 1, 2, 2, 1, 1,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=27
  {4, 3, 2, 4, 3, 2, 3, 2, 2, 3, 2, 2, 1, 2, 2, 1, 1, 2, 2, 1,
   1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=28
  {4, 3, 2, 4, 3, 2, 3, 2, 2, 2, 3, 2, 1, 1, 2, 2, 1, 1, 2, 1,
   1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=29
  {3, 3, 2, 4, 3, 2, 2, 3, 2, 2, 2, 3, 2, 1, 1, 2, 1, 1, 1, 2,
   1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=30
  {3, 3, 2, 2, 3, 3, 2, 2, 3, 2, 2, 1, 3, 2, 1, 1, 2, 1, 1, 1,
   2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=31
  {3, 3, 2, 2, 3, 3, 2, 2, 3, 2, 2, 1, 2, 2, 1, 1, 2, 1, 1, 1,
   2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=32
  {3, 3, 2, 2, 3, 3, 2, 2, 3, 2, 2, 1, 2, 2, 1, 1, 2, 1, 1, 1,
   1, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=33
  {3, 3, 2, 2, 3, 3, 2, 2, 3, 2, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1,
   1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=34
  {3, 2, 2, 2, 3, 2, 2, 2, 3, 2, 2, 1, 1, 2, 2, 1, 1, 1, 2, 1,
   1, 1, 1, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=35
  {3, 2, 2, 2, 3, 2, 2, 2, 2, 3, 2, 1, 1, 1, 2, 2, 1, 1, 1, 2,
   1, 1, 1, 0, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=36
  {3, 2, 2, 2, 1, 3, 2, 2, 2, 1, 3, 2, 1, 1, 1, 2, 2, 1, 1, 1,
   2, 1, 1, 1, 0, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=37
  {3, 2, 2, 2, 1, 3, 2, 2, 2, 2, 3, 2, 1, 1, 1, 2, 1, 1, 1, 1,
   2, 1, 1, 1, 0, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=38
  {3, 2, 2, 2, 1, 3, 2, 2, 2, 1, 3, 2, 1, 1, 1, 2, 1, 1, 1, 1,
   2, 1, 1, 1, 1, 0, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=39
  {3, 2, 2, 2, 1, 3, 2, 2, 2, 1, 3, 2, 1, 1, 1, 2, 2, 1, 1, 1,
   0, 2, 1, 1, 1, 1, 0, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=40
  {3, 2, 2, 2, 1, 3, 2, 2, 1, 1, 3, 2, 1, 1, 1, 1, 2, 2, 1, 1,
   1, 0, 2, 1, 1, 1, 1, 0, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=41
  {3, 2, 2, 1, 1, 3, 2, 2, 2, 1, 1, 3, 2, 1, 1, 1, 1, 2, 2, 1,
   1, 1, 0, 2, 1, 1, 1, 1, 0, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=42
  {3, 2, 2, 2, 1, 1, 3, 2, 2, 2, 1, 1, 2, 2, 1, 1, 1, 1, 2, 2,
   1, 1, 1, 0, 2, 1, 1, 1, 0, 0, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=43
  {3, 2, 2, 2, 1, 1, 3, 2, 2, 2, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1,
   1, 1, 1, 0, 2, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=44
  {3, 2, 2, 1, 1, 1, 3, 2, 2, 2, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1,
   1, 1, 1, 0, 2, 1, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=45
  {3, 2, 2, 1, 1, 1, 3, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 2,
   1, 1, 1, 0, 0, 2, 1, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=46
  {3, 2, 2, 1, 1, 1, 3, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2,
   2, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=47
  {3, 2, 2, 1, 1, 1, 3, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1,
   2, 2, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1, 0, 0, 2, 1, 1, 1, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=48
  {3, 2, 2, 1, 1, 1, 1, 3, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1,
   1, 2, 2, 1, 1, 1, 0, 0, 2, 1, 1, 1, 0, 0, 0, 2, 1, 1, 1, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=49
  {3, 2, 2, 1, 1, 1, 1, 3, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1,
   0, 2, 2, 1, 1, 1, 0, 0, 2, 1, 1, 1, 0, 0, 0, 2, 1, 1, 1, 1,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=50
  {3, 2, 2, 1, 1, 1, 1, 3, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1,
   0, 2, 2, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1, 0, 0, 0, 2, 1, 1, 1,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=51
  {3, 2, 2, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1,
   0, 2, 2, 1, 1, 1, 0, 0, 0, 2, 1, 1, 1, 1, 0, 0, 0, 2, 1, 1,
   1, 1, 0, 0, 0, 0, 0, 0, 0, 0},
  // L=52
  {3, 2, 1, 1, 1, 1, 1, 3, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1,
   1, 0, 2, 2, 1, 1, 1, 0, 0, 0, 2, 1, 1, 1, 1, 0, 0, 0, 2, 1,
   1, 1, 1, 0, 0, 0, 0, 0, 0, 0},
  // L=53
  {3, 2, 1, 1, 1, 1, 1, 3, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1,
   1, 1, 0, 2, 2, 1, 1, 1, 0, 0, 0, 2, 1, 1, 1, 1, 0, 0, 0, 2,
   1, 1, 1, 0, 0, 0, 0, 0, 0, 0},
  // L=54
  {3, 2, 2, 1, 1, 1, 1, 0, 3, 2, 2, 1, 1, 1, 1, 0, 2, 2, 1, 1,
   1, 1, 1, 0, 2, 2, 1, 1, 1, 0, 0, 0, 2, 1, 1, 1, 1, 0, 0, 0,
   2, 1, 1, 1, 0, 0, 0, 0, 0, 0},
  // L=55
  {3, 2, 2, 1, 1, 1, 1, 0, 3, 2, 2, 1, 1, 1, 1, 0, 2, 2, 1, 1,
   1, 1, 1, 0, 2, 2, 1, 1, 1, 0, 0, 0, 2, 1, 1, 1, 0, 0, 0, 0,
   2, 1, 1, 1, 1, 0, 0, 0, 0, 0},
  // L=56
  {3, 2, 2, 1, 1, 1, 1, 0, 3, 2, 2, 1, 1, 1, 1, 0, 2, 2, 1, 1,
   1, 1, 1, 0, 2, 2, 1, 1, 1, 0, 0, 0, 2, 1, 1, 1, 1, 0, 0, 0,
   0, 2, 1, 1, 1, 0, 0, 0, 0, 0}
};


/*
 * bit order for reading data out of imbe data
 */

  // L=9
const int bo[48][79][2] = { 2, 5, 2, 4, 2, 3, 3, 9, 3, 8, 4, 8,
  5, 8, 6, 8, 7, 8, 8, 8, 3, 7, 4, 7, 5, 7, 6, 7, 7, 7, 8, 7, 9, 7, 3, 6,
  4, 6, 5, 6, 6, 6, 7, 6, 8, 6, 9, 6, 10, 6, 3, 5, 4, 5, 5, 5, 6, 5, 7, 5,
  8, 5, 9, 5, 10, 5, 3, 4, 4, 4, 5, 4, 6, 4, 7, 4, 8, 4, 9, 4, 10, 4, 3, 3,
  1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 4, 3, 5, 3, 6, 3, 7, 3, 8, 3, 9, 3,
  10, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2, 3, 1, 4, 1,
  5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0,
  8, 0, 9, 0, 10, 0, 2, 0,

  // L=10
  2, 5, 2, 4, 2, 3, 3, 8, 4, 8, 8, 8,
  3, 7, 4, 7, 5, 7, 6, 7, 7, 7, 8, 7, 3, 6, 4, 6, 5, 6, 6, 6, 7, 6, 8, 6,
  9, 6, 3, 5, 4, 5, 5, 5, 6, 5, 7, 5, 8, 5, 9, 5, 10, 5, 3, 4, 4, 4, 5, 4,
  6, 4, 7, 4, 8, 4, 9, 4, 10, 4, 11, 4, 3, 3, 4, 3, 5, 3, 6, 3, 7, 3, 8, 3,
  1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 9, 3, 10, 3, 11, 3, 3, 2, 4, 2,
  5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2, 11, 2, 3, 1, 4, 1, 5, 1, 6, 1,
  7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0,
  9, 0, 10, 0, 11, 0, 2, 0,

  // L=11
  2, 5, 2, 4, 2, 3, 8, 8, 3, 7, 4, 7,
  5, 7, 8, 7, 3, 6, 4, 6, 5, 6, 6, 6, 7, 6, 8, 6, 9, 6, 3, 5, 4, 5, 5, 5,
  6, 5, 7, 5, 8, 5, 9, 5, 10, 5, 3, 4, 4, 4, 5, 4, 6, 4, 7, 4, 8, 4, 9, 4,
  10, 4, 11, 4, 3, 3, 4, 3, 5, 3, 6, 3, 7, 3, 8, 3, 9, 3, 10, 3, 11, 3, 12, 3,
  1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2,
  8, 2, 9, 2, 10, 2, 11, 2, 12, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1,
  9, 1, 10, 1, 11, 1, 12, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0,
  10, 0, 11, 0, 12, 0, 2, 0,

  // L=12
  2, 5, 2, 4, 2, 3, 3, 7, 8, 7, 3, 6,
  4, 6, 5, 6, 6, 6, 7, 6, 8, 6, 9, 6, 3, 5, 4, 5, 5, 5, 6, 5, 7, 5, 8, 5,
  9, 5, 10, 5, 3, 4, 4, 4, 5, 4, 6, 4, 7, 4, 8, 4, 9, 4, 10, 4, 11, 4, 3, 3,
  4, 3, 5, 3, 6, 3, 7, 3, 8, 3, 9, 3, 10, 3, 11, 3, 12, 3, 3, 2, 4, 2, 5, 2,
  1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2,
  11, 2, 12, 2, 13, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1,
  11, 1, 12, 1, 13, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0,
  11, 0, 12, 0, 13, 0, 2, 0,

  // L=13
  2, 5, 2, 4, 2, 3, 3, 6, 4, 6, 5, 6,
  8, 6, 9, 6, 3, 5, 4, 5, 5, 5, 6, 5, 7, 5, 8, 5, 9, 5, 10, 5, 3, 4, 4, 4,
  5, 4, 6, 4, 7, 4, 8, 4, 9, 4, 10, 4, 11, 4, 3, 3, 4, 3, 5, 3, 6, 3, 7, 3,
  8, 3, 9, 3, 10, 3, 11, 3, 12, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2,
  1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 10, 2, 11, 2, 12, 2, 13, 2,
  14, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1,
  13, 1, 14, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0,
  12, 0, 13, 0, 14, 0, 2, 0,

  // L=14
  2, 5, 2, 4, 2, 3, 3, 6, 8, 6, 9, 6,
  3, 5, 4, 5, 5, 5, 6, 5, 7, 5, 8, 5, 9, 5, 3, 4, 4, 4, 5, 4, 6, 4, 7, 4,
  8, 4, 9, 4, 10, 4, 3, 3, 4, 3, 5, 3, 6, 3, 7, 3, 8, 3, 9, 3, 10, 3, 11, 3,
  12, 3, 14, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2, 11, 2, 12, 2,
  1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 13, 2, 14, 2, 15, 2, 3, 1,
  4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1,
  15, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0,
  13, 0, 14, 0, 15, 0, 2, 0,

  // L=15
  2, 5, 2, 4, 2, 3, 3, 6, 9, 6, 3, 5,
  4, 5, 5, 5, 6, 5, 8, 5, 9, 5, 3, 4, 4, 4, 5, 4, 6, 4, 7, 4, 8, 4, 9, 4,
  10, 4, 3, 3, 4, 3, 5, 3, 6, 3, 7, 3, 8, 3, 9, 3, 10, 3, 11, 3, 12, 3, 3, 2,
  4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2, 11, 2, 12, 2, 13, 2, 14, 2, 15, 2,
  1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 16, 2, 3, 1, 4, 1, 5, 1,
  6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1,
  3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0,
  14, 0, 15, 0, 16, 0, 2, 0,

  // L=16
  2, 5, 2, 4, 2, 3, 3, 5, 4, 5, 5, 5,
  8, 5, 9, 5, 3, 4, 4, 4, 5, 4, 6, 4, 7, 4, 8, 4, 9, 4, 10, 4, 3, 3, 4, 3,
  5, 3, 6, 3, 7, 3, 8, 3, 9, 3, 10, 3, 11, 3, 12, 3, 3, 2, 4, 2, 5, 2, 6, 2,
  7, 2, 8, 2, 9, 2, 10, 2, 11, 2, 12, 2, 13, 2, 14, 2, 15, 2, 16, 2, 3, 1, 4, 1,
  1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 5, 1, 6, 1, 7, 1,
  8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 3, 0,
  4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0,
  15, 0, 16, 0, 17, 0, 2, 0,

  // L=17
  2, 5, 2, 4, 2, 3, 3, 5, 4, 5, 3, 4,
  4, 4, 5, 4, 6, 4, 7, 4, 8, 4, 9, 4, 10, 4, 3, 3, 4, 3, 5, 3, 6, 3, 7, 3,
  8, 3, 9, 3, 10, 3, 11, 3, 12, 3, 13, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2,
  9, 2, 10, 2, 11, 2, 12, 2, 13, 2, 14, 2, 15, 2, 17, 2, 3, 1, 4, 1, 5, 1, 6, 1,
  1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 7, 1, 8, 1, 9, 1,
  10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 3, 0, 4, 0,
  5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0,
  16, 0, 17, 0, 18, 0, 2, 0,

  // L=18
  2, 5, 2, 4, 2, 3, 3, 5, 3, 4, 4, 4,
  5, 4, 6, 4, 7, 4, 8, 4, 10, 4, 11, 4, 3, 3, 4, 3, 5, 3, 6, 3, 7, 3, 8, 3,
  9, 3, 10, 3, 11, 3, 12, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2,
  11, 2, 12, 2, 13, 2, 14, 2, 15, 2, 16, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1,
  1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 9, 1, 10, 1, 11, 1,
  12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 19, 1, 3, 0, 4, 0, 5, 0,
  6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0,
  17, 0, 18, 0, 19, 0, 2, 0,

  // L=19
  2, 5, 2, 4, 2, 3, 3, 5, 3, 4, 4, 4,
  5, 4, 8, 4, 10, 4, 3, 3, 4, 3, 5, 3, 6, 3, 7, 3, 8, 3, 9, 3, 10, 3, 11, 3,
  12, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2, 11, 2, 12, 2, 13, 2,
  14, 2, 15, 2, 16, 2, 18, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1,
  1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 11, 1, 12, 1,
  13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 19, 1, 3, 0, 4, 0, 5, 0, 6, 0,
  7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0,
  18, 0, 19, 0, 20, 0, 2, 0,

  // L=20
  2, 5, 2, 4, 2, 3, 3, 5, 3, 4, 4, 4,
  5, 4, 8, 4, 10, 4, 3, 3, 4, 3, 5, 3, 6, 3, 7, 3, 8, 3, 9, 3, 10, 3, 11, 3,
  12, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2, 11, 2, 12, 2, 13, 2,
  14, 2, 16, 2, 19, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1,
  1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 12, 1, 13, 1,
  14, 1, 15, 1, 16, 1, 17, 1, 19, 1, 20, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0,
  8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0,
  19, 0, 20, 0, 21, 0, 2, 0,

  // L=21
  2, 5, 2, 4, 2, 3, 3, 4, 4, 4, 5, 4,
  10, 4, 3, 3, 4, 3, 5, 3, 6, 3, 7, 3, 8, 3, 9, 3, 10, 3, 11, 3, 12, 3, 3, 2,
  4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2, 11, 2, 12, 2, 13, 2, 14, 2, 17, 2,
  20, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1,
  1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 14, 1, 15, 1,
  16, 1, 17, 1, 18, 1, 20, 1, 21, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0,
  9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0,
  20, 0, 21, 0, 22, 0, 2, 0,

  // L=22
  2, 5, 2, 4, 2, 3, 3, 4, 4, 4, 3, 3,
  4, 3, 5, 3, 6, 3, 7, 3, 8, 3, 9, 3, 10, 3, 11, 3, 12, 3, 3, 2, 4, 2, 5, 2,
  6, 2, 7, 2, 8, 2, 9, 2, 10, 2, 11, 2, 12, 2, 13, 2, 15, 2, 18, 2, 3, 1, 4, 1,
  5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1,
  1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 17, 1,
  18, 1, 19, 1, 21, 1, 22, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0,
  10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0,
  21, 0, 22, 0, 23, 0, 2, 0,

  // L=23
  2, 5, 2, 4, 2, 3, 3, 4, 3, 3, 4, 3,
  5, 3, 6, 3, 7, 3, 8, 3, 10, 3, 11, 3, 13, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2,
  8, 2, 9, 2, 10, 2, 11, 2, 12, 2, 13, 2, 14, 2, 16, 2, 3, 1, 4, 1, 5, 1, 6, 1,
  7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1,
  1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 19, 1,
  20, 1, 22, 1, 23, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0,
  11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0,
  22, 0, 23, 0, 24, 0, 2, 0,

  // L=24
  2, 5, 2, 4, 2, 3, 3, 4, 3, 3, 4, 3,
  5, 3, 6, 3, 7, 3, 8, 3, 11, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2,
  10, 2, 11, 2, 12, 2, 13, 2, 14, 2, 15, 2, 17, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1,
  8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 20, 1,
  1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1, 21, 1,
  23, 1, 24, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0,
  12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0,
  23, 0, 24, 0, 25, 0, 2, 0,

  // L=25
  2, 5, 2, 4, 2, 3, 3, 4, 3, 3, 4, 3,
  5, 3, 6, 3, 8, 3, 11, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2,
  11, 2, 12, 2, 13, 2, 14, 2, 15, 2, 17, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1,
  9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 20, 1, 21, 1,
  1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1,
  23, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0,
  13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0,
  24, 0, 25, 0, 26, 0, 2, 0,

  // L=26
  2, 5, 2, 4, 2, 3, 3, 4, 3, 3, 4, 3,
  5, 3, 8, 3, 11, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 10, 2, 11, 2,
  12, 2, 13, 2, 14, 2, 17, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1,
  11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 20, 1, 21, 1, 24, 1, 25, 1,
  1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1,
  3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0,
  14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0,
  25, 0, 26, 0, 27, 0, 2, 0,

  // L=27
  2, 5, 2, 4, 2, 3, 3, 4, 3, 3, 4, 3,
  5, 3, 8, 3, 11, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 11, 2, 12, 2,
  14, 2, 17, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1,
  13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 19, 1, 21, 1, 22, 1, 25, 1, 26, 1, 3, 0,
  1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2, 2, 1,
  4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0,
  15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0,
  26, 0, 27, 0, 28, 0, 2, 0,

  // L=28
  2, 5, 2, 4, 2, 3, 3, 3, 4, 3, 5, 3,
  8, 3, 11, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 11, 2, 12, 2, 14, 2,
  18, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1,
  14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 19, 1, 22, 1, 23, 1, 26, 1, 3, 0, 4, 0, 5, 0,
  1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2,
  2, 1, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0,
  16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0,
  27, 0, 28, 0, 29, 0, 2, 0,

  // L=29
  2, 5, 2, 4, 2, 3, 3, 3, 4, 3, 5, 3,
  11, 3, 3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 11, 2, 12, 2, 15, 2, 19, 2,
  3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1,
  15, 1, 16, 1, 17, 1, 18, 1, 19, 1, 20, 1, 23, 1, 27, 1, 3, 0, 4, 0, 5, 0, 6, 0,
  1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2,
  2, 1, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0,
  17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0,
  28, 0, 29, 0, 30, 0, 2, 0,

  // L=30
  2, 5, 2, 4, 2, 3, 3, 3, 4, 3, 5, 3,
  3, 2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 12, 2, 13, 2, 16, 2, 20, 2, 3, 1,
  4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1,
  16, 1, 17, 1, 18, 1, 20, 1, 21, 1, 24, 1, 28, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0,
  1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0, 2, 2,
  2, 1, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0,
  18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0,
  29, 0, 30, 0, 31, 0, 2, 0,

  // L=31
  2, 5, 2, 4, 2, 3, 3, 3, 4, 3, 3, 2,
  4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 12, 2, 13, 2, 16, 2, 3, 1, 4, 1, 5, 1,
  6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1,
  18, 1, 20, 1, 21, 1, 24, 1, 28, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0,
  1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0,
  2, 2, 2, 1, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0,
  19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0,
  30, 0, 31, 0, 32, 0, 2, 0,

  // L=32
  2, 5, 2, 4, 2, 3, 3, 3, 4, 3, 3, 2,
  4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 12, 2, 13, 2, 16, 2, 3, 1, 4, 1, 5, 1,
  6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1,
  18, 1, 20, 1, 21, 1, 24, 1, 29, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0,
  1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0,
  2, 2, 2, 1, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0,
  19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0,
  30, 0, 31, 0, 32, 0, 2, 0,

  // L=33
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 6, 2, 7, 2, 8, 2, 9, 2, 12, 2, 13, 2, 16, 2, 3, 1, 4, 1, 5, 1, 6, 1,
  7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 20, 1,
  21, 1, 25, 1, 30, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0,
  1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1, 1, 0,
  2, 2, 2, 1, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0,
  21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0, 31, 0,
  32, 0, 33, 0, 34, 0, 2, 0,

  // L=34
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 6, 2, 7, 2, 8, 2, 12, 2, 16, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1,
  9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 21, 1, 22, 1,
  26, 1, 31, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0,
  21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0, 31, 0,
  32, 0, 33, 0, 34, 0, 2, 0,

  // L=35
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 6, 2, 7, 2, 8, 2, 12, 2, 17, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1,
  9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 22, 1, 23, 1,
  27, 1, 32, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0,
  21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0, 32, 0,
  33, 0, 34, 0, 35, 0, 2, 0,

  // L=36
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 6, 2, 7, 2, 8, 2, 13, 2, 18, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1,
  9, 1, 10, 1, 11, 1, 13, 1, 14, 1, 15, 1, 16, 1, 18, 1, 19, 1, 23, 1, 24, 1, 28, 1,
  33, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0,
  22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0, 31, 0, 33, 0,
  34, 0, 35, 0, 36, 0, 2, 0,

  // L=37
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 6, 2, 8, 2, 13, 2, 18, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1,
  10, 1, 11, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 19, 1, 23, 1, 28, 1, 33, 1,
  3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0,
  23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0, 31, 0, 33, 0, 34, 0,
  35, 0, 36, 0, 37, 0, 2, 0,

  // L=38
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 6, 2, 8, 2, 13, 2, 18, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1,
  10, 1, 11, 1, 13, 1, 14, 1, 15, 1, 16, 1, 18, 1, 19, 1, 23, 1, 28, 1, 34, 1, 3, 0,
  4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0,
  24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0, 31, 0, 32, 0, 34, 0, 35, 0,
  36, 0, 37, 0, 38, 0, 2, 0,

  // L=39
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 6, 2, 8, 2, 13, 2, 18, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1,
  10, 1, 11, 1, 13, 1, 14, 1, 15, 1, 16, 1, 18, 1, 19, 1, 23, 1, 24, 1, 29, 1, 35, 1,
  3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0,
  23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 29, 0, 30, 0, 31, 0, 32, 0, 33, 0, 35, 0,
  36, 0, 37, 0, 38, 0, 2, 0,

  // L=40
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 6, 2, 8, 2, 13, 2, 18, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1,
  10, 1, 11, 1, 13, 1, 14, 1, 15, 1, 18, 1, 19, 1, 24, 1, 25, 1, 30, 1, 36, 1, 3, 0,
  4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0,
  24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 30, 0, 31, 0, 32, 0, 33, 0, 34, 0, 36, 0,
  37, 0, 38, 0, 39, 0, 2, 0,

  // L=41
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 8, 2, 13, 2, 19, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1,
  13, 1, 14, 1, 15, 1, 16, 1, 19, 1, 20, 1, 25, 1, 26, 1, 31, 1, 37, 1, 3, 0, 4, 0,
  5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0,
  25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 31, 0, 32, 0, 33, 0, 34, 0, 35, 0, 37, 0,
  38, 0, 39, 0, 40, 0, 2, 0,

  // L=42
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 8, 2, 14, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1,
  14, 1, 15, 1, 16, 1, 17, 1, 20, 1, 21, 1, 26, 1, 27, 1, 32, 1, 38, 1, 3, 0, 4, 0,
  5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0,
  25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0, 32, 0, 33, 0, 34, 0, 35, 0, 38, 0,
  39, 0, 40, 0, 41, 0, 2, 0,

  // L=43 
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 8, 2, 14, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1,
  14, 1, 15, 1, 16, 1, 17, 1, 20, 1, 21, 1, 26, 1, 32, 1, 38, 1, 3, 0, 4, 0, 5, 0,
  6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0,
  26, 0, 27, 0, 28, 0, 29, 0, 30, 0, 32, 0, 33, 0, 34, 0, 35, 0, 38, 0, 39, 0,
  40, 0, 41, 0, 42, 0, 2, 0,

  // L=44
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 8, 2, 14, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 14, 1,
  15, 1, 16, 1, 17, 1, 20, 1, 21, 1, 26, 1, 32, 1, 39, 1, 3, 0, 4, 0, 5, 0, 6, 0,
  7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0,
  27, 0, 28, 0, 29, 0, 30, 0, 32, 0, 33, 0, 34, 0, 35, 0, 36, 0, 39, 0, 40, 0,
  41, 0, 42, 0, 43, 0, 2, 0,

  // L=45
  2, 5, 2, 4, 2, 3, 3, 3, 3, 2, 4, 2,
  5, 2, 8, 2, 14, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 14, 1,
  15, 1, 16, 1, 20, 1, 21, 1, 26, 1, 27, 1, 33, 1, 40, 1, 3, 0, 4, 0, 5, 0, 6, 0,
  7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 19, 0, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0,
  27, 0, 28, 0, 29, 0, 30, 0, 33, 0, 34, 0, 35, 0, 36, 0, 37, 0, 40, 0, 41, 0,
  42, 0, 43, 0, 44, 0, 2, 0,

  // L=46
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 2,
  8, 2, 14, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 14, 1, 15, 1,
  16, 1, 20, 1, 21, 1, 27, 1, 28, 1, 34, 1, 41, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0,
  8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0,
  28, 0, 29, 0, 30, 0, 31, 0, 34, 0, 35, 0, 36, 0, 37, 0, 38, 0, 41, 0, 42, 0,
  43, 0, 44, 0, 45, 0, 2, 0,

  // L=47
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 2,
  8, 2, 14, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 14, 1, 15, 1,
  16, 1, 21, 1, 22, 1, 28, 1, 29, 1, 35, 1, 42, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0,
  8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0,
  28, 0, 29, 0, 30, 0, 31, 0, 32, 0, 35, 0, 36, 0, 37, 0, 38, 0, 39, 0, 42, 0,
  43, 0, 44, 0, 45, 0, 2, 0,

  // L=48
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 2,
  8, 2, 15, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 15, 1, 16, 1,
  17, 1, 22, 1, 23, 1, 29, 1, 30, 1, 36, 1, 43, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0,
  8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0,
  28, 0, 29, 0, 30, 0, 31, 0, 32, 0, 33, 0, 36, 0, 37, 0, 38, 0, 39, 0, 43, 0,
  44, 0, 45, 0, 46, 0, 2, 0,

  // L=49
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 2,
  8, 2, 15, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 15, 1, 16, 1,
  17, 1, 22, 1, 23, 1, 29, 1, 30, 1, 36, 1, 43, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0,
  8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0,
  29, 0, 30, 0, 31, 0, 32, 0, 33, 0, 36, 0, 37, 0, 38, 0, 39, 0, 43, 0, 44, 0,
  45, 0, 46, 0, 47, 0, 2, 0,

  // L=50
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 2,
  8, 2, 15, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 15, 1, 16, 1,
  17, 1, 22, 1, 23, 1, 29, 1, 30, 1, 36, 1, 44, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0,
  8, 0, 9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 20, 0, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0,
  29, 0, 30, 0, 31, 0, 32, 0, 33, 0, 36, 0, 37, 0, 38, 0, 39, 0, 40, 0, 44, 0,
  45, 0, 46, 0, 47, 0, 2, 0,

  // L=51
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 2,
  8, 2, 15, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 15, 1, 16, 1,
  22, 1, 23, 1, 29, 1, 30, 1, 37, 1, 45, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0,
  9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 21, 0, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 29, 0,
  30, 0, 31, 0, 32, 0, 33, 0, 37, 0, 38, 0, 39, 0, 40, 0, 41, 0, 45, 0, 46, 0,
  47, 0, 48, 0, 49, 0, 2, 0,

  // L=52
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 8, 2,
  15, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 15, 1, 16, 1, 17, 1, 22, 1,
  23, 1, 30, 1, 31, 1, 38, 1, 46, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0,
  10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 30, 0,
  31, 0, 32, 0, 33, 0, 34, 0, 38, 0, 39, 0, 40, 0, 41, 0, 42, 0, 46, 0, 47, 0,
  48, 0, 49, 0, 50, 0, 2, 0,

  // L=53
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 8, 2,
  15, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 15, 1, 16, 1, 17, 1, 23, 1,
  24, 1, 31, 1, 32, 1, 39, 1, 47, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0,
  10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 22, 0, 23, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0,
  31, 0, 32, 0, 33, 0, 34, 0, 35, 0, 39, 0, 40, 0, 41, 0, 42, 0, 43, 0, 47, 0,
  48, 0, 49, 0, 50, 0, 2, 0,

  // L=54
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 8, 2,
  16, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 16, 1, 17, 1, 18, 1,
  24, 1, 25, 1, 32, 1, 33, 1, 40, 1, 48, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0,
  9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 22, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0,
  32, 0, 33, 0, 34, 0, 35, 0, 36, 0, 40, 0, 41, 0, 42, 0, 43, 0, 44, 0, 48, 0,
  49, 0, 50, 0, 51, 0, 2, 0,

  // L=55
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 8, 2,
  16, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 16, 1, 17, 1, 18, 1,
  24, 1, 25, 1, 32, 1, 33, 1, 40, 1, 48, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0,
  9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 22, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0,
  32, 0, 33, 0, 34, 0, 35, 0, 36, 0, 40, 0, 41, 0, 42, 0, 43, 0, 48, 0, 49, 0,
  50, 0, 51, 0, 52, 0, 2, 0,

  // L=56
  2, 5, 2, 4, 2, 3, 3, 2, 4, 2, 8, 2,
  16, 2, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 16, 1, 17, 1, 18, 1,
  24, 1, 25, 1, 32, 1, 33, 1, 40, 1, 49, 1, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0,
  9, 0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0,
  1, 11, 1, 10, 1, 9, 1, 8, 1, 7, 1, 6, 1, 5, 1, 4, 1, 3, 1, 2, 1, 1,
  1, 0, 2, 2, 2, 1, 22, 0, 24, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0,
  32, 0, 33, 0, 34, 0, 35, 0, 36, 0, 40, 0, 41, 0, 42, 0, 43, 0, 44, 0, 49, 0,
  50, 0, 51, 0, 52, 0, 2, 0
};

/*
 * log magnitude residual block lengths
 */
const int ImbeJi[48][6] = {
  {1, 1, 1, 2, 2, 2},
  {1, 1, 2, 2, 2, 2},
  {1, 2, 2, 2, 2, 2},
  {2, 2, 2, 2, 2, 2},
  {2, 2, 2, 2, 2, 3},
  {2, 2, 2, 2, 3, 3},
  {2, 2, 2, 3, 3, 3},
  {2, 2, 3, 3, 3, 3},
  {2, 3, 3, 3, 3, 3},
  {3, 3, 3, 3, 3, 3},
  {3, 3, 3, 3, 3, 4},
  {3, 3, 3, 3, 4, 4},
  {3, 3, 3, 4, 4, 4},
  {3, 3, 4, 4, 4, 4},
  {3, 4, 4, 4, 4, 4},
  {4, 4, 4, 4, 4, 4},
  {4, 4, 4, 4, 4, 5},
  {4, 4, 4, 4, 5, 5},
  {4, 4, 4, 5, 5, 5},
  {4, 4, 5, 5, 5, 5},
  {4, 5, 5, 5, 5, 5},
  {5, 5, 5, 5, 5, 5},
  {5, 5, 5, 5, 5, 6},
  {5, 5, 5, 5, 6, 6},
  {5, 5, 5, 6, 6, 6},
  {5, 5, 6, 6, 6, 6},
  {5, 6, 6, 6, 6, 6},
  {6, 6, 6, 6, 6, 6},
  {6, 6, 6, 6, 6, 7},
  {6, 6, 6, 6, 7, 7},
  {6, 6, 6, 7, 7, 7},
  {6, 6, 7, 7, 7, 7},
  {6, 7, 7, 7, 7, 7},
  {7, 7, 7, 7, 7, 7},
  {7, 7, 7, 7, 7, 8},
  {7, 7, 7, 7, 8, 8},
  {7, 7, 7, 8, 8, 8},
  {7, 7, 8, 8, 8, 8},
  {7, 8, 8, 8, 8, 8},
  {8, 8, 8, 8, 8, 8},
  {8, 8, 8, 8, 8, 9},
  {8, 8, 8, 8, 9, 9},
  {8, 8, 8, 9, 9, 9},
  {8, 8, 9, 9, 9, 9},
  {8, 9, 9, 9, 9, 9},
  {9, 9, 9, 9, 9, 9},
  {9, 9, 9, 9, 9, 10},
  {9, 9, 9, 9, 10, 10}
};

#endif
