// @HEADER
// *****************************************************************************
//             Xpetra: A linear algebra interface package
//
// Copyright 2012 NTESS and the Xpetra contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

#ifndef XPETRA_ROWGRAPH_HPP
#define XPETRA_ROWGRAPH_HPP

/* this file is automatically generated - do not edit (see script/interfaces.py) */

#include <Teuchos_Describable.hpp>
#include <Tpetra_KokkosCompat_DefaultNode.hpp>
#include "Xpetra_ConfigDefs.hpp"
#include "Xpetra_Map.hpp"
#include "Xpetra_Import.hpp"
#include "Xpetra_Export.hpp"

namespace Xpetra {

template <class LocalOrdinal,
          class GlobalOrdinal,
          class Node = Tpetra::KokkosClassic::DefaultNode::DefaultNodeType>
class RowGraph
  : virtual public Teuchos::Describable {
 public:
  typedef LocalOrdinal local_ordinal_type;
  typedef GlobalOrdinal global_ordinal_type;
  typedef Node node_type;

  //! @name Constructor/Destructor Methods
  //@{

  //! Destructor.
  virtual ~RowGraph() {}

  //@}

  //! @name Graph Query Methods
  //@{

  //! Returns the communicator.
  virtual const Teuchos::RCP<const Teuchos::Comm<int> > getComm() const = 0;

  //! Returns the Map that describes the row distribution in this graph.
  virtual const Teuchos::RCP<const Map<LocalOrdinal, GlobalOrdinal, Node> > getRowMap() const = 0;

  //! Returns the Map that describes the column distribution in this graph.
  virtual const Teuchos::RCP<const Map<LocalOrdinal, GlobalOrdinal, Node> > getColMap() const = 0;

  //! Returns the Map associated with the domain of this graph.
  virtual const Teuchos::RCP<const Map<LocalOrdinal, GlobalOrdinal, Node> > getDomainMap() const = 0;

  //! Returns the Map associated with the domain of this graph.
  virtual const Teuchos::RCP<const Map<LocalOrdinal, GlobalOrdinal, Node> > getRangeMap() const = 0;

  //! Returns the importer associated with this graph.
  virtual Teuchos::RCP<const Import<LocalOrdinal, GlobalOrdinal, Node> > getImporter() const = 0;

  //! Returns the exporter associated with this graph.
  virtual Teuchos::RCP<const Export<LocalOrdinal, GlobalOrdinal, Node> > getExporter() const = 0;

  //! Returns the number of global rows in the graph.
  virtual global_size_t getGlobalNumRows() const = 0;

  //! Returns the number of global columns in the graph.
  virtual global_size_t getGlobalNumCols() const = 0;

  //! Returns the number of rows owned on the calling node.
  virtual size_t getLocalNumRows() const = 0;

  //! Returns the number of columns connected to the locally owned rows of this graph.
  virtual size_t getLocalNumCols() const = 0;

  //! Returns the index base for global indices for this graph.
  virtual GlobalOrdinal getIndexBase() const = 0;

  //! Returns the global number of entries in the graph.
  virtual global_size_t getGlobalNumEntries() const = 0;

  //! Returns the local number of entries in the graph.
  virtual size_t getNodeNumEntries() const = 0;

  //! Returns the current number of entries on this node in the specified global row.
  virtual size_t getNumEntriesInGlobalRow(GlobalOrdinal globalRow) const = 0;

  //! Returns the current number of entries on this node in the specified local row.
  virtual size_t getNumEntriesInLocalRow(LocalOrdinal localRow) const = 0;

  //! Returns the maximum number of entries across all rows/columns on all nodes.
  virtual size_t getGlobalMaxNumRowEntries() const = 0;

  //! Returns the maximum number of entries across all rows/columns on this node.
  virtual size_t getLocalMaxNumRowEntries() const = 0;

  //! Indicates whether the graph has a well-defined column map.
  virtual bool hasColMap() const = 0;

  //! If graph indices are in the local range, this function returns true. Otherwise, this function returns false. */.
  virtual bool isLocallyIndexed() const = 0;

  //! If graph indices are in the global range, this function returns true. Otherwise, this function returns false. */.
  virtual bool isGloballyIndexed() const = 0;

  //! Returns true if fillComplete() has been called.
  virtual bool isFillComplete() const = 0;

  //@}

  //! @name Extraction Methods
  //@{

  //! Extract a list of entries in a specified global row of the graph. Put into pre-allocated storage.
  virtual void getGlobalRowCopy(GlobalOrdinal GlobalRow, const Teuchos::ArrayView<GlobalOrdinal> &Indices, size_t &NumIndices) const = 0;

  //! Extract a list of entries in a specified local row of the graph. Put into storage allocated by calling routine.
  virtual void getLocalRowCopy(LocalOrdinal LocalRow, const Teuchos::ArrayView<LocalOrdinal> &Indices, size_t &NumIndices) const = 0;

  //@}

};  // RowGraph class

}  // namespace Xpetra

#define XPETRA_ROWGRAPH_SHORT
#endif  // XPETRA_ROWGRAPH_HPP
