/*
 * Copyright (C) 2002     Manuel Novoa III
 * Copyright (C) 2000-2005 Erik Andersen <andersen@uclibc.org>
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 */

#include <features.h>

#ifdef __UCLIBC_HAS_ERRNO_MESSAGES__

attribute_hidden
const char _string_syserrmsgs[] = {
	/*   0:    0,  8 */ "Success\0"
	/*   1:    8, 24 */ "Operation not permitted\0"
	/*   2:   32, 26 */ "No such file or directory\0"
	/*   3:   58, 16 */ "No such process\0"
	/*   4:   74, 24 */ "Interrupted system call\0"
	/*   5:   98, 19 */ "Input/output error\0"
	/*   6:  117, 26 */ "No such device or address\0"
	/*   7:  143, 23 */ "Argument list too long\0"
	/*   8:  166, 18 */ "Exec format error\0"
	/*   9:  184, 20 */ "Bad file descriptor\0"
	/*  10:  204, 19 */ "No child processes\0"
	/*  11:  223, 33 */ "Resource temporarily unavailable\0"
	/*  12:  256, 23 */ "Cannot allocate memory\0"
	/*  13:  279, 18 */ "Permission denied\0"
	/*  14:  297, 12 */ "Bad address\0"
	/*  15:  309, 22 */ "Block device required\0"
	/*  16:  331, 24 */ "Device or resource busy\0"
	/*  17:  355, 12 */ "File exists\0"
	/*  18:  367, 26 */ "Invalid cross-device link\0"
	/*  19:  393, 15 */ "No such device\0"
	/*  20:  408, 16 */ "Not a directory\0"
	/*  21:  424, 15 */ "Is a directory\0"
	/*  22:  439, 17 */ "Invalid argument\0"
	/*  23:  456, 30 */ "Too many open files in system\0"
	/*  24:  486, 20 */ "Too many open files\0"
	/*  25:  506, 31 */ "Inappropriate ioctl for device\0"
	/*  26:  537, 15 */ "Text file busy\0"
	/*  27:  552, 15 */ "File too large\0"
	/*  28:  567, 24 */ "No space left on device\0"
	/*  29:  591, 13 */ "Illegal seek\0"
	/*  30:  604, 22 */ "Read-only file system\0"
	/*  31:  626, 15 */ "Too many links\0"
	/*  32:  641, 12 */ "Broken pipe\0"
	/*  33:  653, 33 */ "Numerical argument out of domain\0"
	/*  34:  686, 30 */ "Numerical result out of range\0"
	/*  35:  716, 26 */ "Resource deadlock avoided\0"
	/*  36:  742, 19 */ "File name too long\0"
	/*  37:  761, 19 */ "No locks available\0"
	/*  38:  780, 25 */ "Function not implemented\0"
	/*  39:  805, 20 */ "Directory not empty\0"
	/*  40:  825, 34 */ "Too many levels of symbolic links\0"
	/*  41:  859,  1 */ "\0"
	/*  42:  860, 27 */ "No message of desired type\0"
	/*  43:  887, 19 */ "Identifier removed\0"
	/*  44:  906, 28 */ "Channel number out of range\0"
	/*  45:  934, 25 */ "Level 2 not synchronized\0"
	/*  46:  959, 15 */ "Level 3 halted\0"
	/*  47:  974, 14 */ "Level 3 reset\0"
	/*  48:  988, 25 */ "Link number out of range\0"
	/*  49: 1013, 29 */ "Protocol driver not attached\0"
	/*  50: 1042, 27 */ "No CSI structure available\0"
	/*  51: 1069, 15 */ "Level 2 halted\0"
	/*  52: 1084, 17 */ "Invalid exchange\0"
	/*  53: 1101, 27 */ "Invalid request descriptor\0"
	/*  54: 1128, 14 */ "Exchange full\0"
	/*  55: 1142,  9 */ "No anode\0"
	/*  56: 1151, 21 */ "Invalid request code\0"
	/*  57: 1172, 13 */ "Invalid slot\0"
	/*  58: 1185,  1 */ "\0"
	/*  59: 1186, 21 */ "Bad font file format\0"
	/*  60: 1207, 20 */ "Device not a stream\0"
	/*  61: 1227, 18 */ "No data available\0"
	/*  62: 1245, 14 */ "Timer expired\0"
	/*  63: 1259, 25 */ "Out of streams resources\0"
	/*  64: 1284, 30 */ "Machine is not on the network\0"
	/*  65: 1314, 22 */ "Package not installed\0"
	/*  66: 1336, 17 */ "Object is remote\0"
	/*  67: 1353, 22 */ "Link has been severed\0"
	/*  68: 1375, 16 */ "Advertise error\0"
	/*  69: 1391, 14 */ "Srmount error\0"
	/*  70: 1405, 28 */ "Communication error on send\0"
	/*  71: 1433, 15 */ "Protocol error\0"
	/*  72: 1448, 19 */ "Multihop attempted\0"
	/*  73: 1467, 19 */ "RFS specific error\0"
	/*  74: 1486, 12 */ "Bad message\0"
	/*  75: 1498, 38 */ "Value too large for defined data type\0"
	/*  76: 1536, 27 */ "Name not unique on network\0"
	/*  77: 1563, 29 */ "File descriptor in bad state\0"
	/*  78: 1592, 23 */ "Remote address changed\0"
	/*  79: 1615, 39 */ "Can not access a needed shared library\0"
	/*  80: 1654, 37 */ "Accessing a corrupted shared library\0"
	/*  81: 1691, 32 */ ".lib section in a.out corrupted\0"
	/*  82: 1723, 48 */ "Attempting to link in too many shared libraries\0"
	/*  83: 1771, 38 */ "Cannot exec a shared library directly\0"
	/*  84: 1809, 50 */ "Invalid or incomplete multibyte or wide character\0"
	/*  85: 1859, 44 */ "Interrupted system call should be restarted\0"
	/*  86: 1903, 19 */ "Streams pipe error\0"
	/*  87: 1922, 15 */ "Too many users\0"
	/*  88: 1937, 31 */ "Socket operation on non-socket\0"
	/*  89: 1968, 29 */ "Destination address required\0"
	/*  90: 1997, 17 */ "Message too long\0"
	/*  91: 2014, 31 */ "Protocol wrong type for socket\0"
	/*  92: 2045, 23 */ "Protocol not available\0"
	/*  93: 2068, 23 */ "Protocol not supported\0"
	/*  94: 2091, 26 */ "Socket type not supported\0"
	/*  95: 2117, 24 */ "Operation not supported\0"
	/*  96: 2141, 30 */ "Protocol family not supported\0"
	/*  97: 2171, 41 */ "Address family not supported by protocol\0"
	/*  98: 2212, 23 */ "Address already in use\0"
	/*  99: 2235, 32 */ "Cannot assign requested address\0"
	/* 100: 2267, 16 */ "Network is down\0"
	/* 101: 2283, 23 */ "Network is unreachable\0"
	/* 102: 2306, 36 */ "Network dropped connection on reset\0"
	/* 103: 2342, 33 */ "Software caused connection abort\0"
	/* 104: 2375, 25 */ "Connection reset by peer\0"
	/* 105: 2400, 26 */ "No buffer space available\0"
	/* 106: 2426, 40 */ "Transport endpoint is already connected\0"
	/* 107: 2466, 36 */ "Transport endpoint is not connected\0"
	/* 108: 2502, 46 */ "Cannot send after transport endpoint shutdown\0"
	/* 109: 2548, 35 */ "Too many references: cannot splice\0"
	/* 110: 2583, 21 */ "Connection timed out\0"
	/* 111: 2604, 19 */ "Connection refused\0"
	/* 112: 2623, 13 */ "Host is down\0"
	/* 113: 2636, 17 */ "No route to host\0"
	/* 114: 2653, 30 */ "Operation already in progress\0"
	/* 115: 2683, 26 */ "Operation now in progress\0"
	/* 116: 2709, 22 */ "Stale NFS file handle\0"
	/* 117: 2731, 25 */ "Structure needs cleaning\0"
	/* 118: 2756, 28 */ "Not a XENIX named type file\0"
	/* 119: 2784, 30 */ "No XENIX semaphores available\0"
	/* 120: 2814, 21 */ "Is a named type file\0"
	/* 121: 2835, 17 */ "Remote I/O error\0"
	/* 122: 2852, 20 */ "Disk quota exceeded\0"
	/* 123: 2872, 16 */ "No medium found\0"
	/* 124: 2888, 18 */ "Wrong medium type"
#if defined(__mips__) || defined(__sparc__)
	"\0"
	/* 125: 2906, 28 */ "File locking deadlock error"
#endif
	/* Note: for mips we are ignoring ECANCELED since glibc doesn't have a
	 * corresponsding message.*/
};

#endif
