##### http://autoconf-archive.cryp.to/ax_lang_compiler_ms.html
#
# SYNOPSIS
#
#   AX_LANG_COMPILER_MS
#
# DESCRIPTION
#
#   Check whether the compiler for the current language is Microsoft.
#
#   This macro is modeled after _AC_LANG_COMPILER_GNU in the GNU
#   Autoconf implementation.
#
# LAST MODIFICATION
#
#   2004-11-15
#
# COPYLEFT
#
#   Copyright (c) 2004 Braden McDaniel <braden@endoframe.com>
#
#   Copying and distribution of this file, with or without
#   modification, are permitted in any medium without royalty provided
#   the copyright notice and this notice are preserved.

AC_DEFUN([AX_LANG_COMPILER_MS],
[AC_CACHE_CHECK([whether we are using the Microsoft _AC_LANG compiler],
                [ax_cv_[]_AC_LANG_ABBREV[]_compiler_ms],
[AC_COMPILE_IFELSE([AC_LANG_PROGRAM([], [[#ifndef _MSC_VER
       choke me
#endif
]])],
                   [ax_compiler_ms=yes],
                   [ax_compiler_ms=no])
ax_cv_[]_AC_LANG_ABBREV[]_compiler_ms=$ax_compiler_ms
])])
